<?php

/*
  MailBeez Automatic Trigger Email Campaigns
  http://www.mailbeez.com

  Copyright (c) 2010 - 2012 MailBeez

  inspired and in parts based on
  Copyright (c) 2003 osCommerce

  Released under the GNU General Public License

 */


///////////////////////////////////////////////////////////////////////////////
///																																					 //
///                 MailBeez Core file - do not edit                         //
///                                                                          //
///////////////////////////////////////////////////////////////////////////////
require_once(MH_DIR_FS_CATALOG . MH_ROOT_PATH . 'common/classes/mailbeez_cache.php');


class gdprbeez extends mailbeez_cache
{

    var $sort_order;
    var $contact_id;
    var $code;

    /**
     * @return string
     */
    public function getCode()
    {
        return $this->code;
    }

    /**
     * @return integer
     */
    public function getContactId()
    {
        return $this->contact_id;
    }

    /**
     * @param integer $contact_id
     */
    public function setContactId($contact_id)
    {
        $this->contact_id = (int)$contact_id;
    }

// class constructor
    function __construct()
    {
        parent::__construct();
        $this->code = ''; // unique id for report-module
        $this->module = ''; //
        $this->title = '';
        $this->description = '';
        $this->sort_order = 1;
        $this->enabled = true;
        $this->description_image = 'icon_big.png';
        $this->icon = 'icon.png';
        $this->icon_dashboard = 'icon_dashboard.png';
        $this->prospect_enabled = false;
        $this->customer_enabled = true;
        $this->storedata = false;
        $this->session_cache_time = 60;
        $this->app_cache_time = 60;

        return true;
    }

    public function getData()
    {
        $data = $this->readData();

        return $data;
    }


    public function readData()
    {
        return array();
    }

    /**
     * @param $sql
     * @return array
     */
    public function _db($sql)
    {
        $query = mh_db_query($sql);

        $result = array();
        while ($row = mh_db_fetch_array($query)) {
            $row = array_map( 'html_entity_decode', $row );
            $row = array_map( 'strip_tags', $row );
            $result[] = $row;
        }
        return $result;
    }

    public function buildColumns($data_columns_raw)
    {
        $sql_columns = array();
        foreach ($data_columns_raw as $table => $columns_data) {
            $columns_exist = mh_db_check_field_exists($table, array_keys($columns_data['fields']));
            foreach ($columns_exist as $col) {
                $sql = "{$columns_data['alias']}.$col";
                if ($columns_data['fields'][$col] != '') {
                    $sql .= " as {$columns_data['fields'][$col]} ";
                }
                $sql_columns[] = $sql;
            }
        }

        return implode(', ', $sql_columns);
    }


    public function mergeLine($item)
    {
        $line = '';
        foreach ($item as $key => $value) {
            $l = "$key: $value, ";
            $l = preg_replace('/\s+/S', " ", $l);
            $line .= $l;
        }
        return $line;
    }

    public function flatten($data, $name) {
        $result = array();
        $cnt = 1;
        foreach ($data as $row) {
            $result[$name . '-' . $cnt] = $this->mergeLine($row);
            $cnt++;
        }
        return array($result);
    }
}

// end of class
