<?php

/*
  MailBeez Automatic Trigger Email Campaigns
  http://www.mailbeez.com

  Copyright (c) 2010 - 2012 MailBeez

  Licensing Terms & Other Conditions of this
  Mailbeez Module:

  Unless you have our prior written consent, you must NOT directly or indirectly license,
  sub-license, sell, resell, or provide for free or make an offer to do any of these things.
  All of these things are strictly prohibited with this MailBeez Pro Module.

  One Purchase for one Shop - please contact cord@mailbeez.com for volume discounts and
  reseller agreements.

  OpenSource but not free - please respect this license agreement.

 */

// make path work from admin

require_once(MH_DIR_FS_CATALOG . MH_ROOT_PATH . 'common/classes/configbeez.php');

if (!class_exists('Shopvoting')) {
    require_once(MH_DIR_CONFIG . 'config_shopvoting/classes/Shopvoting.php');
}

class config_shopvoting extends configbeez
{
    // class constructor
    function __construct()
    {
        // call constructor
        parent::__construct();

        // set some stuff:
        $this->code = 'config_shopvoting';
        $this->module = 'config_shopvoting'; // same as folder name
        $this->version = 4.4; // float value
        $this->required_mb_version = 2.99; // required mailbeez version
        $this->title = mh_lng('MAILBEEZ_SHOPVOTING_TEXT_TITLE');
        $this->description = mh_lng('MAILBEEZ_SHOPVOTING_TEXT_DESCRIPTION');
        $this->icon = 'icon.png';
        $this->sort_order = 50;
        $this->enabled = mh_cfg('MAILBEEZ_SHOPVOTING_STATUS') == 'True';
        $this->status_key = 'MAILBEEZ_SHOPVOTING_STATUS';
        $this->common_admin_action_plugins = '';

        $this->documentation_key = $this->module; // leave empty if no documentation available
        // $this->documentation_root = 'http:://yoursite.com/' // modify documentation root if necessary

        $this->admin_action_plugins_path = MH_DIR_CONFIG; // default-path to include admin action plugins from
        $this->admin_action_plugins = 'manage_shopvotings.php';

        // self installing
        if (!mh_cfg($this->status_key)) {
            //$this->install();
        } else {
            $this->check_update();
        }

    }

    function config_shopvoting()
    {
        self::__construct();
    }
// class methods


    // installation methods

    function keys()
    {
        if (isset($this->keys)) return $this->keys;

        return array('MAILBEEZ_SHOPVOTING_STATUS');
    }

    function install()
    {
        mh_insert_config_value(array('configuration_title' => 'Activate Customer Insight?',
            'configuration_key' => 'MAILBEEZ_SHOPVOTING_STATUS',
            'configuration_value' => 'True',
            'configuration_description' => 'Do you want to activate the Customer Insight Module?',
            'set_function' => 'mh_cfg_select_option(array(\'True\', \'False\'), '
        ));

        mh_db_query("CREATE TABLE IF NOT EXISTS " . DB_PREFIX . "web4design_de_shopreviews (
              shopreviews_id int(11) NOT NULL AUTO_INCREMENT,
              shopreviews_firstname varchar(32)  NOT NULL,
              shopreviews_lastname varchar(32)  NOT NULL,
              shopreview_customers_id int(11) NOT NULL,
              shopreviews_date datetime NOT NULL,
              shopreviews_shoprating int(1) NOT NULL,
              shopreviews_page int(1) NOT NULL,
              shopreviews_delivery int(1) NOT NULL,
              shopreviews_products int(1) NOT NULL,
              shopreviews_service int(1) NOT NULL,
              shopreviews_text text  NOT NULL,
              shopreviews_admin_comment text  NOT NULL,
              shopreviews_language tinyint(1) NOT NULL,
              shopreviews_ip varchar(15)  NOT NULL,
              shopreviews_status int(1) NOT NULL,
              shopreviews_email varchar(96)  NOT NULL,
              shopreviews_orders_id int(1) NOT NULL,
              PRIMARY KEY (shopreviews_id)
        );");


        mh_db_query("DROP TABLE IF EXISTS " . DB_PREFIX . "web4design_de_shopreviews_config;");
        mh_db_query("CREATE TABLE " . DB_PREFIX . "web4design_de_shopreviews_config (
              id int(11) NOT NULL AUTO_INCREMENT,
              config_key varchar(255) NOT NULL,
              value text NOT NULL,
              config_group int(1) NOT NULL,
              PRIMARY KEY (id)
            );");


        mh_db_query("INSERT INTO " . DB_PREFIX . "web4design_de_shopreviews_config (id, config_key, value, config_group) VALUES
                (1, 'admin_email', '', 100),
                (2, 'send_admin_email', '0', 100),
                (3, 'customer_group_read', '', 100),
                (4, 'customer_group_write', '', 100),
                (5, 'customer_group_captcha', '', 100),
                (6, 'entry_per_page_frontend', '10', 100),
                (7, 'voting_module_active', '0', 100),
                (8, 'front_page_character', '', 100),
                (9, 'required_name', '0', 100),
                (10, 'required_order_id', '0', 100),
                (11, 'required_comment', '0', 100),
                (12, 'activate_votings', '0', 100),
                (13, 'required_order_id_email', '0', 100),
                (14, 'block_order_number', '0', 100),
                (15, 'send_mail_after', '0', 100),
                (17, 'coupon_code_check', '0', 100),
                (18, 'coupon_code', '', 100),
                (19, 'snippet_author', '', 400),
                (20, 'about_us_id', '0', 100),
                (21, 'show_all_languages', '0', 100),
                (23, 'badwords', '0', 100),
                (24, 'badwords_text', '', 200),
                (25, 'template_box_character', '50', 300),
                (26, 'obligation_delivery', '0', 100),
                (27, 'obligation_products', '0', 100),
                (29, 'obligation_service', '0', 100),
                (30, 'obligation_page', '0', 100),
                (31, 'email_domain_subject', '', 100),
                (32, 'logo_url', '', 100),
                (33, 'template_box_show_text', '', 300),
                (34, 'template_box_show_total', '', 300),
                (35, 'template_box_show_snippets', '0', 400),
                (36, 'template_box_show_link', '0', 300),
                (37, 'template_style', 'standard', 300),
                (38, 'privacy_checkbox', '0', 100),
                (39, 'privacy_show_text', '0', 100),
                (40, 'privacy_content_id', '0', 100),
                (41, 'privacy_save_ip', '0', 100),
                (42, 'snippet_type_name', '', 400);"); 



        mh_db_query("CREATE TABLE IF NOT EXISTS " . DB_PREFIX . "web4design_de_shopreviews_pageinfo (
                id int(10) unsigned NOT NULL AUTO_INCREMENT,
                title varchar(255) NOT NULL,
                meta_description varchar(255) NOT NULL,
                meta_keywords varchar(255) NOT NULL,
                itemprop_name varchar(100) NOT NULL,
                languages_id int(1) unsigned NOT NULL,
                PRIMARY KEY (id)
                );");


        // values do not exists yet
        // -> moved into Shopvoting::_readMeta()
        //mh_db_query("UPDATE " . DB_PREFIX . "web4design_de_shopreviews_pageinfo SET itemprop_name = 'Shopreview' WHERE id = 1");
        //mh_db_query("UPDATE " . DB_PREFIX . "web4design_de_shopreviews_pageinfo SET itemprop_name = 'Shopbewertung' WHERE id = 2");

        if (MH_PLATFORM == 'xtc' || MH_PLATFORM == 'gambio') {

            // gambio has removed TABLE_ADMIN_ACCESS from storefront context...
            if (!defined('TABLE_ADMIN_ACCESS')) {
                define('TABLE_ADMIN_ACCESS', 'admin_access');
            };


            // xtc SP1 compatibility
            $field_info = mh_db_check_field_exists(TABLE_LANGUAGES, 'status');

            if ($field_info == false) {
                $sql = array();
                $sql[] = "ALTER TABLE " . TABLE_LANGUAGES . " ADD status INT(1) NOT NULL ;";
                mh_db_add_field(TABLE_LANGUAGES, 'bewertungen_template', $sql);
                mh_db_query("UPDATE " . TABLE_LANGUAGES . " SET status = '1' WHERE languages_id = 1");
                mh_db_query("UPDATE " . TABLE_LANGUAGES . " SET status = '1' WHERE languages_id = 2");
            }

            if (MH_PLATFORM_GAMBIO >= 2.3) {
                if (mh_db_check_table_exists('gm_boxes')) {
                    mh_db_query("INSERT INTO gm_boxes (template_name, box_name, position, box_status)
                                VALUES('EyeCandy', 'mailbeez_shopvoting', 'gm_box_pos_80', 1);");
                    mh_db_query("delete from gm_boxes where template_name = 'gambio' and box_name = 'voting'");
                }
                // gambio template no longer supported
//                mh_db_query("INSERT INTO gm_boxes (boxes_id,  template_name, box_name, position, box_status) VALUES(80, 'gambio', 'voting', 'gm_box_pos_148', 1);");
            }
        }

        $this->update($this->version);
    }

    function remove()
    {
        $default_keys = $this->keys();
        $this->keys = array_merge($default_keys, array(''));

        if (MH_PLATFORM_GAMBIO >= 2.3) {
            if (mh_db_check_table_exists('gm_boxes')) {
                mh_db_query("delete from gm_boxes where template_name = 'mailbeez_shopvoting'");
            }
        }

        parent::remove();
    }

    function update($installed_version = null)
    {
        // only insert if not set yet
        $configSql = mh_db_query("SELECT * FROM " . DB_PREFIX . "web4design_de_shopreviews_config where config_key='logo_url'");

        if (mh_db_num_rows($configSql) == 0) {
            if (file_exists(MH_DIR_WS_CATALOG . MH_ROOT_PATH . 'configbeez/config_shopvoting/templates/img/logo.png')) {
                $default_logo_url = $GLOBALS['mh_template_replace_variables_common']['catalog_server_ssl'] . MH_ROOT_PATH . 'configbeez/config_shopvoting/templates/img/logo.png';
            } else {
                $default_logo_url = $GLOBALS['mh_template_replace_variables_common']['catalog_server_ssl'] . MH_ROOT_PATH . 'configbeez/config_shopvoting/templates/img/default_logo.png';
            }

            mh_db_query("INSERT INTO " . DB_PREFIX . "web4design_de_shopreviews_config (id, config_key, value, config_group) VALUES
                        (32, 'logo_url', '" . $default_logo_url . "', 100)");
        }


        if ($installed_version < 3.64) {
            mh_db_query("UPDATE " . DB_PREFIX . "web4design_de_shopreviews_config SET config_key = 'template_box_character' WHERE id =25;");
            mh_db_query("UPDATE " . DB_PREFIX . "web4design_de_shopreviews_config SET value = '50' WHERE id =25;");

            // mh_db_query("INSERT INTO " . DB_PREFIX . "web4design_de_shopreviews_config (id, config_key, value, config_group) VALUES (NULL, 'template_box_show_text', '1', '300');");
            // mh_db_query("INSERT INTO " . DB_PREFIX . "web4design_de_shopreviews_config (id, config_key, value, config_group) VALUES (NULL, 'template_box_show_total', '1', '300');");
        }

        if ($installed_version < 4.06) {
            mh_db_query("DELETE FROM " . DB_PREFIX . "web4design_de_shopreviews_config WHERE config_key = 'template_box_show_text'");
            mh_db_query("DELETE FROM " . DB_PREFIX . "web4design_de_shopreviews_config WHERE config_key = 'template_box_show_total'");

            mh_db_query("INSERT INTO " . DB_PREFIX . "web4design_de_shopreviews_config (id, config_key, value, config_group) VALUES (NULL, 'template_box_show_text', '1', '300');");
            mh_db_query("INSERT INTO " . DB_PREFIX . "web4design_de_shopreviews_config (id, config_key, value, config_group) VALUES (NULL, 'template_box_show_total', '1', '300');");
        }


        if ($installed_version < 4.09) {
            mh_db_query("INSERT INTO " . DB_PREFIX . "web4design_de_shopreviews_config (id, config_key, value, config_group) VALUES (NULL, 'template_box_show_snippets', '1', '300');");
            mh_db_query("INSERT INTO " . DB_PREFIX . "web4design_de_shopreviews_config (id, config_key, value, config_group) VALUES (NULL, 'template_box_show_link', '0', '300');");
        }

        if ($installed_version < 4.17) {

            mh_db_query("UPDATE " . DB_PREFIX . "web4design_de_shopreviews_config SET config_group = '400' WHERE config_key ='snippet_author';");
            mh_db_query("UPDATE " . DB_PREFIX . "web4design_de_shopreviews_config SET config_group = '400' WHERE config_key ='template_box_show_snippets';"); 

            mh_db_query("INSERT INTO " . DB_PREFIX . "web4design_de_shopreviews_config (id, config_key, value, config_group) VALUES (NULL, 'template_style', 'standard', '300');");
            mh_db_query("INSERT INTO " . DB_PREFIX . "web4design_de_shopreviews_config (id, config_key, value, config_group) VALUES (NULL, 'privacy_checkbox', '0', '100');");
            mh_db_query("INSERT INTO " . DB_PREFIX . "web4design_de_shopreviews_config (id, config_key, value, config_group) VALUES (NULL, 'privacy_show_text', '0', '100');");
            mh_db_query("INSERT INTO " . DB_PREFIX . "web4design_de_shopreviews_config (id, config_key, value, config_group) VALUES (NULL, 'privacy_content_id', '0', '100');");
            mh_db_query("INSERT INTO " . DB_PREFIX . "web4design_de_shopreviews_config (id, config_key, value, config_group) VALUES (NULL, 'privacy_save_ip', '0', '100');");
            mh_db_query("INSERT INTO " . DB_PREFIX . "web4design_de_shopreviews_config (id, config_key, value, config_group) VALUES (NULL, 'snippet_type_name', '', '400');");

         
        }


        if (MH_PLATFORM_GAMBIO >= 2.3) {

            if (mh_db_check_table_exists('gm_boxes')) {
                $query = mh_db_query("select * from gm_boxes where template_name = 'EyeCandy' and box_name = 'mailbeez_shopvoting'");

                if (mh_db_num_rows($query) == 0) {
                    mh_db_query("INSERT INTO gm_boxes (template_name, box_name, position, box_status)
                            VALUES('EyeCandy', 'mailbeez_shopvoting', 'gm_box_pos_80', 1);");
                }
            }

        }
        mh_smarty_clear_compile_dir();
        parent::update($this->version);
    }
}

