<?php
/**
 * Shop-Reviews
 *
 * @released under the GNU General Public License
 * inspired and in parts based on
 * Copyright (c) 2003 osCommerce
 * @author H-P Sausen
 * @copyright (c) since 2010 web4design.de
 * @contact webmaster@web4design.de
 * @version 3.0
 */
include(MH_DIR_CONFIG . 'config_shopvoting/admin/common.php');
/**
 * Update voting status
 */

if (mh_get('action') == 'statup' && mh_get('sid')) {
    $voting->setVotingStatus($_GET['status'], $_GET['sid']);
}
/**
 * Update voting and comment
 */
if (mh_post('modus') == 'editupdate') {
    $voting->setAdminVoting();
}

/**
 * Single and multi delete / update
 */
if (mh_post('action')) {
    $voting->setUpdateDeleteVoting($_POST['action']);
} elseif (mh_get('action') == "deletesingle") {
    $voting->setUpdateDeleteVoting($_GET['action'], $_GET['sid']);
}

?>
<?php
include(MH_DIR_CONFIG . 'config_shopvoting/admin/common_header.php');

$pagename = mh_get(MH_PAGE_NAME, '');
$page = mh_get('page', '');


?>

<div id="borderbox">
<?php echo mh_draw_form('shopvoting', shopvoting_admin_page_link(Shopvoting::FILENAME_SHOPREVIEW_MANAGE, MH_PAGE_NAME . '=' . $pagename, true), '', 'post'); ?>
<!--<form action="--><?php //echo shopvoting_admin_page_link(Shopvoting::FILENAME_SHOPREVIEW_MANAGE, MH_PAGE_NAME . '=' . mh_get(MH_PAGE_NAME)); ?><!--" method="post">-->


<div class="leftupdatebox">
    <select name="action" size="1" style="width: 180px;">
        <option value=""><?php echo WEB4DESIGN_DE_SR_SELECT_OPTION; ?></option>
    <optgroup label="<?php echo WEB4DESIGN_DE_SR_GROUP_STATUS_TITLE; ?>">
        <option value="aktivieren"><?php echo WEB4DESIGN_DE_SR_ACTIVATE; ?></option>
        <option value="deaktivieren"><?php echo WEB4DESIGN_DE_SR_DEACTIVATE; ?></option>
    </optgroup>
    <optgroup label="<?php echo WEB4DESIGN_DE_SR_GROUP_DELETE_TITLE; ?>">
    <option value="delete_selected_ips"><?php echo WEB4DESIGN_DE_SR_DELETE_SELECTED_IPS; ?></option>
    <option value="delete_all_ips"><?php echo WEB4DESIGN_DE_SR_DELETE_ALL_IPS; ?></option>
    <option value="">---------</option>
    <option value="delete"><?php echo WEB4DESIGN_DE_SR_DELETE; ?></option>
    </optgroup>    
        



    </select>
    <input type="hidden" name="page" value="<?php echo $page; ?>">
    <input type="submit" name="" value="<?php echo WEB4DESIGN_DE_SR_UPDATE; ?>" style="width: 100px;">
</div>
<!-- <p class="clrnone">&nbsp;</p> -->
<table class="maintab">
    <tr>
        <th width="4%" style="text-align:center"><input onClick="check_all('bcheck[]', this)" type="checkbox"></th>
        <th width="4%"><?php echo WEB4DESIGN_DE_SR_NO; ?></th>
        <th width="12%"><?php echo WEB4DESIGN_DE_SR_DATE; ?></th>
        <th width="20%"><?php echo WEB4DESIGN_DE_SR_USER; ?></th>
        <th width="5%"><?php echo WEB4DESIGN_DE_SR_SHOP; ?></th>
        <th width="5%"><?php echo WEB4DESIGN_DE_SR_PRODUCT; ?></th>
        <th width="5%"><?php echo WEB4DESIGN_DE_SR_DELIVERY; ?></th>
        <th width="5%"><?php echo WEB4DESIGN_DE_SR_SERVICE; ?></th>
        <th width="5%"><?php echo WEB4DESIGN_DE_SR_PAGE; ?></th>
        <th width="13%"><?php echo WEB4DESIGN_DE_SR_STATUS; ?></th>
        <th width="11%"><?php echo WEB4DESIGN_DE_SR_COMMENT; ?></th>
        <th width="4%" style="text-align:center;"><?php echo WEB4DESIGN_DE_SR_EDIT; ?></th>
        <th width="4%" style="text-align:center;"><?php echo WEB4DESIGN_DE_SR_DEL; ?></th>
    </tr>
    <?php
    $bewertung_query = $voting->getReviewSQL(false);
    $reviews_split = new splitPageResults(mh_get(MH_PAGE_NAME), 10, $bewertung_query, $reviews_query_numrows);

    $reviews_query = mh_db_query($bewertung_query);
    $i = 0;
    while ($reviews = mh_db_fetch_array($reviews_query)) {

        ?>
        <tr<?php if ($i == 1) {
            echo ' class="cyclecolor"';
        } ?>>
            <td style="text-align:center">
                <input type="checkbox" name="bcheck[]" value="<?php echo $reviews['shopreviews_id']; ?>">
            </td>
            <td><?php echo $reviews['shopreviews_id']; ?></td>
            <td><?php echo date('d.m.Y H:i', strtotime($reviews['shopreviews_date'])); ?></td>
            <td><?php echo mh_db_prepare_input($reviews['shopreviews_firstname']) . ' ' . mh_db_prepare_input($reviews['shopreviews_lastname']); ?></td>
            <td style="text-align: center;"><?php echo $reviews['shopreviews_shoprating']; ?></td>
            <td style="text-align: center;"><?php echo $reviews['shopreviews_products']; ?></td>
            <td style="text-align: center;"><?php echo $reviews['shopreviews_delivery']; ?></td>
            <td style="text-align: center;"><?php echo $reviews['shopreviews_service']; ?></td>
            <td style="text-align: center;"><?php echo $reviews['shopreviews_page']; ?></td>
            <td>
                <?php
                if ($reviews['shopreviews_status'] == 1) {
                    ?>
                    <img src="<?php echo $voting->admin_path_url; ?>images/greenactive.gif" alt="<?php echo WEB4DESIGN_DE_SR_ACTIVATED; ?>" title="<?php echo WEB4DESIGN_DE_SR_ACTIVATED; ?>"/>
                    <a href="<?php echo shopvoting_admin_page_link(Shopvoting::FILENAME_SHOPREVIEW_MANAGE, MH_PAGE_NAME . '=' . mh_get(MH_PAGE_NAME) . '&action=statup&status=0&sid=' . $reviews['shopreviews_id']); ?>">
                        <img src="<?php echo $voting->admin_path_url; ?>images/reddeactive.gif" alt="<?php echo WEB4DESIGN_DE_SR_DEACTIVATE; ?>" title="<?php echo WEB4DESIGN_DE_SR_DEACTIVATE; ?>"/></a>
                <?php } else { ?>
                    <a href="<?php echo shopvoting_admin_page_link(Shopvoting::FILENAME_SHOPREVIEW_MANAGE, MH_PAGE_NAME . '=' . mh_get(MH_PAGE_NAME) . '&action=statup&status=1&sid=' . $reviews['shopreviews_id']); ?>">
                        <img src="<?php echo $voting->admin_path_url; ?>images/greendeactive.gif" alt="<?php echo WEB4DESIGN_DE_SR_ACTIVATE; ?>" title="<?php echo WEB4DESIGN_DE_SR_ACTIVATE; ?>"/></a>
                    <img src="<?php echo $voting->admin_path_url; ?>images/redactive.gif" alt="<?php echo WEB4DESIGN_DE_SR_DEACTIVATED; ?>" title="<?php echo WEB4DESIGN_DE_SR_DEACTIVATED; ?>"/>
                <?php } ?>
            </td>
            <td>
                <a href="<?php echo shopvoting_admin_page_link(Shopvoting::FILENAME_SHOPREVIEW_MANAGE, MH_PAGE_NAME . '=' . mh_get(MH_PAGE_NAME) . '&action=rpreview&sid=' . $reviews['shopreviews_id']); ?>" style=" color: #c1841b;	font-weight: bold;"><?php echo WEB4DESIGN_DE_SR_PREVIEW_TITLE; ?></a>
            </td>
            <td style="text-align:center;">
                <?php if ($i == 1) { ?>
                    <a href="<?php echo shopvoting_admin_page_link(Shopvoting::FILENAME_SHOPREVIEW_MANAGE, MH_PAGE_NAME . '=' . mh_get(MH_PAGE_NAME) . '&action=rev_edit&sid=' . $reviews['shopreviews_id']); ?>">
                        <img src="<?php echo $voting->admin_path_url; ?>images/edit.png" alt="<?php echo mh_lng('EDIT'); ?>" title="<?php echo mh_lng('EDIT'); ?>"/></a>
                <?php } else { ?>
                    <a href="<?php echo shopvoting_admin_page_link(Shopvoting::FILENAME_SHOPREVIEW_MANAGE, MH_PAGE_NAME . '=' . mh_get(MH_PAGE_NAME) . '&action=rev_edit&sid=' . $reviews['shopreviews_id']); ?>">
                        <img src="<?php echo $voting->admin_path_url; ?>images/edit.png" alt="<?php echo mh_lng('EDIT'); ?>" title="<?php echo WEB4DESIGN_DE_SR_EDIT; ?>"/></a>
                <?php } ?>
            </td>
            <td style="text-align:center;">
                <?php if ($i == 1) { ?>
                    <a href="<?php echo shopvoting_admin_page_link(Shopvoting::FILENAME_SHOPREVIEW_MANAGE, MH_PAGE_NAME . '=' . mh_get(MH_PAGE_NAME) . '&action=deletesingle&sid=' . $reviews['shopreviews_id']); ?>">
                        <img src="<?php echo $voting->admin_path_url; ?>images/delete.png" alt="<?php echo mh_lng('DELETE'); ?>" title="<?php echo WEB4DESIGN_DE_SR_DELETE; ?>"/></a>
                    <?php $i = 0;
                } else {
                    ?>
                    <a href="<?php echo shopvoting_admin_page_link(Shopvoting::FILENAME_SHOPREVIEW_MANAGE, MH_PAGE_NAME . '=' . mh_get(MH_PAGE_NAME) . '&action=deletesingle&sid=' . $reviews['shopreviews_id']); ?>">
                        <img src="<?php echo $voting->admin_path_url; ?>images/delete.png" alt="<?php echo mh_lng('DELETE'); ?>" title="<?php echo WEB4DESIGN_DE_SR_DELETE; ?>"/></a>
                    <?php $i++;
                } ?>
            </td>
        </tr>
        <tr <?php if ($i == 0) {
            echo 'class="cyclecolor"';
        } ?>>
            <td class="bottomborder">&nbsp;</td>
            <td colspan="3" class="bottomborder">
                <strong><?php echo WEB4DESIGN_DE_SR_EMAIL; ?>:</strong> <?php echo mh_db_prepare_input($reviews['shopreviews_email']); ?>
                <br/>
                <strong><?php echo WEB4DESIGN_DE_SR_ORDER_NO; ?>:</strong>
                <?php
                if ($reviews['shopreviews_orders_id'] > 0) {
                    ?>
                    <a href="<?php echo mh_href_link(FILENAME_ORDERS, 'oID=' . mh_db_prepare_input($reviews['shopreviews_orders_id'] . '&action=edit')); ?>" target="_blank">
                        <?php echo mh_db_prepare_input($reviews['shopreviews_orders_id']); ?></a>
                <?php
                } else {
                    ?>
                    ---
                <?php
                }
                ?>
            </td>
            <td colspan="4" class="bottomborder">
                <strong>IP:</strong> <?php echo $reviews['shopreviews_ip']; ?></td>
            <td colspan="5" class="bottomborder" style="text-align: right; padding-right: 14px;">
                <strong><?php echo WEB4DESIGN_DE_SR_LANGUAGE; ?></strong>
                <img src="<?php echo $voting->module_path_url . 'lang/' . $voting->getLanguageFlag($reviews['shopreviews_language']) . '/' . $voting->getLanguageFlag($reviews['shopreviews_language']) ?>.gif"
                     alt="<?php echo $voting->getLanguageFlag($reviews['shopreviews_language']); ?>" title="<?php echo $voting->getLanguageFlag($reviews['shopreviews_language']); ?>"/>
            </td>
        </tr>
        <?php
        if (mh_get('action') == 'rev_edit' && $reviews['shopreviews_id'] == mh_get('sid')) {
            ?>
            <tr <?php if ($i == 0) {
                echo 'class="cyclecolor"';
            } ?>>
                <td colspan="3"><strong><?php echo WEB4DESIGN_DE_SR_EDIT_REVIEW; ?></strong></td>
                <td>&nbsp;</td>
                <td>
                    <select name="shopreviews_shoprating">
                        <?php echo $voting->getDropdownSelected($reviews['shopreviews_shoprating']); ?>
                    </select>
                </td>
                <td>
                    <select name="shopreviews_products">
                        <?php echo $voting->getDropdownSelected($reviews['shopreviews_products']); ?>
                    </select>
                </td>
                <td>
                    <select name="shopreviews_delivery">
                        <?php echo $voting->getDropdownSelected($reviews['shopreviews_delivery']); ?>
                    </select>
                </td>
                <td>
                    <select name="shopreviews_service">
                        <?php echo $voting->getDropdownSelected($reviews['shopreviews_service']); ?>
                    </select>
                </td>
                <td>
                    <select name="shopreviews_page">
                        <?php echo $voting->getDropdownSelected($reviews['shopreviews_page']); ?>
                    </select>
                </td>
                <td colspan="4">
                    <input type="hidden" name="modus" value="editupdate">
                    <input type="hidden" name="sid" value="<?php echo $reviews['shopreviews_id']; ?>">
                    <input type="submit" name="" value="<?php echo WEB4DESIGN_DE_SR_UPDATE; ?>"/>
                </td>
            </tr>

            <tr <?php if ($i == 0) {
                echo 'class="cyclecolor"';
            } ?>>
                <td colspan="13">
                    <div style="padding: 3px 0 6px 0;border-bottom: 1px dashed #ccc;">
                    <strong><?php echo WEB4DESIGN_DE_SR_FIRSTNAME; ?>:</strong> <input type="text" name="shopreviews_firstname" value="<?php echo mh_db_prepare_input($reviews['shopreviews_firstname']); ?>" />
                        <strong><?php echo WEB4DESIGN_DE_SR_LASTNAME; ?>:</strong> <input type="text" name="shopreviews_lastname" value="<?php echo mh_db_prepare_input($reviews['shopreviews_lastname']); ?>" />
                    </div>
                </td>
            </tr>

            <tr <?php if ($i == 0) {
                echo 'class="cyclecolor"';
            } ?>>
                <td colspan="13">
                    <div style="float: left; width: 49%; overflow: hidden;">
                        <strong><?php echo WEB4DESIGN_DE_SR_USERCOMMENT; ?></strong><br/>
                        <textarea name="shopreviews_text" id="shopreviews_text" rows="6" style="width: 99%;"><?php echo mh_db_prepare_input($reviews['shopreviews_text']); ?></textarea>
                    </div>
                    <div style="float: left; width: 49%; overflow: hidden;">
                        <strong><?php echo WEB4DESIGN_DE_SR_ADMINCOMMENT; ?></strong><br/>
                        <textarea name="shopreviews_admin_comment" id="shopreviews_admin_comment" rows="6" style="width: 99%;"><?php echo mh_db_prepare_input($reviews['shopreviews_admin_comment']); ?></textarea>
                    </div>
                    <p class="clr">&nbsp;</p>
                </td>
            </tr>
        <?php
        }
        if (mh_get('action') == 'rpreview' && $reviews['shopreviews_id'] == mh_get('sid')) {
            ?>
            <tr <?php if ($i == 0) {
                echo 'class="cyclecolor"';
            } ?>>
                <td colspan="9"><strong><?php echo WEB4DESIGN_DE_SR_PREVIEW; ?></strong></td>
                <td colspan="4">&nbsp;</td>
            </tr>
            <tr <?php if ($i == 0) {
                echo 'class="cyclecolor"';
            } ?>>
                <td colspan="13">
                    <div style="float: left; width: 49%; overflow: hidden;">
                        <strong><?php echo WEB4DESIGN_DE_SR_USERCOMMENT; ?></strong><br/>
                        <textarea name="shopreviews_text" id="shopreviews_text" rows="6" readonly="readonly"  style="width: 99%;"><?php echo mh_db_prepare_input($reviews['shopreviews_text']); ?></textarea>
                    </div>
                    <div style="float: left; width: 49%; overflow: hidden;">
                        <strong><?php echo WEB4DESIGN_DE_SR_ADMINCOMMENT; ?></strong><br/>
                        <textarea name="shopreviews_admin_comment" id="shopreviews_admin_comment" rows="6" readonly="readonly" style="width: 99%;"><?php echo mh_db_prepare_input($reviews['shopreviews_admin_comment']); ?></textarea>
                    </div>
                    <p class="clr">&nbsp;</p>
                </td>
            </tr>
        <?php
        }
        ?>
    <?php
    }
    ?>
</table>
<p class="clr">&nbsp;</p>

</form>
<div class="rightpagebox">
    <?php echo $reviews_split->display_count($reviews_query_numrows, '10', mh_get(MH_PAGE_NAME), mh_lng('WEB4DESIGN_DE_SR_NUMBER_FROM_TO')); ?>&nbsp;&nbsp;
    <?php echo $reviews_split->display_links($reviews_query_numrows, 10, mh_cfg('MAX_DISPLAY_PAGE_LINKS'), mh_get(MH_PAGE_NAME), mh_get_all_get_params(array(MH_PAGE_NAME))); ?>
</div>
<p class="clr">&nbsp;</p>

<?php
include(MH_DIR_CONFIG . 'config_shopvoting/admin/common_footer.php');