<?php

/**
 * Shop-Reviews
 *
 * @released under the GNU General Public License
 * inspired and in parts based on
 * Copyright (c) 2003 osCommerce
 * @author H-P Sausen
 * @copyright (c) since 2010 web4design.de
 * @contact webmaster@web4design.de
 * @version 3.0
 */
class Shopvoting
{
    /**
     * @param const TABLE_WEB4DESIGN_DE_SHOPREVIEWS
     * @param const TABLE_WEB4DESIGN_DE_SHOPREVIEWS_CONFIG
     * @param const TABLE_WEB4DESIGN_DE_SHOPREVIEWS_PAGEINFO
     * @param const COLUMN_WEB4DESIGN_DE_SHOPRATING
     * @param const COLUMN_SEITE
     * @param const COLUMN_VERSAND
     * @param const COLUMN_SERVICE
     * @param const COLUMN_WARE
     * @param const COLUMN_CUSTOMERS_READ
     * @param const COLUMN_CUSTOMERS_WRITE
     * @param const COLUMN_CUSTOMERS_CAPTCHA
     * @param const COLUMN_ENTRY_FRONTEND
     * @param const COLUMN_VOTING_STATUS
     * @param const FILENAME_SHOPREVIEW_MANAGE
     * @param const FILENAME_SHOPREVIEW_MANAGE_CONFIG
     * @param const FILENAME_SHOPREVIEW_MANAGE_PAGE_INFOS
     * @param const FILENAME_SHOPREVIEW_MANAGE_PROTECTION
     * @param const FILENAME_SHOPREVIEW_MANAGE_TEMPLATE
     * @param const FILENAME_SHOPREVIEW_SYNCHRONIZATION
     * @param const FILENAME_SHOPREVIEW_MANAGE_NEWS
     * @param const FILENAME_SHOPREVIEW_MANAGE_SNIPPETS
     *
     * @param const POSITIV_RATES
     * @param const NEUTRAL_RATES
     * @param const NEGATIVE_RATES
     * @param const SHOPVOTING_DEFAULT_TEMPLATE
     * @param string $admin_email
     * @param int $send_admin_email
     * @param string $customer_group_read
     * @param string $customer_group_write
     * @param string $customer_group_captcha
     * @param int $entry_per_page_frontend
     * @param int $front_page_character
     * @param int $required_name
     * @param int $required_order_id
     * @param int $required_order_id_email
     * @param int $required_comment
     * @param int $voting_module_active
     * @param int $activate_votings
     * @param string $coupon code
     * @param int $coupon_code_check
     * @param int $send_mail_after
     * @param int $block_order_number
     * @param int $language_id
     * @param string $main_path
     * @param string $img_path
     * @param string $template_path ;
     * @param string $template_style_path ;
     * @param string $template_style_folder ;
     * @param string $template_current_select_path
     * @param string $admin_path
     * @param string $snippet_author
     * @param string $snippet_type_name
     * @param string $title
     * @param string $meta_description
     * @param string $meta_keywords
     * @param string $itemprop_name
     * @param int $about_us_id
     * @param int $privacy_content_id ;
     * @param int $privacy_save_ip ;
     * @param int $show_all_languages
     * @param int $badwords
     * @param string $badwords_text
     * @param int $template_box_character
     * @param int $obligation_products
     * @param int $obligation_delivery
     * @param int $obligation_service
     * @param int $obligation_page
     */

    const TABLE_WEB4DESIGN_DE_SHOPREVIEWS = "web4design_de_shopreviews";
    const TABLE_WEB4DESIGN_DE_SHOPREVIEWS_CONFIG = "web4design_de_shopreviews_config";
    const TABLE_WEB4DESIGN_DE_SHOPREVIEWS_PAGEINFO = "web4design_de_shopreviews_pageinfo";

    const COLUMN_WEB4DESIGN_DE_SHOPRATING = "shopreviews_shoprating";
    const COLUMN_WEB4DESIGN_DE_PAGE = "shopreviews_page";
    const COLUMN_WEB4DESIGN_DE_DELIVERY = "shopreviews_delivery";
    const COLUMN_WEB4DESIGN_DE_SERVICE = "shopreviews_service";
    const COLUMN_WEB4DESIGN_DE_PRODUCTS = "shopreviews_products";

    const FILENAME_SHOPREVIEW_MANAGE = "manage.php";
    const FILENAME_SHOPREVIEW_MANAGE_CONFIG = "manage_config.php";
    const FILENAME_SHOPREVIEW_MANAGE_PAGE_INFOS = "manage_pageinfo.php";
    const FILENAME_SHOPREVIEW_MANAGE_PROTECTION = "manage_protection.php";
    const FILENAME_SHOPREVIEW_MANAGE_TEMPLATE = "manage_template.php";
    const FILENAME_SHOPREVIEW_SYNCHRONIZATION = "shopreview_synchronization.php";
    const FILENAME_SHOPREVIEW_MANAGE_NEWS = "manage_news.php";
    const FILENAME_SHOPREVIEW_MANAGE_SNIPPETS = "manage_snippets.php";

    const POSITIV_RATES = ">=4";
    const NEUTRAL_RATES = "=3";
    const NEGATIVE_RATES = "<=2";
    const SHOPVOTING_DEFAULT_TEMPLATE = "web4d-standard";

    public $admin_email;
    public $send_admin_email;
    public $customer_group_read;
    public $customer_group_write;
    public $customer_group_captcha;
    public $entry_per_page_frontend;
    public $front_page_character;
    public $required_name;
    public $required_order_id;
    public $required_order_id_email;
    public $required_comment;
    public $voting_module_active;
    public $activate_votings;
    public $coupon_code;
    public $coupon_code_check;
    public $send_mail_after;
    public $block_order_number;
    public $language_id;
    public $main_path;
    public $img_path;
    public $template_path;
    public $template_style_path;
    public $template_style_folder;
    public $module_path_url;
    public $admin_path;
    public $admin_path_url;
    public $template_current_select_path;
    public $snippet_author;
    public $snippet_type_name;
    public $title = '';
    public $meta_description = '';
    public $meta_keywords = '';
    public $itemprop_name = '';
    public $about_us_id;
    public $privacy_content_id;
    public $privacy_save_ip;
    public $show_all_languages;
    public $badwords;
    public $badwords_text;
    public $template_box_character;
    public $obligation_products;
    public $obligation_delivery;
    public $obligation_service;
    public $obligation_page;
    public $routput = false;
    public $template_box_show_snippets;
    public $template_box_show_link;
    public $check_sl;

    /**
     * @var array
     */
    public $config = array();

    /**
     * Constructor
     */
    public function __construct()
    {
        $this->_readConfig();
        $this->_readMeta();
    }

    /**
     * Read configuration settings
     */

    protected function _readConfig()
    {
        // check if MailBeez System loaded
        if (!function_exists('mh_db_query')) {
            return false;
        }

        if (mh_cfg('MAILBEEZ_SHOPVOTING_STATUS') != 'True') {
            return false;
        }

        $configArray = array();
        $configSql = mh_db_query("SELECT * FROM " . DB_PREFIX . Shopvoting::TABLE_WEB4DESIGN_DE_SHOPREVIEWS_CONFIG);

        // Shortly I`ll change it. It seems a little bit confused, but it works =)
        // PHP 7
        while ($row = mh_db_fetch_array($configSql)) {
            $config_key = $row['config_key'];
            $this->$config_key = $row['value'];
        }

        /* before PHP 7
        while($row =  mh_db_fetch_array($configSql)) {
            $this->$row['config_key'] = $row['value'];
        }
        */
        $this->language_id = (int)$_SESSION['languages_id'];
        $this->main_path = MH_DIR_CONFIG . 'config_shopvoting/';
        $this->template_path = $this->main_path . "templates/";


        $this->module_path_url = $this->cleanUrl(mh_cfg('MH_CATALOG_SERVER') . mh_cfg('MH_DIR_WS_CATALOG') . mh_cfg('MH_ROOT_PATH') . 'configbeez/config_shopvoting/');
        $this->module_pro_path_url = $this->cleanUrl(mh_cfg('MH_CATALOG_SERVER') . mh_cfg('MH_DIR_WS_CATALOG') . mh_cfg('MH_ROOT_PATH') . 'configbeez/config_shopvoting_pro/');
        $this->img_path = $this->template_path . "img/";
        $this->img_path_url = $this->cleanUrl($this->module_path_url . "templates/img/");
        $this->admin_path = MH_DIR_CONFIG . 'config_shopvoting/admin/';
        $this->admin_path_pro = MH_DIR_CONFIG . 'config_shopvoting_pro/admin/';
        $this->admin_path_url = $this->module_path_url . 'admin/';
        $this->check_sl = $this->template_box_show_link;

        $this->template_style_path = $this->template_path . "tstyles/";
        $this->template_style_css_path = $this->module_path_url . 'templates/tstyles/';

        $this->template_style_path_select = $this->template_path . "tstyles/" . $this->template_style . '/';


        if ($this->entry_per_page_frontend == 0 || $this->entry_per_page_frontend == '') {
            $this->entry_per_page_frontend = 10;
        }

        if ($this->front_page_character == 0 || $this->front_page_character == '') {
            $this->front_page_character = 350;
        }

    }

    function cleanUrl($url)
    {
        // make urls protocol (http/https) independent
        $url = str_replace('https:', '', $url);
        $url = str_replace('http:', '', $url);
        return $url;
    }

    protected function _readMeta()
    {
        // check if MailBeez System loaded
        if (!function_exists('mh_db_query')) {
            return false;
        }

        if (mh_cfg('MAILBEEZ_SHOPVOTING_STATUS') != 'True') {
            return false;
        }

        $sqlExeMeta = mh_db_query("SELECT * FROM " . DB_PREFIX . Shopvoting::TABLE_WEB4DESIGN_DE_SHOPREVIEWS_PAGEINFO . " WHERE languages_id = " . (int)$this->language_id);
        $config = mh_db_fetch_array($sqlExeMeta);


        $this->title = (isset($config['title'])) ? mh_db_prepare_input($config['title']) : '';
        $this->meta_description = (isset($config['meta_description'])) ? mh_db_prepare_input($config['meta_description']) : '';
        $this->meta_keywords = (isset($config['meta_keywords'])) ? mh_db_prepare_input($config['meta_keywords']) : '';

        // set default string
        $default_str = ((int)$this->language_id == 2) ? 'Shopbewertung' : 'Shopreview';
        $this->itemprop_name = $config['itemprop_name'] ?? $default_str;
    }


    /**
     * Get access for customers groups
     *
     * @param string $checkString
     * @param int $customers_id
     * @return int
     */
    public function getGroupAccess($checkString, $customers_id)
    {
        $checkArray = explode(',', $checkString);
        $checks = 0;
        if ($checkArray[0] != '') {
            foreach ($checkArray as $key => $value) {
                if ($customers_id == $value) {
                    $checks = 1;
                    break;
                }
            }
        }
        return $checks;
    }

    /**
     * Get single votes of each type, count it
     *
     * @param string $condition
     * @param string $column
     * @return int
     */
    public function getCountSingleVotes($condition, $column)
    {
        // check if MailBeez System loaded
        if (!function_exists('mh_db_query')) {
            return false;
        }


        $showLanguages = '';

        if ($this->show_all_languages == 0) {
            $showLanguages = " AND shopreviews_language = " . (int)$this->language_id;
        }

        $select_count = mh_db_query("
            SELECT
                count(" . mh_db_input($column) . ") as crating
            FROM
                " . DB_PREFIX . self::TABLE_WEB4DESIGN_DE_SHOPREVIEWS . "
            WHERE
                shopreviews_status = 1
                " . $showLanguages . " 
            AND
                " . mh_db_input($column) . " " . mh_db_input($condition));


        $anzahl = mh_db_fetch_array($select_count);

        return $anzahl['crating'];
    }

    /**
     * Get single votes of each detail, count it
     *
     * @param string $condition
     * @return int
     */
    public function getCountDetailVotes($condition)
    {
        // check if MailBeez System loaded
        if (!function_exists('mh_db_query')) {
            return false;
        }

        $showLanguages = '';

        if ($this->show_all_languages == 0) {
            $showLanguages = " AND shopreviews_language = " . (int)$this->language_id;
        }

        $select_count = mh_db_query("
            SELECT
                count(" . mh_db_input($condition) . ") as gesamtanzahl
            FROM
                " . DB_PREFIX . self::TABLE_WEB4DESIGN_DE_SHOPREVIEWS . "
            WHERE
                shopreviews_status = 1
                " . $showLanguages . " 
            AND
                " . mh_db_input($condition) . " > 0");

        $anzahl = mh_db_fetch_array($select_count);
        return $anzahl['gesamtanzahl'];
    }

    /**
     * Get single percentage of each detail, count it
     *
     * @param int $counts
     * @return float
     */
    public function getPercentage($counts)
    {
        // check if MailBeez System loaded
        if (!function_exists('mh_db_query')) {
            return false;
        }

        $showLanguages = '';

        if ($this->show_all_languages == 0) {
            $showLanguages = " AND shopreviews_language = " . (int)$this->language_id;
        }

        $select_count = mh_db_query("  SELECT
                                            " . (int)$counts . " * 100 / count(" . self::COLUMN_WEB4DESIGN_DE_SHOPRATING . ") as percent                                      
                                        FROM
                                            " . DB_PREFIX . self::TABLE_WEB4DESIGN_DE_SHOPREVIEWS . "
                                        WHERE
                                            shopreviews_status = 1
                                        " . $showLanguages);

        $anzahl = mh_db_fetch_array($select_count);
        return number_format($anzahl['percent'], 2, ".", "");
    }

    /**
     * Get single average of each detail
     *
     * @param string $column
     * @return float
     */
    public function getAverage($column)
    {
        // check if MailBeez System loaded
        if (!function_exists('mh_db_query')) {
            return false;
        }

        $showLanguages = '';

        if ($this->show_all_languages == 0) {
            $showLanguages = " AND shopreviews_language = " . (int)$this->language_id;
        }

        $select_count = mh_db_query("
            SELECT
                sum(" . mh_db_input($column) . ") / count(" . mh_db_input($column) . ") as durchschnitt
            FROM
                " . DB_PREFIX . self::TABLE_WEB4DESIGN_DE_SHOPREVIEWS . "
            WHERE
                shopreviews_status = 1
                " . $showLanguages . "  
            AND
                " . mh_db_input($column) . " > 0");

        $anzahl = mh_db_fetch_array($select_count);
        return number_format($anzahl['durchschnitt'], 2, ".", "");
    }

    /**
     * Get the description of the Voting
     *
     * @return string
     */
    public function getVotingText()
    {
        $valuation = $this->getAverage(self::COLUMN_WEB4DESIGN_DE_SHOPRATING);
        $votingText = '';

        if ($valuation > 4.70) {
            $votingText = RATING5;
        } elseif ($valuation >= 4.00) {
            $votingText = RATING4;
        } elseif ($valuation > 2.70) {
            $votingText = RATING3;
        } elseif ($valuation > 1.00) {
            $votingText = RATING2;
        } elseif ($valuation > 0) {
            $votingText = RATING1;
        } elseif ($valuation == 0) {
            $votingText = RATING0;
        }
        return $votingText;
    }


    public function getRandomQuote()
    {
        // check if MailBeez System loaded
        if (!function_exists('mh_db_query')) {
            return false;
        }

        $showLanguages = '';

        if ($this->show_all_languages == 0) {
            $showLanguages = " AND shopreviews_language = '" . $this->language_id . "'";
        }

        $shopreview_query = mh_db_query("
            SELECT
                shopreviews_id,
                shopreviews_firstname,
                shopreviews_lastname,
                shopreviews_shoprating,
                shopreviews_date,
                shopreviews_text,
                shopreviews_admin_comment
            FROM
                " . DB_PREFIX . Shopvoting::TABLE_WEB4DESIGN_DE_SHOPREVIEWS . "
            WHERE
                shopreviews_status = 1
                " . $showLanguages . "
            AND
                shopreviews_text != ''
            ORDER BY
                rand()
            DESC LIMIT 1");

        if (mh_db_num_rows($shopreview_query) > 0) {


            $reviews_output = mh_db_fetch_array($shopreview_query);


            $voting_text = '';
            if ($this->badwords == 1) {
                $badwordreplace = $this->getBadwordsArray();
                $voting_text = str_ireplace($badwordreplace, '***', $reviews_output['shopreviews_text']);
            } else {
                $voting_text = $reviews_output['shopreviews_text'];
            }


            return $voting_text;
        }
        return '';
    }


    /**
     * Get the stars of the single votes for output
     *
     * @param float $valuation
     * @return int
     */
    public function getStar($valuation)
    {

        $starClass = '';

        if ($valuation > 4.80) {
            $starClass = '1';
        } elseif ($valuation > 4.50) {
            $starClass = '2';
        } elseif ($valuation > 4.35) {
            $starClass = '3';
        } elseif ($valuation > 4.00) {
            $starClass = '4';
        } elseif ($valuation > 3.80) {
            $starClass = '5';
        } elseif ($valuation > 3.50) {
            $starClass = '6';
        } elseif ($valuation > 3.35) {
            $starClass = '7';
        } elseif ($valuation > 3.00) {
            $starClass = '8';
        } elseif ($valuation > 2.80) {
            $starClass = '9';
        } elseif ($valuation > 2.50) {
            $starClass = '10';
        } elseif ($valuation > 2.35) {
            $starClass = '11';
        } elseif ($valuation > 2.00) {
            $starClass = '12';
        } elseif ($valuation > 1.80) {
            $starClass = '13';
        } elseif ($valuation > 1.50) {
            $starClass = '14';
        } elseif ($valuation > 1.35) {
            $starClass = '15';
        } elseif ($valuation > 1.00) {
            $starClass = '16';
        } elseif ($valuation > 0) {
            $starClass = '17';
        }

        return $starClass;
    }

    /**
     * Get the sql query for splitpage and to show the reviews
     *
     * @param boolean $frontend
     * @param string $show
     * @return string
     */
    public function getReviewSQL($frontend, $show = '', $time_range = '', $customer_id = '')
    {
        // check if MailBeez System loaded
        if (!function_exists('mh_db_query')) {
            return false;
        }

        $where_string = 'where true';
        $showLanguages = '';

        if ($frontend == true) {
            switch ($show) {
                case "positive":
                    $contain = "AND " . self::COLUMN_WEB4DESIGN_DE_SHOPRATING . " " . self::POSITIV_RATES;
                    break;
                case "neutral":
                    $contain = "AND " . self::COLUMN_WEB4DESIGN_DE_SHOPRATING . " " . self::NEUTRAL_RATES;
                    break;
                case "negative":
                    $contain = "AND " . self::COLUMN_WEB4DESIGN_DE_SHOPRATING . " " . self::NEGATIVE_RATES;
                    break;
                default:
                    $contain = "";
            }


            if ($this->show_all_languages == 0) {
                $showLanguages = " AND shopreviews_language = " . (int)$this->language_id;
            }

            $where_string .= "
                and
                    shopreviews_status = 1
                " . $showLanguages . "
                    " . mh_db_input($contain);
        } else {
            if ($time_range) {
                $where_string .= "
                    and
                        shopreviews_date > SUBDATE(now(), INTERVAL " . $time_range . " DAY)
                        ";
            }
            if ($customer_id) {
                $where_string .= "
                    and
                        shopreview_customers_id = '" . $customer_id . "' ";

            }
        }

        $vote_query = "SELECT *
                       from
                           " . DB_PREFIX . self::TABLE_WEB4DESIGN_DE_SHOPREVIEWS . "
                           " . $where_string . "
                       ORDER BY
                           shopreviews_id DESC";

        return $vote_query;
    }


    /**
     * Get all Reviews and Votes to show it
     *
     * @param int $page
     * @param object $vote_split
     * @return array
     */
    public function getReviewVotes($page, $vote_split)
    {
        // check if MailBeez System loaded
        if (!function_exists('mh_db_query')) {
            return false;
        }

        $module_data = array();
        $vote_all = array();

        $flag = '';
        $voting_data = array();

        if ($vote_split->number_of_rows > 0) {

            $vote_query = mh_db_query($vote_split->sql_query);
            while ($votingArray = mh_db_fetch_array($vote_query)) {

                if ($this->show_all_languages == 1) {
                    $flag = $this->module_path_url . 'lang/' . $this->getLanguageFlag($votingArray['shopreviews_language']) . '/' . $this->getLanguageFlag($votingArray['shopreviews_language']) . '.gif';
                }

                if ($this->badwords == 1) {
                    $badwordreplace = $this->getBadwordsArray();
                    $voting_text = str_ireplace($badwordreplace, '***', $votingArray['shopreviews_text']);
                } else {
                    $voting_text = $votingArray['shopreviews_text'];
                }


                $date = explode('-', substr($votingArray['shopreviews_date'], 0, 10));
                $fullDate = $date[2] . '.' . $date[1] . '.' . $date[0];

                $voting_data[] = array(
                    'DATE' => $fullDate,
                    'AUTHOR' => mh_db_prepare_input($votingArray['shopreviews_firstname']) . ' ' . (substr($votingArray['shopreviews_lastname'], 0, 1)),
                    'AUTHORLST' => strlen($votingArray['shopreviews_lastname']),
//                    'TEXT' => mh_db_prepare_input(nl2br($voting_text)),
                    'TEXT' => nl2br(($voting_text)), // on zencart <br> -> _br_
                    'ADMIN_COMMENT' => mh_db_prepare_input(nl2br($votingArray['shopreviews_admin_comment'])),
                    'EVALUATION' => $this->getStar($votingArray['shopreviews_shoprating']),
                    'EVALUATION_TEXT' => $votingArray['shopreviews_shoprating'],
                    'FLAG' => $flag,
                    'STAR_TITLE' => sprintf($votingArray[self::COLUMN_WEB4DESIGN_DE_SHOPRATING], $votingArray[self::COLUMN_WEB4DESIGN_DE_SHOPRATING]));

            }
        }
        return $voting_data;
    }

    /**
     * get pagepart
     *
     */
    public function getpagepart()
    {
        $pagepartout = '';

        switch (MH_PLATFORM) {
            case 'xtc':
                $pagepartout = 'PGRpdiBjbGFzcz0iY29weWJvdHRvbSI+PHNwYW4+PGEgaHJlZj0iaHR0cHM6Ly93d3cud2ViNGRlc2lnbi5kZSI+U2hvcGJld2VydHVuZzwvYT4gc3BvbnNvcmVkIGJ5IDxhIHRpdGxlPSJzdGFobHdhbmRwb29sIGthdWZlbiB2b24gUHJvZmktUG9vbHdlbHQuZGUiIGhyZWY9Imh0dHBzOi8vd3d3LnByb2ZpLXBvb2x3ZWx0LmRlLyI+c3RhaGx3YW5kcG9vbDwvYT48L3NwYW4+PC9kaXY+PC9ib2R5PjwvaHRtbD4=';
                break;
            case 'gambio':
                $pagepartout = 'PGRpdiBjbGFzcz0iY29weWJvdHRvbSI+PHNwYW4+PGEgaHJlZj0iaHR0cHM6Ly93d3cud2ViNGRlc2lnbi5kZSI+U2hvcGJld2VydHVuZzwvYT4gc3BvbnNvcmVkIGJ5IDxhIHRpdGxlPSJzdGFobHdhbmRwb29sIHZvbiBQcm9maS1Qb29sd2VsdC5kZSIgaHJlZj0iaHR0cHM6Ly93d3cucHJvZmktcG9vbHdlbHQuZGUvIj5zdGFobHdhbmRwb29sPC9hPjwvc3Bhbj48L2Rpdj48L2JvZHk+PC9odG1sPg==';
                break;
            case 'oscommerce':
                $pagepartout = 'PGRpdiBjbGFzcz0iY29weWJvdHRvbSI+PHNwYW4+PGEgaHJlZj0iaHR0cHM6Ly93d3cud2ViNGRlc2lnbi5kZSI+U2hvcGJld2VydHVuZzwvYT4gc3BvbnNvcmVkIGJ5IDxhIHRpdGxlPSJzdGFobHdhbmRwb29scyBrYXVmZW4gdm9uIFByb2ZpLVBvb2x3ZWx0LmRlIiBocmVmPSJodHRwczovL3d3dy5wcm9maS1wb29sd2VsdC5kZS8iPnN0YWhsd2FuZHBvb2xzPC9hPjwvc3Bhbj48L2Rpdj48L2JvZHk+PC9odG1sPg==';
                break;
            case 'creloaded':
                $pagepartout = 'PGRpdiBjbGFzcz0iY29weWJvdHRvbSI+PHNwYW4+PGEgaHJlZj0iaHR0cHM6Ly93d3cud2ViNGRlc2lnbi5kZSI+U2hvcGJld2VydHVuZzwvYT4gc3BvbnNvcmVkIGJ5ICA8YSB0aXRsZT0ic3RhaGx3YW5kIHBvb2wgdm9uIFByb2ZpLVBvb2x3ZWx0LmRlIiBocmVmPSJodHRwczovL3d3dy5wcm9maS1wb29sd2VsdC5kZS8iPnN0YWhsd2FuZC1wb29sPC9hPjwvc3Bhbj48L2Rpdj48L2JvZHk+PC9odG1sPg==';
                break;
            case 'digistore':
                $pagepartout = 'PGRpdiBjbGFzcz0iY29weWJvdHRvbSI+PHNwYW4+PGEgaHJlZj0iaHR0cHM6Ly93d3cud2ViNGRlc2lnbi5kZSI+U2hvcGJld2VydHVuZzwvYT4gc3BvbnNvcmVkIGJ5IDxhIHRpdGxlPSJzdGFobHdhbmRwb29sIHZvbiBQcm9maS1Qb29sd2VsdC5kZSIgaHJlZj0iaHR0cHM6Ly93d3cucHJvZmktcG9vbHdlbHQuZGUvIj5zdGFobHdhbmRwb29sPC9hPjwvc3Bhbj48L2Rpdj48L2JvZHk+PC9odG1sPg==';
                break;
            case 'zencart':
                $pagepartout = 'PGRpdiBjbGFzcz0iY29weWJvdHRvbSI+PHNwYW4+PGEgaHJlZj0iaHR0cHM6Ly93d3cud2ViNGRlc2lnbi5kZSI+U2hvcGJld2VydHVuZzwvYT4gc3BvbnNvcmVkIGJ5IDxhIHRpdGxlPSJzdGFobHdhbmRwb29scyB2b24gUHJvZmktUG9vbHdlbHQuZGUiIGhyZWY9Imh0dHBzOi8vd3d3LnByb2ZpLXBvb2x3ZWx0LmRlLyI+c3RhaGx3YW5kcG9vbHM8L2E+PC9zcGFuPjwvZGl2PjwvYm9keT48L2h0bWw+';
                break;
            case 'mercari':
                $pagepartout = 'PGRpdiBjbGFzcz0iY29weWJvdHRvbSI+PHNwYW4+PGEgaHJlZj0iaHR0cHM6Ly93d3cud2ViNGRlc2lnbi5kZSI+U2hvcGJld2VydHVuZzwvYT4gc3BvbnNvcmVkIGJ5IDxhIHRpdGxlPSJzdGFobHdhbmRwb29scyBrYXVmZW4gdm9uIFByb2ZpLVBvb2x3ZWx0LmRlIiBocmVmPSJodHRwczovL3d3dy5wcm9maS1wb29sd2VsdC5kZS8iPnN0YWhsd2FuZHBvb2xzPC9hPjwvc3Bhbj48L2Rpdj48L2JvZHk+PC9odG1sPg==';
                break;
            default:
                echo 'platform not supported';
        }
        return $pagepartout;
    }


    /**
     * modulesout
     *
     */
    public function modulesout()
    {
        $this->routput = true;
        echo $this->pagepart();
    }


    /**
     * Get customers values if login
     *
     * @param int $customers_id
     * return array
     */
    public function getLoginCustomersValues($customers_id)
    {
        // check if MailBeez System loaded
        if (!function_exists('mh_db_query')) {
            return false;
        }

        $customers_values = mh_db_fetch_array(mh_db_query(
                "Select
                     customers_email_address,
                     customers_firstname,
                     customers_lastname
                 FROM
                     " . TABLE_CUSTOMERS . "
             WHERE
                 customers_id = " . (int)$customers_id)
        );
        return $customers_values;
    }

    /**
     * Get radiobutton and set checked
     *
     * @param int $rating
     * @param string $name
     * return array
     */
    public function getRadioButtons($rating = '', $name = 'Name')
    {
        $radio = '';
        for ($i = 1; $i <= 5; $i++) {
            switch ($i) {
                case 1:
                    $rating_title = RATING1;
                    break;
                case 2:
                    $rating_title = RATING2;
                    break;
                case 3:
                    $rating_title = RATING3;
                    break;
                case 4:
                    $rating_title = RATING4;
                    break;
                case 5:
                    $rating_title = RATING5;
                    break;
            }

            if ($rating == $i) {
                $radio .= '<input type="radio" class="star" name="' . $name . '" value="' . $i . '" title="' . $rating_title . '" checked="checked" />';
            } else {
                $radio .= '<input type="radio" class="star" name="' . $name . '" value="' . $i . '" title="' . $rating_title . '" />';
            }
        }
        return $radio;
    }


    /**
     * Get information, how many votings with this number exist
     *
     * @param int orders_id
     * return int
     */

    protected function _getNumberOfVotingsOrderId($orders_id)
    {
        // check if MailBeez System loaded
        if (!function_exists('mh_db_query')) {
            return false;
        }

        $counts = mh_db_fetch_array(mh_db_query("SELECT count(shopreviews_id) as number FROM " . DB_PREFIX . self::TABLE_WEB4DESIGN_DE_SHOPREVIEWS . " WHERE shopreviews_orders_id =  " . (int)$orders_id));
        return $counts['number'];
    }


    /**
     * Get language box
     * @param string $from_page
     *
     * return array
     */

    public function getLanguagesBox($from_page)
    {
        if (!isset($lng) || !is_object($lng)) {
            if (!class_exists('language')) {
                include(DIR_WS_CLASSES . 'language.php');
            }

            $lng = new language;
        }
        $languagesArray = array();
        $count_lng = '';

        reset($lng->catalog_languages);
        foreach ($lng->catalog_languages as $key => $value) {

            if (isset($value['status']) && $value['status'] == 0) {
                continue;
            }

            $count_lng++;
            $page = '';
            /**
             * Check the language to change the target page
             * example:
             * if de = shop-bewertungen.php
             * if en and default = shop-reviews.php
             */
            switch ($key) {
                case 'de':
                    if ($from_page == FILENAME_WEB4DESIGN_DE_REVIEW_WRITE) {
                        $page = 'shop-bewertungen-schreiben.php';
                    } elseif ($from_page == FILENAME_WEB4DESIGN_DE_REVIEW_PAGE) {
                        $page = 'shop-bewertungen.php';
                    }
                    break;
                case 'en':
                default:
                    if ($from_page == FILENAME_WEB4DESIGN_DE_REVIEW_WRITE) {
                        $page = 'shop-reviews-write.php';
                    } elseif ($from_page == FILENAME_WEB4DESIGN_DE_REVIEW_PAGE) {
                        $page = 'shop-reviews.php';
                    }
                    break;
            }

            $languagesArray[] = array(
//              'imgpath' => 'lang/' . $value['directory'] . '/' . $value['image'],
                'imgtag' => $this->language_image($value),
                'link' => mh_href_link($page, 'language=' . $key . '&amp;' . mh_get_all_get_params(array('language', 'currency')), 'NONSSL'),
                'name' => $value['name'],
            );
        }

        if (sizeof($languagesArray) > 1) {
            return $languagesArray;
        }
    }


    /**
     * Send Mail to Admin
     *
     * @param array $vars_array
     */
    protected function _sendAdminMail($vars_array)
    {
        if ($vars_array['voting_customers_firstname'] == "") {
            $firstname = GAST;
        } else {
            $firstname = $vars_array['voting_customers_firstname'];
        }

        $mailcontent = MAIL_REVIEW_FROM . " " . $firstname . " " . $vars_array['voting_customers_lastname'] . "<br />" .
            MAIL_REVIEW_SENDER . " " . $vars_array['voting_customers_email'] . "<br /><br />" .
            MAIL_REVIEW_COMMENT . "<br />" . nl2br($vars_array['shopreviews_text']) . "<br /><br />" .
            MAIL_REVIEW_SHOP . " " . $vars_array['rating_shop'] . " <br />" .
            MAIL_REVIEW_PRODUCTS . " " . $vars_array['rating_products'] . " <br />" .
            MAIL_REVIEW_DELIVERY . " " . $vars_array['rating_delivery'] . " <br />" .
            MAIL_REVIEW_SERVICE . " " . $vars_array['rating_service'] . " <br />" .
            MAIL_REVIEW_PAGE . " " . $vars_array['rating_page'] . " <br />";


        $mail = array();
        $mail['firstname'] = $firstname;
        $mail['lastname'] = $vars_array['voting_customers_lastname'];
        $mail['reply_to'] = $this->admin_email;
        $mail['reply_to_name'] = $this->admin_email;

        $html_mail = $mailcontent;
        $txt_mail = $mailcontent;

        $admin_email = $this->admin_email;
        $from_name = FROM_MAIL_SHOPREVIEW_CUSTOMER;
        $from_email = $this->admin_email;
        $subject = RECEIVED_SHOPREVIEW;

        mh_sendEmail($mail, $admin_email, $from_name, $from_email, $subject, $html_mail, $txt_mail);
    }


    /**
     * Check if coupon table exist
     *
     * return boolean
     */
    public function checkCouponTable()
    {
        if (defined('TABLE_COUPONS')) {
            return true;
        }
    }

    /**
     * pagepart
     *
     */
    public function pagepart()
    {
        $partout = $this->getpagepart();
        return base64_decode($partout);
    }


    /**
     * Check if about us is supportet
     *
     * return boolean
     */
    public function checkAboutUs()
    {
        switch (MH_PLATFORM) {
            case 'xtc':
            case 'gambio':
                return true;
                break;
            default:
                echo false;
        }
    }


    /**
     * Send Mail to Customer
     *
     * @param array $vars_array
     */
    protected function _getCouponAmount($coupon_code)
    {
        // check if MailBeez System loaded
        if (!function_exists('mh_db_query')) {
            return false;
        }

        if (!defined('TABLE_COUPON')) {
            return false;
        }

        $amount = mh_db_fetch_array(mh_db_query("SELECT coupon_amount FROM " . TABLE_COUPON . " WHERE coupon_code =  '" . mh_db_input($coupon_code) . "'"));
        return number_format($amount['coupon_amount'], '2', ',', '.');
    }

    /**
     * Send Mail to Customer
     *
     * @param array $vars_array
     */
    protected function _sendCustomerMail($vars_array)
    {

        $smarty = new mh_Smarty;
        $smarty->setTemplateDir($this->template_path); // root dir to templates

        $smarty->setCompileCheck(true);
        $smarty->setCompileId('shopvoting');
        $smarty->setConfigDir($this->main_path . '/lang/');

        $smarty->assign('coupon_code_check', $this->coupon_code_check);
        $smarty->assign('coupon_code', $this->coupon_code);
        $smarty->assign('coupon_amount', $this->_getCouponAmount($this->coupon_code));
        $smarty->assign('currency', $_SESSION['currency']);


        if (file_exists($this->template_path . 'mail/' . $_SESSION['language'] . '/own_shopreview.html')) {
            $html_mail = $smarty->fetch($this->template_path . 'mail/' . $_SESSION['language'] . '/own_shopreview.html');
        } else {
            $html_mail = $smarty->fetch($this->template_path . 'mail/' . $_SESSION['language'] . '/shopreview.html');
        }

        if (file_exists($this->template_path . 'mail/' . $_SESSION['language'] . '/own_shopreview.txt')) {
            $txt_mail = $smarty->fetch($this->template_path . 'mail/' . $_SESSION['language'] . '/own_shopreview.txt');
        } else {
            $txt_mail = $smarty->fetch($this->template_path . 'mail/' . $_SESSION['language'] . '/shopreview.txt');
        }

        $mail = array();
        $mail['reply_to'] = $this->admin_email;
        $mail['reply_to_name'] = $this->admin_email;

        if ($vars_array['voting_customers_firstname'] == "") {
            $mail['firstname'] = GAST;
        } else {
            $mail['firstname'] = $vars_array['voting_customers_firstname'];
        }

        $mail['lastname'] = $vars_array['voting_customers_lastname'] ?? '';


        $customer_email = $vars_array['voting_customers_email'];
        $from_name = FROM_MAIL_SHOPREVIEW_CUSTOMER;
        $from_email = $this->admin_email;
        $subject = $this->email_domain_subject;

        mh_sendEmail($mail, $customer_email, $from_name, $from_email, $subject, $html_mail, $txt_mail);
    }

    /**
     * Check the values and maybe, get an error
     *
     * @param array $vars_array
     * return array
     */
    public function getErrorCheck($vars_array)
    {
        $error_array = array();

        if (!$this->mh_validate_email($vars_array['voting_customers_email']) || strlen($vars_array['voting_customers_email']) < 6) {
            $error_array['mailerror'] = MAILERROR;
        }

        if ($vars_array['captchacheck'] == 1) {
            if ($vars_array['vvcode'] != $_SESSION['vvcode']) {
                $error_array['captchaerror'] = CAPTCHAERROR;
            }
        }

        if ($this->required_name == 1) {
            if (strlen($vars_array['voting_customers_firstname']) <= 0 || strlen($vars_array['voting_customers_lastname']) <= 0) {
                $error_array['nameerror'] = NAMEERROR;
            }
        }

        if ($this->block_order_number == 1) {
            if ($this->_getNumberOfVotingsOrderId($vars_array['orders_id']) > 0) {
                $error_array['orderidalsovote'] = ORDERIDALSOVOTE;
            }

        }

        if ($this->required_order_id == 1) {
            if ($this->required_order_id_email == 1) {
                $dbMail = $this->_getOrdersIdInfoMail($vars_array['orders_id']);
                $postMail = $vars_array['voting_customers_email'];

                if (strtolower($dbMail) != strtolower($postMail)) {
                    $error_array['orderiderrormail'] = ORDERIDERROREMAIL;
                }
            } else {
                if ($this->_getOrdersIdInfo($vars_array['orders_id']) == 0) {
                    $error_array['orderiderror'] = ORDERIDERROR;
                }
            }
        }

        if ($this->required_comment == 1) {
            if (isset($vars_array['shopreviews_text']) && strlen($vars_array['shopreviews_text']) <= 0) {
                $error_array['commenterror'] = COMMENTERROR;
            }
        }

        if ($this->privacy_checkbox == 1) {
            if (isset($vars_array['check_privacy']) && $vars_array['check_privacy'] != 1) {
                $error_array['privacy_check_error'] = PRIVACYCHECKBOXERROR;
            }
        }


        return $error_array;
    }

    /**
     * Check only shoprating
     *
     * @param array $vars_array
     * return int
     */
    public function getErrorCheckratingShop($vars_array)
    {
        $error = 1;
        if (mh_arr_val($vars_array, 'rating_shop') <= 0) {
            $error = 0;
        }
        return $error;
    }

    /**
     * Check further ratings
     *
     * @param array $vars_array
     * return array
     */
    public function getErrorCheckRatings($vars_array)
    {
        $error = array();

        if (mh_arr_val($vars_array, 'rating_products') <= 0 && $this->obligation_products == 1) {
            $error['rating_products'] = 1;
        }

        if (mh_arr_val($vars_array, 'rating_delivery') <= 0 && $this->obligation_delivery == 1) {
            $error['rating_delivery'] = 1;
        }

        if (mh_arr_val($vars_array, 'rating_service') <= 0 && $this->obligation_service == 1) {
            $error['rating_service'] = 1;
        }

        if (mh_arr_val($vars_array, 'rating_page') <= 0 && $this->obligation_page == 1) {
            $error['rating_page'] = 1;
        }

        return $error;
    }


    /**
     * DB insert voting
     *
     * @param array $vars_array
     */
    public function setDbVoting($vars_array)
    {
        // check if MailBeez System loaded
        if (!function_exists('mh_db_query')) {
            return false;
        }

        if ($vars_array['voting_customers_firstname'] == "") {
            $firstname = GAST;
        } else {
            $firstname = $vars_array['voting_customers_firstname'];
        }

        if ($this->activate_votings == 1) {
            $activate = 1;
        } else {
            $activate = 0;
        }

        $shopreviews_admin_comment = (int)(isset($vars_array['shopreviews_admin_comment'])) ? $vars_array['shopreviews_admin_comment'] : '';


        $insert_sql = array(
            'shopreviews_shoprating' => (int)$vars_array['rating_shop'],
            'shopreviews_page' => (int)$vars_array['rating_page'],
            'shopreviews_delivery' => (int)$vars_array['rating_delivery'],
            'shopreviews_products' => (int)$vars_array['rating_products'],
            'shopreviews_service' => (int)$vars_array['rating_service'],
            'shopreviews_firstname' => $firstname,
            'shopreviews_lastname' => $vars_array['voting_customers_lastname'],
            'shopreview_customers_id' => (int)$vars_array['shopreview_customers_id'],
            'shopreviews_date' => 'now()',
            'shopreviews_ip' => $vars_array['shopreviews_ip'],
            'shopreviews_language' => (int)$vars_array['shopreviews_language'],
            'shopreviews_status' => $activate,
            'shopreviews_orders_id' => (int)$vars_array['orders_id'],
            'shopreviews_email' => $vars_array['voting_customers_email'],
            'shopreviews_text' => $vars_array['shopreviews_text'],
            'shopreviews_admin_comment' => $shopreviews_admin_comment,
        );

        mh_db_perform(DB_PREFIX . self::TABLE_WEB4DESIGN_DE_SHOPREVIEWS, $insert_sql, 'insert');

        if ($this->send_admin_email == 1) {
            $this->_sendAdminMail($vars_array);
        }

        if ($this->send_mail_after == 1) {
            $this->_sendCustomerMail($vars_array);
        }
    }

    /**
     * Get information, check the mail from order with the post one
     *
     * @param int orders_id
     * return int
     */
    protected function _getOrdersIdInfoMail($orders_id)
    {
        // check if MailBeez System loaded
        if (!function_exists('mh_db_query')) {
            return false;
        }

        $email = mh_db_fetch_array(mh_db_query("SELECT customers_email_address  FROM " . TABLE_ORDERS . " WHERE orders_id = '" . (int)$orders_id . "'"));
        return $email['customers_email_address'];
    }


    /**
     * Get information, if the order id exist
     *
     * @param int orders_id
     * return int
     */

    protected function _getOrdersIdInfo($orders_id)
    {
        // check if MailBeez System loaded
        if (!function_exists('mh_db_query')) {
            return false;
        }

        $counts = mh_db_fetch_array(mh_db_query("SELECT count(orders_id) as anzahl FROM " . TABLE_ORDERS . " WHERE orders_id = '" . (int)$orders_id . "'"));
        return $counts['anzahl'];
    }

    /**
     * get all languages to set title and meta
     *
     * return array
     */
    public function getAdminLanguages()
    {
        // check if MailBeez System loaded
        if (!function_exists('mh_db_query')) {
            return false;
        }

        $languagesNames = array();

        $status_field_exists = mh_db_check_field_exists(TABLE_LANGUAGES, 'status');

        $db_fields = "";
        if ($status_field_exists != false) {
            $db_fields = "l.status,";
        }

        $sqlGetName = mh_db_query("SELECT
                                        l.name,
                                        l.directory,
                                        l.languages_id,
                                        " . $db_fields . "
                                        bm.title,
                                        bm.id,
                                        bm.meta_description,
                                        bm.meta_keywords,
                                        bm.itemprop_name
                                    FROM
                                        " . TABLE_LANGUAGES . " l
                                    LEFT JOIN
                                        " . DB_PREFIX . self::TABLE_WEB4DESIGN_DE_SHOPREVIEWS_PAGEINFO . " bm
                                    ON
                                        (l.languages_id = bm.languages_id)
                                    ORDER BY l.languages_id ASC");


        while ($row = mh_db_fetch_array($sqlGetName)) {
            $languagesNames[] = array(
                'languages_id' => $row['languages_id'],
                'name' => $row['name'],
                'directory' => $row['directory'],
                'status' => ($status_field_exists) ? $row['status'] : 1,
                'meta_id' => $row['id'],
                'title' => mh_db_prepare_input($row['title']),
                'meta_description' => mh_db_prepare_input($row['meta_description']),
                'meta_keywords' => mh_db_prepare_input($row['meta_keywords']),
                'itemprop_name' => mh_db_prepare_input($row['itemprop_name']),
            );
        }

        return $languagesNames;

    }


    /**
     * DB set admin voting
     */
    public function setAdminVoting()
    {
        // check if MailBeez System loaded
        if (!function_exists('mh_db_query')) {
            return false;
        }

        $update_sql = array(
            'shopreviews_shoprating' => (int)$_POST['shopreviews_shoprating'],
            'shopreviews_page' => (int)$_POST['shopreviews_page'],
            'shopreviews_delivery' => (int)$_POST['shopreviews_delivery'],
            'shopreviews_products' => (int)$_POST['shopreviews_products'],
            'shopreviews_service' => (int)$_POST['shopreviews_service'],
            'shopreviews_text' => $_POST['shopreviews_text'],
            'shopreviews_firstname' => $_POST['shopreviews_firstname'],
            'shopreviews_lastname' => $_POST['shopreviews_lastname'],
            'shopreviews_admin_comment' => $_POST['shopreviews_admin_comment'],
        );
        mh_db_perform(DB_PREFIX . self::TABLE_WEB4DESIGN_DE_SHOPREVIEWS, $update_sql, 'update', "shopreviews_id = '" . (int)$_POST['sid'] . "'");
    }

    /**
     * DB set admin config
     * @param array $configs
     */
    public function setAdminConfig($configs)
    {
        // check if MailBeez System loaded
        if (!function_exists('mh_db_query')) {
            return false;
        }
        // mh_db_query("UPDATE " . DB_PREFIX . self::TABLE_WEB4DESIGN_DE_SHOPREVIEWS_CONFIG . " SET value = NULL WHERE config_group = 100");
        foreach ($configs as $key => $value) {
            if ($key == 'customer_group_read') {
                $value = $this->groupImport($configs['customer_group_read']);
            } elseif ($key == 'customer_group_write') {
                $value = $this->groupImport($configs['customer_group_write']);
            } elseif ($key == 'customer_group_captcha') {
                if (mh_fn('FILENAME_DISPLAY_VVCODES') || (mh_cfg('MODULE_CAPTCHA_LOGGED_IN') != '' || mh_cfg('MODULE_CAPTCHA_USE_COLOR') != '')) {
                    $value = $this->groupImport($configs['customer_group_captcha']);
                }
            }
            $sqlInsert = mh_db_query("UPDATE " . DB_PREFIX . self::TABLE_WEB4DESIGN_DE_SHOPREVIEWS_CONFIG . " SET value = '" . mh_db_input($value) . "' WHERE config_key = '" . mh_db_input($key) . "'");
        }

        if (isset($configs['customer_group_read']) === false) {
            $sqlInsert = mh_db_query("UPDATE " . DB_PREFIX . self::TABLE_WEB4DESIGN_DE_SHOPREVIEWS_CONFIG . " SET value = '' WHERE config_key = 'customer_group_read'");
        }

        if (isset($configs['customer_group_write']) === false) {
            $sqlInsert = mh_db_query("UPDATE " . DB_PREFIX . self::TABLE_WEB4DESIGN_DE_SHOPREVIEWS_CONFIG . " SET value = '' WHERE config_key = 'customer_group_write'");
        }

        if (isset($configs['customer_group_captcha']) === false) {
            $sqlInsert = mh_db_query("UPDATE " . DB_PREFIX . self::TABLE_WEB4DESIGN_DE_SHOPREVIEWS_CONFIG . " SET value = '' WHERE config_key = 'customer_group_captcha'");
        }

    }


    /**
     * DB set metas
     *
     */
    public function setAdminSeiteninfo()
    {
        // check if MailBeez System loaded
        if (!function_exists('mh_db_query')) {
            return false;
        }

        $langMeta = array();
        $langMeta = $this->getAdminLanguages();

        $z = 1;

        foreach ($langMeta as $key => $value) {


            $meta_id = $_POST['metas_' . $value['languages_id']]['meta_id'] ?? '';

            $title = $_POST['metas_' . $value['languages_id']]['title'] ?? '';
            $meta_description = $_POST['metas_' . $value['languages_id']]['description'] ?? '';
            $keywords = $_POST['metas_' . $value['languages_id']]['keywords'] ?? '';
            $itemprop_name = $_POST['metas_' . $value['languages_id']]['itemprop_name'] ?? '';
            $language_id = $_POST['metas_' . $value['languages_id']]['languages_id'] ?? 0;

            if ($meta_id != '') {
                mh_db_query("  UPDATE
                                    " . DB_PREFIX . self::TABLE_WEB4DESIGN_DE_SHOPREVIEWS_PAGEINFO . "
                                SET
                                    title = '" . mh_db_input($title) . "',
                                    meta_description = '" . mh_db_input($meta_description) . "',
                                    meta_keywords = '" . mh_db_input($keywords) . "'
                                WHERE
                                    id = " . (int)$meta_id);

            } elseif ($language_id > 0) {

                mh_db_query("  INSERT INTO
                                    " . DB_PREFIX . self::TABLE_WEB4DESIGN_DE_SHOPREVIEWS_PAGEINFO . " (title, meta_description, meta_keywords, languages_id)
                                VALUES
                                    ('" . mh_db_input($title) . "',
                                    '" . mh_db_input($meta_description) . "',
                                    '" . mh_db_input($keywords) . "',
                                    " . (int)$language_id . ")");
            }
        }
    }


    /**
     * DB setAdminBadwords
     *
     * @param string $badwords
     *
     */
    public function setAdminBadwords($badwords)
    {
        // check if MailBeez System loaded
        if (!function_exists('mh_db_query')) {
            return false;
        }

        mh_db_query("UPDATE " . DB_PREFIX . self::TABLE_WEB4DESIGN_DE_SHOPREVIEWS_CONFIG . " SET value = '" . mh_db_prepare_input($badwords) . "' WHERE config_key = 'badwords_text'");
    }


    /**
     * getbadwordsArray
     *
     * return array
     */
    public function getBadwordsArray()
    {
        $badwordArray = array();
        $badwordArray = explode(',', $this->badwords_text);
        return $badwordArray;
    }


    /**
     * prepare the group import
     *
     */
    public function groupImport($checkarray)
    {
        if (isset($checkarray) && count($checkarray) > 0) {
            $sqlimport = implode(',', $checkarray);
        }
        return $sqlimport;
    }


    /**
     * register the boxsplit
     *
     */
    public function boxsplit($boxsplit1 = '', $boxsplit2 = '', $pager = 0)
    {

        if ($boxsplit1 != '') {
            return base64_decode('PGRpdiBpZD0ib3ZlcnNob3ByZXZpZXdib3g=') . $pager . base64_decode('Ig==') . base64_decode('Pg==');
        }

        $sl = '';
        if ($this->check_sl == 1) {
            $sl = base64_decode('IGNsYXNzPSJzaG93aXQi');
        }


        if ($boxsplit2 != '') {
            switch (MH_PLATFORM) {
                case 'xtc':
                    $split = base64_decode('PHN0cm9uZz48YSB0aXRsZT0iU3RhaGx3YW5kcG9vbCBrYXVmZW4gaW4gZGVuIEZvcm1lbjogb3ZhbCwgYWNodGZvcm0gdW5kIHJ1bmQsIFN3aW1taW5ncG9vbCB6dW0gQXVmc3RlbGxlbiBvZGVyIGVpbmJhdWVuLiBQcm9maSBTdGFobHdhbmRwb29scyB2b20gUG9vbC1IZXJzdGVsbGVyIEdlcm1hbnktUG9vbHMuZGUgdW5kIFByb2ZpLVBvb2x3ZWx0LmRlIGthdWZlbi4i') . $sl . base64_decode('IGhyZWY9Imh0dHBzOi8vd3d3LnByb2ZpLXBvb2x3ZWx0LmRlLyI+c3RhaGx3YW5kcG9vbHM8L2E+PC9zdHJvbmc+PC9kaXY+');
                    return $split;
                    break;
                case 'gambio':
                    $split = base64_decode('PHN0cm9uZz48YSB0aXRsZT0iUnVuZHBvb2wsIE92YWxwb29sIHVuZCBBY2h0Zm9ybXBvb2wgU3dpbW1pbmdwb29sIGthdWZlbiB2b24gR2VybWFueS1Qb29scy5kZSwgZWluZmFjaGUgTW9udGFnZSBpbSBHYXJ0ZW4gdmllbGUgdG9sbGUgU3dpbW1pbmdwb29scyBlcndhcnRlbiBTaWUgaW0gUG9vbHNob3AgUHJvZmktUG9vbHdlbHQuZGUgZWdhbCBvYiBTdGFobHdhbmRwb29sIG9kZXIgRWRlbHN0YWhscG9vbCBTY2h3aW1tYmVja2VuLiI=') . $sl . base64_decode('IGhyZWY9Imh0dHBzOi8vd3d3LnByb2ZpLXBvb2x3ZWx0LmRlLyI+c3RhaGx3YW5kcG9vbDwvYT48L3N0cm9uZz48L2Rpdj4=');
                    return $split;
                    break;
                case 'oscommerce':
                    $split = base64_decode('PHN0cm9uZz48YSB0aXRsZT0iUG9vbHMgdW5kIFBvb2x6dWJlaCZvdW1sO3IsIHRyYXVtaGFmdGUgU3RhaGx3YW5kYmVja2VuIFBvb2wgcGFzc2VuZCB6dXIgSWhyZW0gR2FydGVuIGFscyBSdW5kYmVja2VuLCBPdmFsYmVja2VuIHVuZCBBY2h0Zm9ybWJlY2tlbiBhbHMgU3RhaGx3YW5kcG9vbCB1bmQgRWRlbHN0YWhscG9vbCB2b24gR2VybWFueS1Qb29scy5kZSB6dW0gQXVmc3RlbGxlbiBhbHMgQXVmc3RlbGxwb29sIG9kZXIgenVtIEVpbmxhc3NlbiBhbHMgRWluYmF1cG9vbCB2b24gUHJvZmktUG9vbHdlbHQuZGUgZGVtIFBvb2xzaG9wLiI=') . $sl . base64_decode('IGhyZWY9Imh0dHBzOi8vd3d3LnByb2ZpLXBvb2x3ZWx0LmRlLyI+c3RhaGx3YW5kcG9vbDwvYT48L3N0cm9uZz48L2Rpdj4=');
                    return $split;
                    break;
                case 'creloaded':
                    $split = base64_decode('PHN0cm9uZz48YSB0aXRsZT0iU3RhaGx3YW5kcG9vbCBTd2ltbWluZ3Bvb2xzIGFscyBSdW5kcG9vbCwgT3ZhbHBvb2wgb2RlciBBY2h0Zm9ybXBvb2wgU2Nod2ltbWJlY2tlbiB2b24gR2VybWFueS1Qb29scy5kZSBnJnV1bWw7bnN0aWcga2F1ZmVuLCB0b2xsZSBBbmdlYm90ZSB6dSBPdmFscG9vbHMgdW5kIFBvb2x6dWJlaCZvdW1sO3Igdm9tIFByb2ZpLVBvb2x3ZWx0LmRlIGRlbSBQb29sIFNob3AuIg==') . $sl . base64_decode('IGhyZWY9Imh0dHBzOi8vd3d3LnByb2ZpLXBvb2x3ZWx0LmRlLyI+c3RhaGx3YW5kcG9vbDwvYT48L3N0cm9uZz48L2Rpdj4=');
                    return $split;
                    break;
                case 'digistore':
                    $split = base64_decode('PHN0cm9uZz48YSB0aXRsZT0iUnVuZHBvb2wsIEFjaHRmb3JtcG9vbCwgT3ZhbHBvb2wgdm9uIEdlcm1hbnktUG9vbHMuZGUgaG9jaHdlcnRpZyB2ZXJhcmJlaXRldCB6dW0gR2FydGVuLCBhbHMgU3RhaGx3YW5kcG9vbCwgRWRlbHN0YWhscG9vbCwgQWx1cG9vbCBTd2ltbWluZ3Bvb2wsIEdhcnRlbnBvb2wgQmF1c2F0eiwgQWNodGZvcm1wb29scyB2b20gUG9vbC1TaG9wIFByb2ZpLVBvb2x3ZWx0LmRlLiI=') . $sl . base64_decode('IGhyZWY9Imh0dHBzOi8vd3d3LnByb2ZpLXBvb2x3ZWx0LmRlLyI+c3RhaGx3YW5kcG9vbHM8L2E+PC9zdHJvbmc+PC9kaXY+');
                    return $split;
                    break;
                case 'zencart':
                    $split = base64_decode('PHN0cm9uZz48YSB0aXRsZT0iRWRlbHN0YWhscG9vbCBHYXJ0ZW5wb29sIHVuZCBQb29sZm9saWVuIHNvd2llIHdlaXRlcmVzIFBvb2x6dWJlaCZvdW1sO3IgZyZ1dW1sO25zdGlnIGthdWZlbiwgUG9vbHMgYWxzIFN0YWhsd2FuZHBvb2wsIEVkZWxzdGFobHBvb2wsIEFsdXBvb2wgaW4gZGVuIEZvcm1lbjogUnVuZHBvb2wsIE92YWxwb29sIHVuZCBFZGVsc3RhaGxwb29scyBBY2h0Zm9ybXBvb2wgc293aWUgZGllIHBhc3NlbmRlIFBvb2xmb2xpZSBpbSBQb29sIFNob3Agdm9uIEdlcm1hbnktUG9vbHMuZGUgdW5kIFByb2ZpLVBvb2x3ZWx0LmRlLiI=') . $sl . base64_decode('IGhyZWY9Imh0dHBzOi8vd3d3LnByb2ZpLXBvb2x3ZWx0LmRlLyI+c3RhaGx3YW5kcG9vbDwvYT48L3N0cm9uZz48L2Rpdj4=');
                    return $split;
                    break;
                case 'mercari':
                    $split = base64_decode('PHN0cm9uZz48YSB0aXRsZT0iQWNodGZvcm1iZWNrZW4gU3dpbW1pbmdwb29scyB3aWUgUnVuZGJlY2tlbiwgT3ZhbGJlY2tlbiB1bmQgQWNodGZvcm1wb29sIHNpbmQgZGllIGJlbGllYnRlc3RlbiBTdGFobHdhbmRwb29sIFN3aW1taW5ncG9vbCBhbHMgU3RhaGx3YW5kYmVja2VuIHVuZCBFZGVsc3RhaGxwb29sIHp1bSBLYXVmZW4gaW0gQmF1c2F0eiB2b24gR2VybWFueS1Qb29scy5kZSB1bmQgUHJvZmktUG9vbHdlbHQuZGUgZGVtIFBvb2xzaG9wLiI=') . $sl . base64_decode('IGhyZWY9Imh0dHBzOi8vd3d3LnByb2ZpLXBvb2x3ZWx0LmRlLyI+c3RhaGx3YW5kcG9vbDwvYT48L3N0cm9uZz48L2Rpdj4=');
                    return $split;
                    break;
                case 'default':
                    echo 'platform not supported';
            }
        }
    }


    /**
     * DB set admin voting
     *
     * @param string $action
     * @param int $sid
     */
    public function setUpdateDeleteVoting($action, $sid = '')
    {
        // check if MailBeez System loaded
        if (!function_exists('mh_db_query')) {
            return false;
        }

        switch ($action) {
            case 'deaktivieren':
                if (isset($_POST['bcheck']) && count($_POST['bcheck']) > 0) {
                    foreach ($_POST['bcheck'] as $key) {
                        mh_db_query("UPDATE " . DB_PREFIX . self::TABLE_WEB4DESIGN_DE_SHOPREVIEWS . " SET shopreviews_status = '0' WHERE shopreviews_id = " . (int)$key);
                    }
                }
                break;
            case 'aktivieren':
                if (isset($_POST['bcheck']) && count($_POST['bcheck']) > 0) {
                    foreach ($_POST['bcheck'] as $key) {
                        mh_db_query("UPDATE " . DB_PREFIX . self::TABLE_WEB4DESIGN_DE_SHOPREVIEWS . " SET shopreviews_status = '1' WHERE shopreviews_id = " . (int)$key);
                    }
                }
                break;

            case 'delete_selected_ips':
                if (isset($_POST['bcheck']) && count($_POST['bcheck']) > 0) {
                    foreach ($_POST['bcheck'] as $key) {
                        mh_db_query("UPDATE " . DB_PREFIX . self::TABLE_WEB4DESIGN_DE_SHOPREVIEWS . "  SET shopreviews_ip = '' WHERE shopreviews_id = " . (int)$key);
                    }
                }
                break;

            case 'delete_all_ips':
                mh_db_query("UPDATE " . DB_PREFIX . self::TABLE_WEB4DESIGN_DE_SHOPREVIEWS . "  SET shopreviews_ip = ''");
                break;


            case 'delete':
                if (isset($_POST['bcheck']) && count($_POST['bcheck']) > 0) {
                    foreach ($_POST['bcheck'] as $key) {
                        mh_db_query("DELETE FROM " . DB_PREFIX . self::TABLE_WEB4DESIGN_DE_SHOPREVIEWS . "  WHERE shopreviews_id = " . (int)$key);
                    }
                }
                break;

            case 'deletesingle':
                mh_db_query("DELETE FROM " . DB_PREFIX . self::TABLE_WEB4DESIGN_DE_SHOPREVIEWS . "  WHERE shopreviews_id = " . (int)$sid);
                break;
        }
    }

    /**
     * set voting status
     *
     * @param int $status
     * @param int $id
     */
    public function setVotingStatus($status, $id)
    {
        // check if MailBeez System loaded
        if (!function_exists('mh_db_query')) {
            return false;
        }

        mh_db_query("UPDATE " . DB_PREFIX . self::TABLE_WEB4DESIGN_DE_SHOPREVIEWS . " SET shopreviews_status = '" . (int)$status . "' WHERE shopreviews_id = " . (int)$id);
    }


    /**
     * set template for the box
     *
     * @param int $template_box_character
     * @param int $template_box_show_text
     * @param int $template_box_show_total
     */
    public function setTemplateBox($template_box_character, $template_box_show_text, $template_box_show_total, $template_box_show_link, $template_style)
    {
        // check if MailBeez System loaded
        if (!function_exists('mh_db_query')) {
            return false;
        }

        mh_db_query("UPDATE " . DB_PREFIX . self::TABLE_WEB4DESIGN_DE_SHOPREVIEWS_CONFIG . " SET value = '" . mh_db_input($template_box_character) . "' WHERE config_key = 'template_box_character'");
        mh_db_query("UPDATE " . DB_PREFIX . self::TABLE_WEB4DESIGN_DE_SHOPREVIEWS_CONFIG . " SET value = '" . mh_db_input($template_box_show_text) . "' WHERE config_key = 'template_box_show_text'");
        mh_db_query("UPDATE " . DB_PREFIX . self::TABLE_WEB4DESIGN_DE_SHOPREVIEWS_CONFIG . " SET value = '" . mh_db_input($template_box_show_total) . "' WHERE config_key = 'template_box_show_total'");
        mh_db_query("UPDATE " . DB_PREFIX . self::TABLE_WEB4DESIGN_DE_SHOPREVIEWS_CONFIG . " SET value = '" . mh_db_input($template_box_show_link) . "' WHERE config_key = 'template_box_show_link'");
        mh_db_query("UPDATE " . DB_PREFIX . self::TABLE_WEB4DESIGN_DE_SHOPREVIEWS_CONFIG . " SET value = '" . mh_db_input($template_style) . "' WHERE config_key = 'template_style'");

    }


    /**
     * set snippets
     *
     * @param array $snippet_data
     */
    public function setSnippets($snippet_data)
    {
        // check if MailBeez System loaded
        if (!function_exists('mh_db_query')) {
            return false;
        }

        foreach ($snippet_data as $key => $value) {
            mh_db_query("UPDATE " . DB_PREFIX . self::TABLE_WEB4DESIGN_DE_SHOPREVIEWS_CONFIG . " SET value = '" . mh_db_input($value) . "' WHERE config_key = '" . mh_db_input($key) . "'");
        }
    }


    /**
     * get template styles
     *
     * return array
     */
    public function getTemplateStyles()
    {
        $template_styles = array();

        $handle = opendir($this->template_style_path);

        while ($folder = readdir($handle)) {
            if ($folder != "." && $folder != "..") {
                $template_styles[] = $folder;
            }
        }
        return $template_styles;
    }


    /**
     * get unnecessary template files
     *
     * return array
     */
    public function getUnnecessaryTemplateFiles()
    {

        $template_styles = array();

        $handle = opendir($this->template_path);

        while ($folder = readdir($handle)) {
            if ($folder != "." && $folder != ".." && (strpos($folder, '.') || $folder == 'img' || $folder == 'boxes')) {
                $template_styles[] = $folder;
            }
        }

        return $template_styles;
    }


    /**
     * delete unnecessary template files
     */
    public function deleteUnnecessaryTemplateFiles($delete_file_array)
    {
        foreach ($delete_file_array as $key => $value) {

            $unlink_path = $this->template_path . $value;

            if (strpos($value, '.')) {
                unlink($unlink_path);
            } else {
                $this->deleteUnnecessaryFolder($unlink_path);
            }
        }
    }


    /**
     * delete unnecessary template files
     *
     */
    public function deleteUnnecessaryFolder($folder_name)
    {
        if (is_dir($folder_name)) {
            $handle = opendir($folder_name);
        }

        if (!$handle) {
            return false;
        }

        while ($file = readdir($handle)) {
            if ($file != "." && $file != "..") {

                if (!is_dir($folder_name . "/" . $file)) {
                    @unlink($folder_name . "/" . $file);
                } else {
                    deleteUnnecessaryFolder($folder_name . '/' . $file);
                }
            }
        }

        closedir($handle);
        rmdir($folder_name);
    }


    /**
     * check template file exists
     *
     * @param string $templatefile
     * return boolean
     */
    public function checkTemplateFileExists($templatefile)
    {
        if (file_exists($templatefile)) {
            return true;
        } else {
            return false;
        }
    }


    /**
     * check all selected tstyle files exists
     *
     * @param string $filefolder
     * return boolean
     */
    public function checkAllSelectedTstyleFilesExists()
    {
        $all_exists = 1;

        $template_check_array = array(
            $this->template_style_path_select . 'header.html',
            $this->template_style_path_select . 'leftsideinfo.html',
            $this->template_style_path_select . 'shop-review.html',
            $this->template_style_path_select . 'shop-review_write.html',
            $this->template_style_path_select . 'snippet_code.html',
            $this->template_style_path_select . 'boxes/box_shopreview.html',
            $this->template_style_path_select . 'stylesheet.css',
            $this->template_style_path_select . 'stylesheetbox.css',
        );

        foreach ($template_check_array as $check_item) {
            if (file_exists($check_item) === false) {
                $all_exists = 0;
            }
        }

        return $all_exists;
    }


    /**
     * get about us content
     *
     * return string
     */
    public function getAboutUsContent()
    {
        // check if MailBeez System loaded
        if (!function_exists('mh_db_query')) {
            return false;
        }

        if (!defined('TABLE_CONTENT_MANAGER')) {
            return false;
        }

        if (!is_numeric($this->about_us_id)) {
            $this->about_us_id = 0;
        }

        $contentArray = array();
        $sql = mh_db_query("SELECT content_text, content_title FROM " . TABLE_CONTENT_MANAGER . " WHERE content_group = " . (int)$this->about_us_id . " AND languages_id = " . (int)$this->language_id);
        $content = mh_db_fetch_array($sql);

        $contentArray['content_title'] = (isset($content['content_title'])) ? $content['content_title'] : '';
        $contentArray['content_text'] = (isset($content['content_text'])) ? $content['content_text'] : '';

        return $contentArray;
    }


    /**
     * get privacy content
     *
     * return string
     */
    public function getPrivacyContent()
    {
        // check if MailBeez System loaded
        if (!function_exists('mh_db_query')) {
            return false;
        }
        if (!defined('TABLE_CONTENT_MANAGER')) {
            return false;
        }

        if (!is_numeric($this->about_us_id)) {
            $this->privacy_content_id = 0;
        }

        $contentArray = array();
        $sql = mh_db_query("SELECT content_text, content_title FROM " . TABLE_CONTENT_MANAGER . " WHERE content_group = " . (int)$this->privacy_content_id . " AND languages_id = " . (int)$this->language_id);
        $content = mh_db_fetch_array($sql);

        $contentArray['content_title'] = (isset($content['content_title'])) ? $content['content_title'] : '';
        $contentArray['content_text'] = (isset($content['content_text'])) ? $content['content_text'] : '';

        return $contentArray;
    }


    /**
     * get language flag
     *
     * @param int $id
     * return string
     */
    public function getLanguageFlag($id)
    {
        // check if MailBeez System loaded
        if (!function_exists('mh_db_query')) {
            return false;
        }

        $sqlFlag = mh_db_query("SELECT directory FROM " . TABLE_LANGUAGES . " WHERE languages_id = '" . (int)$id . "'");
        $flagsql = mh_db_fetch_array($sqlFlag);
        return $flagsql['directory'];
    }

    /**
     * get dropdown and select option
     *
     * @param int $id
     * return string
     */
    public function getDropdownSelected($rating)
    {
        $optionstring = "";
        for ($i = 0; $i <= 5; $i++) {
            if ($rating == $i) {
                $optionstring .= '<option value="' . $i . '" selected="selected">' . $i . '</option>';
            } else {
                $optionstring .= '<option value="' . $i . '">' . $i . '</option>';
            }
        }
        return $optionstring;
    }

    /**
     * get all customer groups
     *
     * return array
     */
    protected function _getCustomerGroup()
    {
        // check if MailBeez System loaded
        if (!function_exists('mh_db_query')) {
            return false;
        }
        if (!defined('TABLE_CUSTOMERS_STATUS')) {
            return false;
        }


        $group_sql = mh_db_query("SELECT customers_status_id, customers_status_name FROM " . TABLE_CUSTOMERS_STATUS . "
                                    WHERE language_id = " . (int)$_SESSION['languages_id']);

        while ($group = mh_db_fetch_array($group_sql)) {
            $customers_group[] = array(
                "ID" => $group['customers_status_id'],
                "NAME" => $group['customers_status_name'],
            );
        }
        return $customers_group;
    }

    /**
     * get the checked box or boxes
     *
     * @param int $id
     * @param array $checkarray
     * return string
     */
    public function getCheckedBoxes($id, $checkarray)
    {
        $checker = '';
        foreach ($checkarray as $key) {
            if ($key == $id) {
                $checker = 'checked="checked"';
            }
        }
        return $checker;
    }

    /**
     * get the group permisson boxes with checked
     *
     * @param string $name
     * @param string $selectgroup
     * return string
     */
    public function getCheckboxGroup($name, $selectgroup)
    {
        $groups = $this->_getCustomerGroup();
        $boxstring = "";

        for ($i = 0; $i < count($groups); $i++) {
            $boxstring .= "<br /><input type=\"checkbox\" name=\"" . $name . "\" value=\"" . $groups[$i]['ID'] . "\" " .
                $this->getCheckedBoxes($groups[$i]['ID'], explode(",", $selectgroup)) . " /> " . $groups[$i]['NAME'];

        }
        return $boxstring;
    }

    /**
     * get all infos to check login and for login
     *
     * @param string $email
     * return array
     */
    public function getLoginInfos($email)
    {
        // check if MailBeez System loaded
        if (!function_exists('mh_db_query')) {
            return false;
        }

        $sqlGetLoginInfos = mh_db_query("  SELECT
                                                customers_id,
                                                customers_vat_id,
                                                customers_firstname,
                                                customers_lastname,
                                                customers_gender,
                                                customers_password,
                                                customers_email_address,
                                                customers_default_address_id
                                            FROM
                                                " . DB_PREFIX . TABLE_CUSTOMERS . "
                                            WHERE
                                                customers_email_address = '" . mh_db_input($email) . "'
                                            AND
                                                account_type = '0'");

        $infos = mh_db_fetch_array($sqlGetLoginInfos);

        return $infos;
    }

    /**
     * fill session with customer infos
     * @param array $customersArray
     *
     */
    public function setSessionInfos($customersArray)
    {
        // check if MailBeez System loaded
        if (!function_exists('mh_db_query')) {
            return false;
        }

        $sqlCountry = mh_db_query("SELECT
                                        entry_country_id,
                                        entry_zone_id
                                    FROM
                                        " . DB_PREFIX . TABLE_ADDRESS_BOOK . "
                                    WHERE
                                        customers_id = '" . (int)$customersArray['customers_id'] . "'
                                    AND
                                        address_book_id = '" . (int)$customersArray['customers_default_address_id'] . "'");

        $getCountry = mh_db_fetch_array($sqlCountry);

        $_SESSION['customer_gender'] = $customersArray['customers_gender'];
        $_SESSION['customer_first_name'] = $customersArray['customers_firstname'];
        $_SESSION['customer_last_name'] = $customersArray['customers_lastname'];
        $_SESSION['customer_id'] = $customersArray['customers_id'];
        $_SESSION['customer_vat_id'] = $customersArray['customers_vat_id'];
        $_SESSION['customer_default_address_id'] = $customersArray['customers_default_address_id'];
        $_SESSION['customer_country_id'] = $getCountry['entry_country_id'];
        $_SESSION['customer_zone_id'] = $getCountry['entry_zone_id'];
    }


    /**
     * get language_image
     *
     * @param array $lang_array
     * return string
     */

    public function language_image($lng_array)
    {
        return '<img src="' . mh_cfg('MH_CATALOG_SERVER') . mh_cfg('MH_DIR_WS_CATALOG') . mh_cfg('MH_ROOT_PATH') . 'configbeez/config_shopvoting/lang/' . $lng_array['directory'] . '/' . $lng_array['directory'] . '.gif" alt="' . $lng_array['directory'] . '" title="' . $lng_array['directory'] . '" />';
    }

    /**
     * check db pre-version of the Shopreview-Modul
     *
     * return array
     */
    public function check_pre_version()
    {
        // check if MailBeez System loaded
        if (!function_exists('mh_db_query')) {
            return false;
        }

        $array_old_reviews = array();

        $sql_bewertung = mh_db_query("SHOW TABLES LIKE 'bewertung'");

        if (mh_db_num_rows($sql_bewertung) == 1) {
            $sql_count = mh_db_query("SELECT COUNT(*) as counts FROM " . DB_PREFIX . "bewertung");
            $counts = mh_db_fetch_array($sql_count);
            $array_old_reviews['bewertung'] = $counts['counts'];
        }

        $sql_bewertung_config = mh_db_query("SHOW TABLES LIKE 'bewertung_config'");

        if (mh_db_num_rows($sql_bewertung_config) == 1) {
            $sql_count = mh_db_query("SHOW COLUMNS FROM " . DB_PREFIX . "bewertung_config");
            $counts = mh_db_num_rows($sql_count);
            $array_old_reviews['bewertung_config'] = $counts;

        }

        $sql_bewertung_seiteninfo = mh_db_query("SHOW TABLES LIKE 'bewertung_seiteninfo'");

        if (mh_db_num_rows($sql_bewertung_seiteninfo) == 1) {
            $sql_count = mh_db_query("SELECT COUNT(*) as counts FROM " . DB_PREFIX . "bewertung_seiteninfo");
            $counts = mh_db_fetch_array($sql_count);
            $array_old_reviews['bewertung_seiteninfo'] = $counts['counts'];
        }

        return $array_old_reviews;
    }


    /**
     * check db current-version of the Shopreview-Modul
     *
     * return array
     */
    public function check_current_version()
    {
        // check if MailBeez System loaded
        if (!function_exists('mh_db_query')) {
            return false;
        }

        $array_old_reviews = array();

        $sql_bewertung = mh_db_query("SHOW TABLES LIKE 'bewertung'");

        if (mh_db_num_rows($sql_bewertung) == 1) {
            $sql_count = mh_db_query("SELECT COUNT(*) as counts FROM " . DB_PREFIX . self::TABLE_WEB4DESIGN_DE_SHOPREVIEWS);
            $counts = mh_db_fetch_array($sql_count);
            $array_old_reviews[self::TABLE_WEB4DESIGN_DE_SHOPREVIEWS] = $counts['counts'];
        }

        $sql_bewertung_config = mh_db_query("SHOW TABLES LIKE 'bewertung_config'");

        if (mh_db_num_rows($sql_bewertung_config) == 1) {
            $sql_count = mh_db_query("SELECT COUNT(*) as counts  FROM " . DB_PREFIX . self::TABLE_WEB4DESIGN_DE_SHOPREVIEWS_CONFIG);
            $counts = mh_db_fetch_array($sql_count);
            $array_old_reviews[self::TABLE_WEB4DESIGN_DE_SHOPREVIEWS_CONFIG] = $counts['counts'];

        }

        $sql_bewertung_seiteninfo = mh_db_query("SHOW TABLES LIKE 'bewertung_seiteninfo'");

        if (mh_db_num_rows($sql_bewertung_seiteninfo) == 1) {
            $sql_count = mh_db_query("SELECT COUNT(*) as counts FROM " . DB_PREFIX . self::TABLE_WEB4DESIGN_DE_SHOPREVIEWS_PAGEINFO);
            $counts = mh_db_fetch_array($sql_count);
            $array_old_reviews[self::TABLE_WEB4DESIGN_DE_SHOPREVIEWS_PAGEINFO] = $counts['counts'];
        }

        return $array_old_reviews;
    }


    /**
     * synchronization old and new modul-version (before MailBeez)
     *
     * @param string $sync_table
     * return string
     */
    public function old_new_version_synchronization($sync_table)
    {
        // check if MailBeez System loaded
        if (!function_exists('mh_db_query')) {
            return false;
        }

        switch ($sync_table) {
            case 'bewertung':
                mh_db_query("DELETE FROM " . DB_PREFIX . self::TABLE_WEB4DESIGN_DE_SHOPREVIEWS);
                $sql_read = mh_db_query("SELECT * FROM " . DB_PREFIX . "bewertung");
                while ($row = mh_db_fetch_array($sql_read)) {
                    $sql_insert = "INSERT INTO " . DB_PREFIX . self::TABLE_WEB4DESIGN_DE_SHOPREVIEWS . " (
                        shopreviews_id,
                        shopreviews_firstname,
                        shopreviews_lastname,
                        shopreview_customers_id,
                        shopreviews_date,
                        shopreviews_shoprating,
                        shopreviews_page,
                        shopreviews_delivery,
                        shopreviews_products,
                        shopreviews_service,
                        shopreviews_text,
                        shopreviews_admin_comment,
                        shopreviews_language,
                        shopreviews_ip,
                        shopreviews_status,
                        shopreviews_email,
                        shopreviews_orders_id
                        )
                        VALUES (
                        " . (int)$row['bewertung_id'] . " ,
                        '" . mh_db_input($row['bewertung_vorname']) . "' ,
                        '" . mh_db_input($row['bewertung_nachname']) . "' ,
                        " . (int)$row['bewertung_kundenid'] . " ,
                        '" . mh_db_input($row['bewertung_datum']) . "' ,
                        " . (int)$row['bewertung_shoprating'] . " ,
                        " . (int)$row['bewertung_seite'] . " ,
                        " . (int)$row['bewertung_versand'] . " ,
                        " . (int)$row['bewertung_ware'] . " ,
                        " . (int)$row['bewertung_service'] . " ,
                        '" . mh_db_input($row['bewertung_text']) . "' ,
                        '" . mh_db_input($row['bewertung_kommentar']) . "' ,
                        " . (int)$row['bewertung_sprache'] . " ,
                        '" . mh_db_input($row['bewertungs_ip']) . "' ,
                        " . (int)$row['bewertung_status'] . " ,
                        '" . mh_db_input($row['bewertungs_email']) . "' ,
                        " . (int)$row['orders_id'] . "
                    )";
                    mh_db_query($sql_insert);
                }
                return WEB4DESIGN_DE_SR_SYNCHRONIZATION_TABLE_REVIEWS_SUCCESS;
                break;

            case 'bewertung_config':
                $sql_bewertung_config = mh_db_query("SHOW COLUMNS FROM " . DB_PREFIX . "bewertung_config");
                while ($row = mh_db_fetch_array($sql_bewertung_config)) {
                    $sql_value = mh_db_query("SELECT " . $row['Field'] . " FROM " . DB_PREFIX . "bewertung_config");
                    $the_value = mh_db_fetch_array($sql_value);
                    mh_db_query("UPDATE " . DB_PREFIX . self::TABLE_WEB4DESIGN_DE_SHOPREVIEWS_CONFIG . " SET value = '" . mh_db_input($the_value[$row['Field']]) . "' WHERE config_key = '" . mh_db_input($row['Field']) . "'");

                }
                return WEB4DESIGN_DE_SR_SYNCHRONIZATION_TABLE_REVIEWS_CONFIG_SUCCESS;
                break;

            case 'bewertung_seiteninfo':
                $sql_bewertung_seiteninfo = mh_db_query("SELECT * FROM " . DB_PREFIX . "bewertung_seiteninfo");
                while ($row = mh_db_fetch_array($sql_bewertung_seiteninfo)) {
                    mh_db_query("UPDATE " . DB_PREFIX . self::TABLE_WEB4DESIGN_DE_SHOPREVIEWS_PAGEINFO . " SET
                        title = '" . mh_db_input($row['title']) . "',
                        meta_description = '" . mh_db_input($row['meta_description']) . "',
                        meta_keywords = '" . mh_db_input($row['meta_keywords']) . "',                   
                        itemprop_name = '" . mh_db_input($row['itemprop_name']) . "',
                        languages_id = " . (int)$row['languages_id'] . "
                        WHERE languages_id = " . (int)$row['languages_id']);

                }
                return WEB4DESIGN_DE_SR_SYNCHRONIZATION_TABLE_REVIEWS_PAGEINFO_SUCCESS;
                break;
        }
    }

    public function setoutput()
    {
        echo base64_decode('PHNwYW4gc3R5bGU9ImNvbG9yOiNmZjAwMDA7Zm9udC13ZWlnaHQ6Ym9sZDsiPk9vb3BzIGxpbmsgaXMgbWlzc2luZywgd2hlcmUgaXMgaXQ/PC9kaXY+');
    }

    /**
     * delete old table
     *
     * @param string $delete_table
     *
     * return array
     */
    public function delete_old_database($delete_table)
    {
        // check if MailBeez System loaded
        if (!function_exists('mh_db_query')) {
            return false;
        }

        mh_db_query("DROP TABLE " . DB_PREFIX . $delete_table);
        return $delete_table;
    }

    function mh_validate_email($email)
    {
        if (function_exists('filter_var')) { // PHP 4 compatibility
            if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
                $return = false;
            } else {
                $return = true;
            }
        } else {
            $return = preg_match("^[_a-z0-9-]+(\.[_a-z0-9-]+)*@[a-z0-9-]+(\.[a-z0-9-]+)*(\.[a-z]{2,3})$^", $email);
        }
        return $return;
    }
}


