<?php
/**
 * Shop-Reviews
 *
 * @released under the GNU General Public License
 * inspired and in parts based on
 * Copyright (c) 2003 osCommerce
 * @author H-P Sausen
 * @copyright (c) since 2010 web4design.de
 * @contact webmaster@web4design.de
 * @version 3.0
 */

// error_reporting(-1);
if (!defined('MH_DIR_FS_CATALOG')) {
    if (substr(DIR_FS_CATALOG, -1) != '/') {
        define('MH_DIR_FS_CATALOG', DIR_FS_CATALOG . '/');
    } else {
        define('MH_DIR_FS_CATALOG', DIR_FS_CATALOG);
    }
}

if (!defined('MH_ROOT_PATH')) {
    // default location
    $_MH_ROOT_PATH = 'mailhive/';
    $_mh_search_paths = array('mailhive/', 'ext/mailhive/', 'includes/external/mailhive/');

    foreach ($_mh_search_paths as $_MH_ROOT_PATH_TRY) {
        if (file_exists(MH_DIR_FS_CATALOG . $_MH_ROOT_PATH_TRY . 'cloudbeez/cloudloader_core.php')) {
            $_MH_ROOT_PATH = $_MH_ROOT_PATH_TRY;
            break;
        }
    }

    define('MH_ROOT_PATH', $_MH_ROOT_PATH);
}


require_once(MH_DIR_FS_CATALOG . MH_ROOT_PATH . 'common/functions/compatibility.php');
require_once(MH_DIR_CONFIG . 'config_shopvoting/classes/Shopvoting.php');

if (mh_cfg('MH_PLATFORM_GAMBIO') != false) {
    if ((mh_cfg('MH_PLATFORM_GAMBIO') < 2.3) && class_exists('Shopvoting')) {
        echo 'Mailbeez Shopvoting ERROR: Another shopvoting module is active. Please uninstall under: Modules &gt; Install &amp; Update';
    }
}

class Shopvoting_widget
{


    public function __construct()
    {

    }

    public function output()
    {
        return $this->_output_widget();
    }


    private function _output_widget()
    {

        $voting = new Shopvoting();
        $box_temp = $voting->boxsplit('', 1, 0);
        $box_voting = '';

        $box_smarty = new mh_Smarty;
//        $box_smarty->setCaching(false);
        $box_smarty->setTemplateDir($voting->template_path . 'boxes/'); // root dir to templates
        $box_smarty->setCompileCheck(true);
        $box_smarty->setCompileId('shopvoting');
        $box_smarty->setConfigDir($voting->main_path . 'lang/');
        $box_smarty->setCaching(0);

        $language = $_SESSION['language'];

        if (file_exists($box_smarty->getConfigDir(0) . $language . '/shopreview.php')) {
            $box_smarty->assign('language', $language);
        } else {
            $language = 'english';
            $box_smarty->assign('language', $language);
        }


        if (file_exists($voting->main_path . '/lang/' . $language . '/own_shopreview.php')) {
            require_once($voting->main_path . '/lang/' . $language . '/own_shopreview.php');
        } elseif (file_exists($voting->main_path . '/lang/' . $language . '/shopreview.php')) {
            require_once($voting->main_path . '/lang/' . $language . '/shopreview.php');
        }

        if (file_exists($voting->main_path . '/lang/' . $language . '/own_errors.php')) {
            require_once($voting->main_path . '/lang/' . $language . '/own_errors.php');
        } elseif (file_exists($voting->main_path . '/lang/' . $language . '/errors.php')) {
            require_once($voting->main_path . '/lang/' . $language . '/errors.php');
        }

        // require_once(DIR_FS_INC . 'mh_date_long.inc.php');


        if (!defined('TABLE_CUSTOMERS_STATUS')) {
            $readCheck = true;
        } else {
            $readCheck = $voting->getGroupAccess($voting->customer_group_read, (int)$_SESSION['customers_status']['customers_status_id']);
        }

        if ($readCheck == 1 && $voting->voting_module_active == 1) {

            $voting_text = $voting->getRandomQuote();

            $box_smarty->assign('SHOPREVIEWS_ALL_AVERAGE', $voting->getAverage(Shopvoting::COLUMN_WEB4DESIGN_DE_SHOPRATING));
            $box_smarty->assign('ALL_STARS', $voting->getStar($voting->getAverage(Shopvoting::COLUMN_WEB4DESIGN_DE_SHOPRATING)));

            $box_smarty->assign('SHOPREVIEWS_ALL', $voting->getCountDetailVotes(Shopvoting::COLUMN_WEB4DESIGN_DE_SHOPRATING));
            $box_smarty->assign('TEXT', mh_db_prepare_input($voting_text));
            $box_smarty->assign('TEXTLEN', strlen(htmlspecialchars(mh_db_prepare_input($voting_text))));
            $box_smarty->assign('LINK', mh_href_link_plain(FILENAME_WEB4DESIGN_DE_REVIEW_PAGE));
            $box_smarty->assign('RATING_TEXT', $voting->getVotingText());
            $box_smarty->assign('CHARACTER', $voting->template_box_character);
            $box_smarty->assign('SHOW_TEXT', $voting->template_box_show_text);
            $box_smarty->assign('SHOW_TOTAL', $voting->template_box_show_total);

            $box_smarty->assign('SNIPPING_TYPE_NAME', $voting->snippet_type_name);

            $box_smarty->assign('IMG_PATH_LOGO_URL', $voting->logo_url);

            $box_smarty->assign('SHOW_RICH_SNIPPET', $voting->template_box_show_snippets);

            $box_smarty->assign('ITEMPROP_NAME', $voting->itemprop_name);
            $box_smarty->assign('languageconf', $language);
            $box_smarty->assign('language', $language);
            $box_smarty->assign('tpl_path', $voting->template_path);
            $box_smarty->assign('module_path_url', $voting->module_path_url);

            // own templates start
            $check_individual_style = 0;

            if ($voting->template_style != 'standard') {
                $check_individual_style = $voting->checkAllSelectedTstyleFilesExists();
            }


            $template_style_select_path = $voting->template_style_path . $voting->template_style . '/';
            $template_style_css_path = $voting->template_style_css_path . $voting->template_style . '/';

            $check_individual_style = $voting->checkAllSelectedTstyleFilesExists();

            if ($check_individual_style == 0) {
                $template_style_select_path = $voting->template_style_path . Shopvoting::SHOPVOTING_DEFAULT_TEMPLATE . '/';
                $template_style_css_path = $voting->template_style_css_path . Shopvoting::SHOPVOTING_DEFAULT_TEMPLATE . '/';
            }
            $box_smarty->assign('STYLESHEET_BOX_PATH', $template_style_css_path . '/stylesheetbox.css?v=' . mh_cfg('MAILBEEZ_VERSION'));

            $box_voting .= $voting->boxsplit(1, '', 0);
            $box_voting .= $box_smarty->fetch($template_style_select_path . 'boxes/box_shopreview.html');

            // own templates end
            return $box_voting . $box_temp;
        }

    }
}
