<?php
/**
 * Shop-Reviews
 *
 * @released under the GNU General Public License
 * inspired and in parts based on
 * Copyright (c) 2003 osCommerce
 * @author H-P Sausen
 * @copyright (c) since 2010 web4design.de
 * @contact webmaster@web4design.de
 * @version 3.0
 */

require_once('includes/application_top.php');

error_reporting(E_ALL & ~E_DEPRECATED & ~E_NOTICE & ~E_STRICT);
//error_reporting(E_ALL & ~E_NOTICE & ~E_STRICT);
ini_set('display_errors', 1);

if (!defined('MH_DIR_FS_CATALOG')) {
    if (substr(DIR_FS_CATALOG, -1) != '/') {
        define('MH_DIR_FS_CATALOG', DIR_FS_CATALOG . '/');
    } else {
        define('MH_DIR_FS_CATALOG', DIR_FS_CATALOG);
    }
}

if (!defined('MH_ROOT_PATH')) {
    // default location
    $_MH_ROOT_PATH = 'mailhive/';
    $_mh_search_paths = array('mailhive/', 'ext/mailhive/', 'includes/external/mailhive/');

    foreach ($_mh_search_paths as $_MH_ROOT_PATH_TRY) {
        if (file_exists(MH_DIR_FS_CATALOG . $_MH_ROOT_PATH_TRY . 'cloudbeez/cloudloader_core.php')) {
            $_MH_ROOT_PATH = $_MH_ROOT_PATH_TRY;
            break;
        }
    }

    define('MH_ROOT_PATH', $_MH_ROOT_PATH);
}


require_once(MH_DIR_FS_CATALOG . MH_ROOT_PATH . 'common/functions/compatibility.php');
require_once(MH_DIR_FS_CATALOG . MH_ROOT_PATH . 'common/classes/mailhive.php');


function load_classes($class_name)
{
    $file = MH_DIR_CONFIG . 'config_shopvoting/classes/' . $class_name . '.php';
    if (!file_exists($file)) return false;
    require_once $file;
}

spl_autoload_register('load_classes');


$voting = new Shopvoting();

$smarty = new mh_Smarty;
$smarty->setTemplateDir($voting->template_path); // root dir to templates
$smarty->setCompileCheck(true);
$smarty->setCompileId('shopvoting');
$smarty->setConfigDir($voting->main_path . 'lang/');

if (isset($language) && mh_session('language') == '') {
    $_SESSION['language'] = $language;
}
$user_language = mh_session('language');

list($smarty_config_dir) = $smarty->getConfigDir();

if (stream_resolve_include_path($smarty_config_dir . $user_language . '/shopreview.php')) {
    $smarty->assign('language', $user_language);
} else {
    $user_language = 'english';
    $smarty->assign('language', $user_language);
}


if (file_exists($voting->main_path . 'lang/' . $user_language . '/own_shopreview.php')) {
    require_once($voting->main_path . 'lang/' . $user_language . '/own_shopreview.php');
} else {
    require_once($voting->main_path . 'lang/' . $user_language . '/shopreview.php');
}

$own_lang_conf = 0;
if (file_exists($voting->main_path . 'lang/' . $user_language . '/own_shopreview.conf')) {
    $own_lang_conf = 1;
}


// MailBeez shoprating advanced autologin script
if (file_exists(MH_DIR_FS_CATALOG . MH_ROOT_PATH . 'mailbeez/shoprating_advanced/includes/autologin.php')) {
    include_once(MH_DIR_FS_CATALOG . MH_ROOT_PATH . 'mailbeez/shoprating_advanced/includes/autologin.php');
} elseif (MH_PLATFORM == 'xtc' || MH_PLATFORM == 'gambio') {
    include(MH_DIR_CONFIG . 'config_shopvoting/includes/inc_auth_xtc.php');
} elseif (MH_PLATFORM == 'zencart') {
    include(MH_DIR_CONFIG . 'config_shopvoting/includes/inc_auth_zencart.php');
} else {
    include(MH_DIR_CONFIG . 'config_shopvoting/includes/inc_auth_basic.php');
}
/**
 * get customers values if login
 */

$vars_array = array();

if (mh_session('customer_id')) {
    $customer_values = array();
    $customer_values = $voting->getLoginCustomersValues((int)mh_session('customer_id'));
    $vars_array['voting_customers_firstname'] = $customer_values['customers_firstname'];
    $vars_array['voting_customers_lastname'] = $customer_values['customers_lastname'];
    $vars_array['voting_customers_email'] = $customer_values['customers_email_address'];
}

// MailBeez
// allow to pre-insert order id
if (file_exists(MH_DIR_FS_CATALOG . MH_ROOT_PATH . 'mailbeez/shoprating_advanced/includes/autologin.php')) {
    $vars_array['orders_id'] = mh_get('orders_id', '');
}
/**
 * check and insert the voting
 */
$error = array();

$orders_id = mh_post('orders_id', mh_get('orders_id'));
$shopreviews_text = mh_post('shopreviews_text');
$firstname = mh_post('voting_customers_firstname');
$lastname = mh_post('voting_customers_lastname');
$post_email = mh_post('email');

$email_address = mh_post('email_address');


$rating_shop = mh_post(Shopvoting::COLUMN_WEB4DESIGN_DE_SHOPRATING, 0);
$rating_products = mh_post(Shopvoting::COLUMN_WEB4DESIGN_DE_PRODUCTS, 0);
$rating_delivery = mh_post(Shopvoting::COLUMN_WEB4DESIGN_DE_DELIVERY, 0);
$rating_service = mh_post(Shopvoting::COLUMN_WEB4DESIGN_DE_SERVICE, 0);
$rating_page = mh_post(Shopvoting::COLUMN_WEB4DESIGN_DE_PAGE, 0);

if (mh_post('send')) {

    $vars_array['rating_shop'] = $rating_shop;
    $vars_array['rating_products'] = $rating_products;
    $vars_array['rating_delivery'] = $rating_delivery;
    $vars_array['rating_service'] = $rating_service;
    $vars_array['rating_page'] = $rating_page;
    $vars_array['shopreviews_text'] = substr($shopreviews_text, 0, $voting->front_page_character);
    $vars_array['voting_customers_firstname'] = mh_db_prepare_input($firstname);
    $vars_array['voting_customers_lastname'] = mh_db_prepare_input($lastname);
    $vars_array['shopreview_customers_id'] = (int)$_SESSION['customer_id'];


    if($voting->privacy_save_ip == '1') {
        $vars_array['shopreviews_ip'] = $_SERVER['REMOTE_ADDR'];
    } else {
        $vars_array['shopreviews_ip'] = '';
    }
   

    $vars_array['shopreviews_language'] = (int)$_SESSION['languages_id'];
    $vars_array['captchacheck'] = $captchaCheck;

    $vars_array['orders_id'] = $orders_id;
    $vars_array['vvcode'] = mh_post('vvcode');
    $vars_array['voting_customers_email'] = $post_email;
    $vars_array['check_privacy'] = mh_post('check_privacy');
    $vars_array['lastname'] = $lastname;
    $smarty->assign('CHECK_PRIVACY', $vars_array['check_privacy']);

    $error = $voting->getErrorCheck($vars_array);

    $rating_error = $voting->getErrorCheckRatings($vars_array);



    if (sizeof($error) == 0 && sizeof($rating_error) == 0 && $voting->getErrorCheckratingShop($vars_array) == 1) {
        $voting->setDbVoting($vars_array);
        $vars_array['rating_shop'] = '';
        $vars_array['shopreviews_text'] = '';
        $vars_array['voting_customers_email'] = '';


        // MailBeez shoprating advanced autologoff script
        if (file_exists(MH_DIR_FS_CATALOG . MH_ROOT_PATH . 'mailbeez/shoprating_advanced/includes/autologoff.php')) {
            include_once(MH_DIR_FS_CATALOG . MH_ROOT_PATH . 'mailbeez/shoprating_advanced/includes/autologoff.php');
        }
        mh_redirect(mh_href_link(FILENAME_WEB4DESIGN_DE_REVIEW_PAGE, 'review=ok', 'NONSSL'));
    }

    $smarty->assign('RATING_ERROR', $rating_error);

}

/**
 * set the pagepart info
 */
$pagepart = $voting->pagepart();

/**
 * count the different votes
 */
$count_all_positiv = $voting->getCountSingleVotes(Shopvoting::POSITIV_RATES, Shopvoting::COLUMN_WEB4DESIGN_DE_SHOPRATING);
$count_all_neutral = $voting->getCountSingleVotes(Shopvoting::NEUTRAL_RATES, Shopvoting::COLUMN_WEB4DESIGN_DE_SHOPRATING);
$count_all_negative = $voting->getCountSingleVotes(Shopvoting::NEGATIVE_RATES, Shopvoting::COLUMN_WEB4DESIGN_DE_SHOPRATING);

/**
 * get the average
 */
$average_all = $voting->getAverage(Shopvoting::COLUMN_WEB4DESIGN_DE_SHOPRATING);
$average_site = $voting->getAverage(Shopvoting::COLUMN_WEB4DESIGN_DE_PAGE);
$average_shipping = $voting->getAverage(Shopvoting::COLUMN_WEB4DESIGN_DE_DELIVERY);
$average_service = $voting->getAverage(Shopvoting::COLUMN_WEB4DESIGN_DE_SERVICE);
$average_products = $voting->getAverage(Shopvoting::COLUMN_WEB4DESIGN_DE_PRODUCTS);

/**
 * assign some smarty
 */

$smarty->assign('languageconf', $_SESSION['language']);
$smarty->assign('language', $_SESSION['language']);
$smarty->assign('languageCode', $_SESSION['language_code']);
$smarty->assign('tplPath', $voting->template_path);
$smarty->assign('modulePathUrl', $voting->module_path_url);
$smarty->assign('CANONICAL', $PHP_SELF);
$smarty->assign('LANGUAGES', $voting->getLanguagesBox(FILENAME_WEB4DESIGN_DE_REVIEW_WRITE));
$smarty->assign('IMG_PATH', $voting->img_path);



$smarty->assign('RATING_ERROR_PRODUCTS', $voting->obligation_products);
$smarty->assign('RATING_ERROR_DELIVERY', $voting->obligation_delivery);
$smarty->assign('RATING_ERROR_SERVICE', $voting->obligation_service);
$smarty->assign('RATING_ERROR_PAGE', $voting->obligation_page);


$smarty->assign('FORMSTART', mh_href_link_plain(FILENAME_WEB4DESIGN_DE_REVIEW_WRITE));

$smarty->assign('FIRSTNAME_POST', $firstname);
$smarty->assign('LASTNAME_POST', $lastname);
$smarty->assign('EMAIL_POST', $post_email);

$smarty->assign('NAME_CHECK', $voting->required_name);
$smarty->assign('COMMENT_CHECK', $voting->required_comment);



$smarty->assign('EMAIL_ADDRESS', $email_address);
$smarty->assign('LINK_ACCOUNT', mh_href_link(FILENAME_LOGIN));


$smarty->assign('ORDERS_ID_POST', $orders_id);
$smarty->assign('ORDERS_ID_CHECK', $voting->required_order_id);
$smarty->assign('SHOPREVIEWS_TEXT', $shopreviews_text);


$smarty->assign('OPTFIELD_SHOP', $voting->getRadioButtons($rating_shop, Shopvoting::COLUMN_WEB4DESIGN_DE_SHOPRATING));
$smarty->assign('OPTFIELD_PRODUCTS', $voting->getRadioButtons($rating_products, Shopvoting::COLUMN_WEB4DESIGN_DE_PRODUCTS));
$smarty->assign('OPTFIELD_DELIVERY', $voting->getRadioButtons($rating_delivery, Shopvoting::COLUMN_WEB4DESIGN_DE_DELIVERY));
$smarty->assign('OPTFIELD_SERVICE', $voting->getRadioButtons($rating_service, Shopvoting::COLUMN_WEB4DESIGN_DE_SERVICE));
$smarty->assign('OPTFIELD_PAGE', $voting->getRadioButtons($rating_page, Shopvoting::COLUMN_WEB4DESIGN_DE_PAGE));

if (MH_REQUEST_TYPE == 'NONSSL' && strpos($voting->logo_url, 'https://') === 0) {
    $voting->logo_url = str_replace('https://', 'http://', $voting->logo_url);
}

$smarty->assign('IMG_PATH_LOGO_URL', $voting->logo_url);
$smarty->assign('languageconf', $_SESSION['language']);
$smarty->assign('INPUT_CODE', mh_draw_input_field('vvcode', '', 'size="6" maxlength="6"', 'text', false));

if (mh_fn('FILENAME_DISPLAY_VVCODES')) {
    $smarty->assign('VVIMG', mh_href_link(mh_fn('FILENAME_DISPLAY_VVCODES'), '', 'SSL'));
}

$smarty->assign('BUTTON_BACK_LINK', mh_href_link(FILENAME_WEB4DESIGN_DE_REVIEW_PAGE, '', 'NONSSL'));
$smarty->assign('BUTTON_PATH', $voting->module_path_url . 'templates/buttons/' . $user_language . '/');
$smarty->assign('CHARACTER', $voting->front_page_character);


$smarty->assign('SHOPREVIEWS_POSITIVE', $count_all_positiv);
$smarty->assign('SHOPREVIEWS_NEUTRAL', $count_all_neutral);
$smarty->assign('SHOPREVIEWS_NEGATIVE', $count_all_negative);

$smarty->assign('SHOPREVIEWS_ALL', $voting->getCountDetailVotes(Shopvoting::COLUMN_WEB4DESIGN_DE_SHOPRATING));
$smarty->assign('SHOPREVIEWS_ALL_PAGE', $voting->getCountDetailVotes(Shopvoting::COLUMN_WEB4DESIGN_DE_PAGE));
$smarty->assign('SHOPREVIEWS_ALL_DELIVERY', $voting->getCountDetailVotes(Shopvoting::COLUMN_WEB4DESIGN_DE_DELIVERY));
$smarty->assign('SHOPREVIEWS_ALL_SERVICE', $voting->getCountDetailVotes(Shopvoting::COLUMN_WEB4DESIGN_DE_SERVICE));
$smarty->assign('SHOPREVIEWS_ALL_PRODUCTS', $voting->getCountDetailVotes(Shopvoting::COLUMN_WEB4DESIGN_DE_PRODUCTS));


$smarty->assign('RATING_POSITIVE_PERCENT', $voting->getPercentage($count_all_positiv));
$smarty->assign('RATING_NEUTRAL_PERCENT', $voting->getPercentage($count_all_neutral));
$smarty->assign('RATING_NEGATIVE_PERCENT', $voting->getPercentage($count_all_negative));

$smarty->assign('SHOPREVIEWS_ALL_AVERAGE', $average_all);
$smarty->assign('SHOPREVIEWS_PAGE', $average_site);
$smarty->assign('SHOPREVIEWS_DELIVERY', $average_shipping);
$smarty->assign('SHOPREVIEWS_SERVICE', $average_service);
$smarty->assign('SHOPREVIEWS_PRODUCTS', $average_products);

$smarty->assign('ALL_STARS', $voting->getStar($average_all));
$smarty->assign('PAGE_STARS', $voting->getStar($average_site));
$smarty->assign('DELIVERY_STARS', $voting->getStar($average_shipping));
$smarty->assign('SERVICE_STARS', $voting->getStar($average_service));
$smarty->assign('PRODUCTS_STARS', $voting->getStar($average_products));

$smarty->assign('RATING_TEXT', $voting->getVotingText($average_all));

// unused
// $smarty->assign('module_content', $voting->getReviewVotes((int)mh_get('page'), $vote_split));
$smarty->assign('BACK_LINK', mh_href_link(FILENAME_WEB4DESIGN_DE_REVIEW_PAGE, '', 'NONSSL'));
$smarty->assign('BACK_IMAGE', $voting->module_path_url . 'templates/buttons/' . $user_language . '/back.png');
$smarty->assign('OPINION_IMAGE', $voting->module_path_url . 'templates/buttons/' . $user_language . '/button_vote.png');
$smarty->assign('NO_OP', '1');


$smarty->assign('IMG_PATH', $voting->img_path);
$smarty->assign('HOME', mh_href_email_link(FILENAME_DEFAULT, ''));

$smarty->assign('TITLE', $voting->title);
$smarty->assign('META_DESCRIPTION', $voting->meta_description);
$smarty->assign('META_KEYWORDS', $voting->meta_keywords);
$smarty->assign('AUTHOR', $voting->snippet_author);
$smarty->assign('ITEMPROP_NAME', $voting->itemprop_name);
$smarty->assign('SHOW_RICH_SNIPPET', $voting->template_box_show_snippets);
$smarty->assign('SNIPPING_TYPE_NAME', $voting->snippet_type_name);

$smarty->assign('ABOUT_US', $voting->getAboutUsContent());
$smarty->assign('PRIVACY_CONTENT', $voting->getPrivacyContent());

$smarty->assign('PRIVACY_CHECKBOX', $voting->privacy_checkbox);
$smarty->assign('PRIVACY_SHOW_TEXT', $voting->privacy_show_text);


$smarty->assign('OWN_LANG_CONF', $own_lang_conf);


$checkSSL = '';
if (MH_REQUEST_TYPE == 'SSL') {
    $checkSSL = HTTPS_SERVER . DIR_WS_CATALOG;
} else {
    $checkSSL = HTTP_SERVER . DIR_WS_CATALOG;
}

$smarty->assign('BASE', $checkSSL);


/**
 * check the captcha and maybe errors
 */

if ($captchaCheck == 1) {
    if (mh_fn('FILENAME_DISPLAY_VVCODES')) {
        $smarty->assign('CAPTCHACHECK', 'captcha');
    }
}

if ($voting->getErrorCheckratingShop($vars_array) == 0 && !empty($_POST)) {
    $smarty->assign('ERROR_SHOPRATING', 1);
}

if (sizeof($error) > 0) {
    $smarty->assign('ERROR', $voting->getErrorCheck($vars_array));
}
$smarty->assign('language', $_SESSION['language']);




$template_style_select_path = $voting->template_style_path . $voting->template_style . '/';
$template_style_css_path = $voting->template_style_css_path . $voting->template_style . '/';

$check_individual_style = $voting->checkAllSelectedTstyleFilesExists();

if($check_individual_style == 0) {
    $template_style_select_path = $voting->template_style_path . Shopvoting::SHOPVOTING_DEFAULT_TEMPLATE . '/';
    $template_style_css_path = $voting->template_style_css_path . Shopvoting::SHOPVOTING_DEFAULT_TEMPLATE . '/';
}


$smarty->assign('HEADER', $template_style_select_path . 'header.html');
$smarty->assign('SNIPPET_CODE', $template_style_select_path . 'snippet_code.html');
$smarty->assign('STYLESHEET_PATH', $template_style_css_path . 'stylesheet.css?v=' . mh_cfg('MAILBEEZ_VERSION'));
$smarty->assign('STYLESHEET_BOX_PATH', $template_style_css_path . 'stylesheetbox.css?v=' . mh_cfg('MAILBEEZ_VERSION'));
$smarty->assign('LEFTSIDEINFO', $template_style_select_path . 'leftsideinfo.html');
$smarty->display($template_style_select_path . 'shop-review_write.html');



$voting->modulesout();

if (!$voting->routput) {
    $voting->setoutput();
}
// MailBeez shoprating advanced autologoff script
if (file_exists(MH_DIR_FS_CATALOG . MH_ROOT_PATH . 'mailbeez/shoprating_advanced/includes/autologoff.php')) {
    include_once(MH_DIR_FS_CATALOG . MH_ROOT_PATH . 'mailbeez/shoprating_advanced/includes/autologoff.php');
}
mh_exit();
