<?php

/*
  MailBeez Automatic Trigger Email Campaigns
  http://www.mailbeez.com

  Copyright (c) 2010, 2011 MailBeez

  inspired and in parts based on
  Copyright (c) 2003 osCommerce

  Released under the GNU General Public License
 */

///////////////////////////////////////////////////////////////////////////////
///																																					 //
///                 MailBeez Core file - do not edit                         //
///                                                                          //
///////////////////////////////////////////////////////////////////////////////

require_once(MH_DIR_FS_CATALOG . MH_ROOT_PATH . 'common/classes/configbeez.php');

class config_simulation extends configbeez
{

// class constructor
    function __construct()
    {
        parent::__construct();
        $this->code = 'config_simulation';
        $this->module = 'config_simulation'; // same as folder name
        $this->version = '2.0'; // float value
        $this->title = mh_lng('MAILBEEZ_CONFIG_SIMULATION_TEXT_TITLE');
        $this->description = mh_lng('MAILBEEZ_CONFIG_SIMULATION_TEXT_DESCRIPTION');
        $this->description_image = '../../common/images/icon_sim_64.png';
        $this->icon = '../../common/images/icon_sim.png';
        $this->removable = false; // can't be removed
        $this->stealth = true; // don't list as an installed module
        $this->display_as_submodule_of = 'config';
        $this->sort_order = 1;
        $this->enabled = ((mh_cfg('MAILBEEZ_MAILHIVE_STATUS') == 'True') ? true : false);
        $this->status_key = 'MAILBEEZ_CONFIG_SIMULATION_STATUS';
        $this->admin_action_plugins_path = MH_DIR_CONFIG; // default-path to include admin action plugins from
        $this->admin_action_plugins = 'simulation_restart.php';

        $this->documentation_key = 'config_simulation'; // leave empty if no documentation available
        $this->documentation_root = 'https://www.mailbeez.com/documentation/';

        $this->_blueprint();

    }

    function config_simulation()
    {
        self::__construct();
    }    
    
// class methods

    function getAudience()
    {
        return false;
    }

    function check()
    {
        return true;
    }

    function remove()
    {
        return false;
    }

    // installation methods

    function keys()
    {
        return array('MAILBEEZ_MAILHIVE_MODE', 'MAILBEEZ_CONFIG_SIMULATION_ENABLE_AUTOMATION', 'MAILBEEZ_CONFIG_SIMULATION_TRACKING', 'MAILBEEZ_CONFIG_SIMULATION_EMAIL', 'MAILBEEZ_CONFIG_SIMULATION_COPY');
    }

    function install()
    {
        return false;
    }

}

