<?php

namespace SiteZen\Telemetry\Bootstrap;
class Gate
{
    // only let pass valid requests
    static function check($config, $token, $request_method = 'POST'): void
    {
        if (strtoupper($request_method) != 'POST') {
            throw new \Exception('NoPOST', 401);
        }

        if (!isset($config['token']) || empty($config['token'])) {
            throw new \Exception('No token configured', 403);
        }

        if (empty($token)) {
            throw new \Exception('NoToken', 401);
        }

        if ($config['token'] != $token) {
            throw new \Exception('InvalidToken', 401);
        }
    }
}
