<?php
namespace SiteZen\Telemetry\Connectors\DatabaseAdapters;

interface DbResult
{
    /**
     * Fetch next row as associative array. Return null when no more rows.
     */
    public function fetch_assoc(): ?array;

    /**
     * Free/cleanup resources.
     */
    public function free(): void;
}

interface DbAdapter
{
    /** Connect if necessary (no-op for some adapters). */
    public function connect(): void;

    /** Execute a SQL query and return an iterable result wrapper. */
    public function query(string $sql): DbResult;

    /** Error string for last operation. */
    public function error(): string;

    /** Close underlying connection if applicable. */
    public function close(): void;
}
