<?php

/*
  MailBeez Automatic Trigger Email Campaigns
  http://www.mailbeez.com

  Copyright (c) 2010, 2011 MailBeez

  inspired and in parts based on
  Copyright (c) 2003 osCommerce

  Released under the GNU General Public License
 */

///////////////////////////////////////////////////////////////////////////////
///																																					 //
///                 MailBeez Core file - do not edit                         //
///                                                                          //
///////////////////////////////////////////////////////////////////////////////

require_once(MH_DIR_FS_CATALOG . MH_ROOT_PATH . 'common/classes/configbeez.php');

class config_template_engine extends configbeez
{

// class constructor
    function __construct()
    {
        parent::__construct();
        $this->code = 'config_template_engine';
        $this->module = 'config_template_engine'; // same as folder name
        $this->version = '2.9'; // float value
        $this->title = mh_lng('MAILBEEZ_CONFIG_TEMPLATE_ENGINE_TEXT_TITLE');
        $this->description = mh_lng('MAILBEEZ_CONFIG_TEMPLATE_ENGINE_TEXT_DESCRIPTION');
        $this->icon = 'icon.png';
        $this->removable = false; // can't be removed
        $this->stealth = true; // don't list as an installed module
        $this->display_as_submodule_of = 'config';
        $this->sort_order = 5;
        $this->enabled = mh_cfg('MAILBEEZ_MAILHIVE_STATUS') == 'True';
        $this->status_key = 'MAILBEEZ_CONFIG_TEMPLATE_ENGINE_STATUS';
        $this->admin_action_plugins_path = MH_DIR_CONFIG; // default-path to include admin action plugins from
        $this->admin_action_plugins = 'clear_compile_dir.php';

        $this->documentation_key = 'config_template_engine'; // leave empty if no documentation available
    }

    function config_template_engine()
    {
        self::__construct();
    }

// class methods

    function getAudience()
    {
        return false;
    }

    function check()
    {
        return true;
    }

    function remove()
    {
        return false;
    }

    // installation methods

    function keys()
    {

        /*
        if (MH_PLATFORM != 'xtc' && MH_PLATFORM != 'gambio') {
            return array('MAILBEEZ_CONFIG_TEMPLATE_ENGINE_EMOGRIFY', 'MAILBEEZ_CONFIG_TEMPLATE_ENGINE_SMARTY_PATH');
        }
        */

        return array('MAILBEEZ_CONFIG_TEMPLATE_ENGINE_EMOGRIFY');
    }

    function install()
    {
        return false;
    }

}
