<?php

/*
  MailBeez Automatic Trigger Email Campaigns
  http://www.mailbeez.com

  Copyright (c) 2010 - 2012 MailBeez

  inspired and in parts based on
  Copyright (c) 2003 osCommerce

  Released under the GNU General Public License

 */


///////////////////////////////////////////////////////////////////////////////
///																																					 //
///                 MailBeez Core file - do not edit                         //
///                                                                          //
///////////////////////////////////////////////////////////////////////////////
mh_define('TABLE_MAILBEEZ_MODULE_CONFIGURATION', DB_PREFIX . 'mailbeez_module_configuration');
require_once(MH_DIR_CONFIG . 'config_tour/functions/general.php');


class tourbeez
{

    var $tour_module_directory;
    var $tour_module_directory_path;

// class constructor
    function __construct()
    {
        $this->code = ''; // unique id for report-module
        $this->module = ''; //
        $this->title = '';
        $this->description = '';
        $this->sort_order = '';
        $this->sort_order_dashboard = '';
        $this->enabled = true;
        $this->precondition_check = true;
        $this->precondition_false_message = '';
        $this->precondition_false_action = '';
        $this->display_as_submodule_of = null;
        $this->pro = null;

        $this->description_image = 'icon_big.png';
        $this->icon = 'icon.png';
        $this->hidden = false;
        $this->do_load = true;
        $this->content_file = 'tour.js';
        $this->content_directory = 'content/';
        $this->level = 'basic'; // basic|advanced|module
        return true;
    }



// class methods


    function install()
    {
        // to be done by instance
    }


    function get_tour_content()
    {
        // returns tour data
        $tour_content = '';
        if (file_exists($this->content_path)) {
            ob_start();
            include($this->content_path);
            $tour_content = ob_get_contents();
            ob_end_clean();
        } else {
            $tour_content = '/* tour content not found: ' . $this->content_path . ' */';
        }

        return $tour_content;
    }


    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    // common methods
    function get_module_id()
    {
        return $this->code;
    }

    function set_tour_module_directory($tour_module_directory)
    {
        $this->tour_module_directory = $tour_module_directory;
        $this->tour_module_directory_path = MH_DIR_FS_CATALOG . $tour_module_directory;
        $this->content_path = $this->tour_module_directory_path . $this->module . '/' . $this->content_directory . $this->content_file;
    }


    function start()
    {
        $data = array('time' => time(), 'status' => 'started');
        $this->set_configuration('status', $data);
    }

    function stop()
    {
        $data = array('time' => time(), 'status' => 'stopped');
        $this->set_configuration('status', $data);
    }

    function end()
    {
        $data = array('time' => time(), 'status' => 'ended');
        $this->set_configuration('status', $data);
    }

    function restart()
    {
        $this->stop();
        $this->start();
    }

    function get_status()
    {
        $data = $this->get_configuration('status');
        return $data;
    }

    function get_configuration($module_cfg_key)
    {
        $cfg_query_raw = "select * from " . TABLE_MAILBEEZ_MODULE_CONFIGURATION . "
                  where cfg_key = 'tour_" . $this->code . "_" . $module_cfg_key . "'";

        $cfg_query = mh_db_query($cfg_query_raw);
        if (mh_db_num_rows($cfg_query) == 0) {
            return false;
        }
        $cfg_value = mh_db_fetch_array($cfg_query);

        return unserialize($cfg_value['cfg_value']);
    }


    function set_configuration($module_cfg_key, $module_cfg_set)
    {
        // write configuration
        mh_db_query("delete from " . TABLE_MAILBEEZ_MODULE_CONFIGURATION . " where cfg_key = 'tour_" . $this->code . "_" . $module_cfg_key . "'");

        $sql_data_array = array('cfg_key' => 'tour_' . $this->code . '_' . $module_cfg_key,
            'cfg_value' => serialize($module_cfg_set),
            'last_modified' => 'now()',
            'date_added' => 'now()');
        mh_db_perform(TABLE_MAILBEEZ_MODULE_CONFIGURATION, $sql_data_array);
        return true;
    }

    function getAjaxEntrypoint($event)
    {
        $entrypoint_basic = mh_href_link(FILENAME_MAILBEEZ, 'app=load_app&app_path=config_tour/admin_application_plugins/overview.php&ajax=true&tour_module=' . $this->module);

        switch ($event) {
            case 'stop':
                $entrypoint = $entrypoint_basic . '&app_action=stop';
                break;
            case 'end':
                $entrypoint = $entrypoint_basic . '&app_action=end';
                break;
            default:
                $entrypoint = false;
                break;

        }

        return $entrypoint;
    }

}
