<?php


function mh_tour($load_active_module = null)
{
    global $request_profiler;
    global $mailbeez_tour_all_modules;
    $request_profiler->restart('---config_customer_tour_before_read_module_dir---');

    if (!is_array($mailbeez_tour_all_modules)) {
        $mailbeez_tour_all_modules = array();
    }


    $tour_module_directory_array = mh_tour_get_module_directory_array();
    $all_modules_directory = array();

    // read all modules
    foreach ($tour_module_directory_array as $tour_module_directory_current) {
        $start_time = microtime(true);

        list($all_modules_current, $all_modules_directory_current, $installed_modules_current) = mh_tour_load_modules($tour_module_directory_current);
        $end_time = microtime(true);
        mh_log("mh_tour_load_modules $tour_module_directory_current load time: %s", $end_time - $start_time);

        $mailbeez_tour_all_modules = $mailbeez_tour_all_modules + $all_modules_current;
        $all_modules_directory = $all_modules_directory + $all_modules_directory_current;
    }
    // sort all_modules
    uksort($mailbeez_tour_all_modules, "sortbyintvalue");


    // generate output for all modules

    $mInfo = '';
    $modules = array();
    $request_profiler->restart('---config_tour_before_module_list---');
    $active_tour = false;

    foreach ($mailbeez_tour_all_modules as $key => $module) {
        $start_time = microtime(true);

        $mInfo_current = mh_tour_process_modules($module);
        mh_log("processing module: $module in %s", microtime(true) - $start_time);

        $mInfo = is_object($mInfo_current) ? $mInfo_current : $mInfo;
        if ($mInfo->status['status'] == 'started') {
            $active_tour[] = $mInfo->module;
        }
        $modules[] = $mInfo;
    }


    return array($modules, $mailbeez_tour_all_modules, $active_tour);

}

function mh_tour_load_modules($tour_module_directory)
{
    global $request_profiler;
    $tour_module_directory_path = MH_DIR_FS_CATALOG . $tour_module_directory;

    $directory_array = mh_read_module_directory($tour_module_directory_path);
    sort($directory_array);

    $installed_modules = array();
    $mailbeez_tour_all_modules = array();
    $all_modules_directory = array();
    for ($i = 0, $n = sizeof($directory_array); $i < $n; $i++) {
        $offset = 0;
        $file = $directory_array[$i];


        $class = substr($file, 0, strrpos($file, '.'));
        if (class_exists($class)) {
            if (array_key_exists($class, $GLOBALS) && is_object($GLOBALS[$class])) {
                continue;
            }
        }
        $load_start_time = microtime(true);


        $request_profiler->restart('config_tour_before_load: ' . $class);

        mh_load_modules_language_files($tour_module_directory_path, $class);

        // include class
        if (file_exists($tour_module_directory_path . $file) && !class_exists($class)) {
            include_once($tour_module_directory_path . $file);
        }
        if (class_exists($class)) {
            if (array_key_exists($class, $GLOBALS) || !isset($GLOBALS[$class])) {
                mh_log("creating object: %s", $class);
                $GLOBALS[$class] = new $class; // new object
                if (!mh_check_admin_rights($class) || !$GLOBALS[$class]->enabled) {
                    unset($GLOBALS[$class]);
                    continue;
                }
            }
            $GLOBALS[$class]->set_tour_module_directory($tour_module_directory);

            $tour_module = $GLOBALS[$class];

            if ($tour_module->sort_order > 0) {
                $all_modules_sortorder = $offset + ($tour_module->sort_order * 10000);
            } else {
                $all_modules_sortorder = $offset;
            }

            if ($tour_module->enabled && $tour_module->do_load) {
                if ($tour_module->display_as_submodule_of != '') {
                    $all_modules_sortorder += 900;
                } else {
                    $all_modules_sortorder += 1000;
                }
                $installed_modules[$all_modules_sortorder . $class] = $file; // make key unique but sortable as integer
            } elseif ($tour_module->do_load !== true) {
                continue;
            }

            $mailbeez_tour_all_modules[$all_modules_sortorder . $class] = $file;
            $all_modules_directory[$all_modules_sortorder . $class] = $tour_module_directory;
        } // if exists

        $load_end_time = microtime(true);
        mh_log("load module $class: %s", $load_end_time - $load_start_time);
    } // for
    return array($mailbeez_tour_all_modules, $all_modules_directory, $installed_modules);
}

// scan mailbeez modules automatically for "viewbeez" directory
// allow custom modules to overload default modules by loading "others" first
// push configbeez/config_customer_tour to the end


function mh_tour_get_module_directory_array()
{
    // on windows /tourbeez/ doesnot work
    // so add the / later
    $tour_module_directory_array = glob(MH_DIR_FS_CATALOG . MH_ROOT_PATH . '*/*/tourbeez', GLOB_ONLYDIR);
    $push_to_end_dir = '';

    if (is_array($tour_module_directory_array) && sizeof($tour_module_directory_array) > 0) {

        foreach ($tour_module_directory_array as $idx => $tour_module_directory) {

            $tour_module_directory_array[$idx] .= '/';
            $tour_module_directory_array[$idx] = str_replace(MH_DIR_FS_CATALOG, '', $tour_module_directory_array[$idx]);
            if (stristr($tour_module_directory_array[$idx], 'configbeez/config_tour')) {
                $push_to_end_dir = $tour_module_directory_array[$idx];
                unset($tour_module_directory_array[$idx]);
            }
        }
    }

    $tour_module_directory_array[] = $push_to_end_dir;
    return $tour_module_directory_array;
}


function mh_tour_process_modules($module)
{
    global $request_profiler;

    $file = $module;

    $class = substr($file, 0, strrpos($file, '.'));
    $request_profiler->restart('config_customer_tour_before_display: ' . $class);

    if (is_object($GLOBALS[$class])) {
        $tour_module = $GLOBALS[$class];

        $tour_status_data = $tour_module->get_status();
        if (is_array($tour_status_data)) {
            $tour_status = $tour_status_data;

        } else {
            $tour_status = array('status' => 'new');
        }

        $tour_module_info = array(
            'code' => $tour_module->get_module_id(),
            'module' => $tour_module->module,
            'title' => $tour_module->title,
            'description' => $tour_module->description,
            'description_image_src' => $tour_module->description_image,
            'icon' => (isset($tour_module->icon) ? $tour_module->icon : null),
            'status' => $tour_status,
            'level' => $tour_module->level,
            'pro' => $tour_module->pro,
            'precondition_check' => $tour_module->precondition_check,
            'precondition_false_message' => $tour_module->precondition_false_message,
            'precondition_false_action' => $tour_module->precondition_false_action,
            'module_directory' => $tour_module->tour_module_directory,
            'module_directory_path' => $tour_module->tour_module_directory_path,
        );
        $mInfo = new mh_objectInfo($tour_module_info);

    }
    return $mInfo;
}

function mh_tour_cnt()
{
    if (isset($_SESSION['mh_tour_cnt'])) {
        return $_SESSION['mh_tour_cnt'];
    }

    list($tour_data, $tour_modules, $active_tours) = mh_tour();

    $new_tour_cnt = 0;
    foreach ($tour_data as $tour) {
        if ($tour->status['status'] != 'ended' && $tour->precondition_check) {
            $new_tour_cnt++;
        }
    }


    $_SESSION['mh_tour_cnt'] = $new_tour_cnt;

    return $new_tour_cnt;
}

function mh_tour_link_url($tour_module)
{
    $app_url = mh_href_link(FILENAME_MAILBEEZ, 'app=load_app&app_path=config_tour/admin_application_plugins/overview.php');
    $app_url .= '&app_action=start&tour_module=' . $tour_module;
    return $app_url;
}