<?php
// load active tour
$mh_tour_content = false;
if (isset($_SESSION['mh_active_tour']) || isset($_SESSION['mh_tour_action'])) {

    require_once(MH_DIR_FS_CATALOG . MH_ROOT_PATH . 'common/functions/compatibility.php');
    require_once(MH_DIR_CONFIG . 'config_tour/functions/general.php');
    mh_load_modules_language_files(MH_DIR_CONFIG, 'config_tour');

    list($tour_data, $tour_modules, $active_tours) = mh_tour();

    if (isset($_SESSION['mh_active_tour'])) {
        $active_tour_obj = $GLOBALS[$_SESSION['mh_active_tour']];
        if (is_object($active_tour_obj)) {
            $mh_tour_content = $active_tour_obj->get_tour_content();
        }
    }
}

if ($mh_tour_content || isset($_SESSION['mh_tour_action'])) { ?>


    <link rel="stylesheet" type="text/css"
          href="<?php echo MH_DIR_WS_CATALOG . MH_ROOT_PATH; ?>common/js/hopscotch/css/hopscotch.min.css?ver=<?php echo mh_cfg('MAILBEEZ_VERSION'); ?>"/>
    <style type="text/css">

        div.hopscotch-bubble * a {
            font-size: inherit;
            text-decoration: underline;
            font-family: inherit;
        }

        /*
        .animated {
          -webkit-animation-duration: 0.5s;
          -moz-animation-duration: 0.5s;
          -ms-animation-duration: 0.5s;
          -o-animation-duration: 0.5s;
          animation-duration: 0.5s;
        }
        */
    </style>
    <script language="javascript"
            src="<?php echo MH_DIR_WS_CATALOG . MH_ROOT_PATH; ?>common/js/hopscotch/js/hopscotch.js?ver=<?php echo mh_cfg('MAILBEEZ_VERSION'); ?>"></script>
    <script language="javascript"
            src="<?php echo MH_DIR_WS_CATALOG . MH_ROOT_PATH; ?>common/js/pure_ajax.js?ver=<?php echo mh_cfg('MAILBEEZ_VERSION'); ?>"></script>

    <script type="text/javascript">
        var tour = [];

        <?php echo $mh_tour_content;?>

        // common settings
        tour['id'] = "<?php echo $active_tour_obj->code; ?>";


        // common translation settings
        tour['i18n'] = {
            nextBtn: "<?php echo MH_TOUR_BUTTON_NEXT; ?>",
            prevBtn: "<?php echo MH_TOUR_BUTTON_PREV; ?>",
            doneBtn: "<?php echo MH_TOUR_BUTTON_DONE; ?>",
            skipBtn: "<?php echo MH_TOUR_BUTTON_SKIP; ?>",
            closeTooltip: "<?php echo MH_TOUR_TOOLTIP_CLOSE; ?>"
        };

        tour['onEnd'] = function () {
            <?php if (is_object($active_tour_obj)) { ?>
            doAjaxGet("<?php echo $active_tour_obj->getAjaxEntrypoint('end'); ?>");
            <?php } ?>
            mhTourEnd();
        };

        tour['onClose'] = function () {
            <?php if (is_object($active_tour_obj)) { ?>
            doAjaxGet("<?php echo $active_tour_obj->getAjaxEntrypoint('stop'); ?>")
            <?php } ?>
        };


        function mhTourEnd() {
            var el = document.getElementById('mh_tour_bar')
            el.className += el.className ? ' animated fade-in-up' : 'animated fade-in-up';
            el.style.visibility = 'visible';
        }

        // helper to find elements
        function mhElementByInnerHTML(selector, innerHTMLContent) {
            var elements = document.querySelectorAll(selector);
            for (var i = 0; i < elements.length; i++) {
                if (elements[i].innerHTML.indexOf(innerHTMLContent) > -1) {
//                if (elements[i].innerHTML == innerHTMLContent) {
                    return elements[i]
                }
            }
            return false;
        }

    </script>

    <div id="mh_tour_bar"
         style="width: 320px;height: 200px;position: fixed;top:0;bottom: 0;left: 0;right: 0;margin: auto;visibility: hidden">
        <div class="hopscotch-bubble tour-tour_end">
            <div style="width: 280px; padding: 15px;" class="hopscotch-bubble-container">
                <div class="hopscotch-bubble-content" style="margin: 0px !important;">
                    <h3 class="hopscotch-title"><?php echo MH_TOUR_FINALE_TITLE; ?></h3>

                    <div class="hopscotch-content"><?php echo MH_TOUR_FINALE_TEXT; ?></div>
                </div>
                <div class="hopscotch-actions">
                    <button class="hopscotch-nav-button"
                            onclick="document.getElementById('mh_tour_bar').style.visibility='hidden';"><?php echo MH_TOUR_BUTTON_CLOSE; ?>
                    </button>
                    <button class="hopscotch-nav-button next"
                            onclick="document.location.href='<?php echo mh_href_link(FILENAME_MAILBEEZ, 'app=load_app&app_path=config_tour/admin_application_plugins/overview.php'); ?>'">
                        <?php echo MH_TOUR_BUTTON_OVERVIEW; ?>
                    </button>
                </div>
                <a class="hopscotch-bubble-close hopscotch-close" href="#"
                   onclick="document.getElementById('mh_tour_bar').style.visibility='hidden';"
                   title="<?php echo MH_TOUR_TOOLTIP_CLOSE; ?>"><?php echo MH_TOUR_BUTTON_CLOSE; ?></a>
            </div>
        </div>
    </div>
<?php } ?>

<?php if (isset($_SESSION['mh_tour_action'])) {

    switch ($_SESSION['mh_tour_action']) {
        case 'run':
            ?>
            <script type="text/javascript">

                // <?php  if (MH_PLATFORM_GAMBIO >= 2.6) { ?>
                /* will be evaluated  - fix positioning issues*/
                $('body').on('JSENGINE_INIT_FINISHED', function () {
                    setTimeout(function () {
                        hopscotch.startTour(tour);
                    }, 100);
                });
                // <?php } else { ?>
                /* will be evaluated */
                hopscotch.startTour(tour);
                //<?php } ?>
                /* will be evaluated */
            </script>

            <?php
            break;

    }
}
