/*
 Must return javascript code

 PHP code will be parsed

 <?php
 echo time();
 ?>


 <?php

 $mh_tour_module = (defined('MAILBEEZ_CONFIG_TMPLMNGR_LNG_STATUS')) ? 'config_tmplmngr_lng' : 'config_tmplmngr';

 ?>

 */
// Define the tour!
var tour = {
    nextOnTargetClick: true,


    steps: [

        {
            title: "<?php echo MH_TOUR_SETUP_TEMPLATES_TITLE_STEP1; ?>",
            content: "<?php echo MH_TOUR_SETUP_TEMPLATES_CONTENT_STEP1; ?>",
            target: document.querySelector('[id*="tab_configbeez"]'),
            placement: "bottom",
            multipage: true, // indicates that the next step is on a different page.
            showNextButton: true,

            onNext: function () {
                window.location = "<?php echo mh_href_link(FILENAME_MAILBEEZ, 'tab=configbeez'); ?>"
            }
        },
        {
            title: "<?php echo MH_TOUR_SETUP_TEMPLATES_TITLE_STEP2; ?>",
            content: "<?php echo MH_TOUR_SETUP_TEMPLATES_CONTENT_STEP2; ?>",
            target: document.querySelector('[id*="<?php echo $mh_tour_module; ?>"]'),
            placement: "right",
            xOffset: "center",
            yOffset: -20,
            multipage: true, // indicates that the next step is on a different page.
            showNextButton: true,
            onNext: function () {
                window.location = "<?php echo mh_href_link(FILENAME_MAILBEEZ, 'set=&module=' . $mh_tour_module ); ?>"
            }

        },
        {
            title: "<?php echo MH_TOUR_SETUP_TEMPLATES_TITLE_STEP3; ?>",
            content: "<?php echo MH_TOUR_SETUP_TEMPLATES_CONTENT_STEP3; ?>",
            target: document.querySelector('[id*="MAILBEEZ_BUTTON_CONFIG_TMPLMNGR_CFG_COMMON"]'),
            placement: "left",
            yOffset: -10,
            multipage: true, // indicates that the next step is on a different page.
            showNextButton: true,
            onNext: function () {
                window.location = "<?php echo mh_href_link(FILENAME_MAILBEEZ, 'app=load_app&app_path=' . $mh_tour_module . '/admin_application_plugins/cfg_language_common.php&module=&module=<?php echo $mh_tour_module; ?>'); ?>"
            }

        },
        {
            title: "<?php echo MH_TOUR_SETUP_TEMPLATES_TITLE_EDITOR_AREA; ?>",
            content: "<?php echo MH_TOUR_SETUP_TEMPLATES_CONTENT_EDITOR_AREA; ?>",
            target: document.querySelector('[id^="nicescroll"]'),
            placement: "top",
            xOffset: "center",

            multipage: false, // indicates that the next step is on a different page.
            showNextButton: true,


        },
        {
            title: "<?php echo MH_TOUR_SETUP_TEMPLATES_TITLE_RESIZE_BUTTONS; ?>",
            content: "<?php echo MH_TOUR_SETUP_TEMPLATES_CONTENT_RESIZE_BUTTONS; ?>",
            target: document.querySelector('[id^="nicescroll"]'),
            placement: "top",
            yOffset: -20,

            multipage: false, // indicates that the next step is on a different page.
            showNextButton: true,


        },
        {
            title: "<?php echo MH_TOUR_SETUP_TEMPLATES_TITLE_SELECT_TEMPLATE; ?>",
            content: "<?php echo MH_TOUR_SETUP_TEMPLATES_CONTENT_SELECT_TEMPLATE; ?>",
            target: document.querySelector('[id*="MAILBEEZ_BUTTON_CONFIG_TMPLMNGR_CFG_SELECT_TEMPLATE"]'),
            placement: "left",
            yOffset: -20,

            multipage: false, // indicates that the next step is on a different page.
            showNextButton: true,


        },
        {
            title: "<?php echo MH_TOUR_SETUP_TEMPLATES_TITLE_STYLING; ?>",
            content: "<?php echo MH_TOUR_SETUP_TEMPLATES_CONTENT_STYLING; ?>",
            target: document.querySelector('[id*="MAILBEEZ_BUTTON_CONFIG_TMPLMNGR_CFG_STYLING"]'),
            placement: "left",
            yOffset: -20,

            multipage: false, // indicates that the next step is on a different page.
            showNextButton: true,


        },
        {
            title: "<?php echo MH_TOUR_SETUP_TEMPLATES_TITLE_MOBIL_PREVIEW; ?>",
            content: "<?php echo MH_TOUR_SETUP_TEMPLATES_CONTENT_MOBIL_PREVIEW; ?>",
            target: document.querySelector('[id*="MAILBEEZ_BUTTON_CONFIG_TMPLMNGR_CFG_MOBILE_PREVIEW"]'),
            placement: "left",
            yOffset: -20,

            multipage: false, // indicates that the next step is on a different page.
            showNextButton: true


        },
        {
            title: "<?php echo MH_TOUR_SETUP_TEMPLATES_TITLE_SEND_TEST; ?>",
            content: "<?php echo MH_TOUR_SETUP_TEMPLATES_CONTENT_SEND_TEST; ?>",
            target: document.querySelector('[id*="MAILBEEZ_BUTTON_CONFIG_TMPLMNGR_CFG_SEND_TEST"]'),
            placement: "left",
            yOffset: -20,

            multipage: false, // indicates that the next step is on a different page.
            showNextButton: true


        },
        {
            title: "<?php echo MH_TOUR_SETUP_TEMPLATES_TITLE_CREATE_TEMPLATE; ?>",
            content: "<?php echo MH_TOUR_SETUP_TEMPLATES_CONTENT_CREATE_TEMPLATE; ?>",
            target: document.querySelector('[id*="MAILBEEZ_BUTTON_CONFIG_TMPLMNGR_CFG_CREATE_TEMPLATE"]'),
            placement: "left",
            yOffset: -20,

            multipage: false, // indicates that the next step is on a different page.
            showNextButton: true


        }
    ]
}