<?php

/*
  MailBeez Automatic Trigger Email Campaigns
  http://www.mailbeez.com

  Copyright (c) 2010, 2011 MailBeez

  inspired and in parts based on
  Copyright (c) 2003 osCommerce

  Released under the GNU General Public License
 */

require_once(MH_DIR_FS_CATALOG . MH_ROOT_PATH . 'dashboardbeez/dashboard_statsbar.php');


class dashboard_statsbar_mini extends dashboard_statsbar
{

    var $code;
    var $module;
    var $title;
    var $description;
    var $sort_order;
    var $enabled = false;

    var $selected_startdate = null;
    var $selected_enddate = null;

    var $jsLoadFunctionName = 'loadMiniWidgets';


    function __construct($parameter = null)
    {
        $auto_init = !is_array($parameter);

        parent::__construct(false, $auto_init);
        $this->code = 'dashboard_statsbar_mini';
        $this->module = 'dashboard_statsbar_mini';
        $this->title = mh_lng('MAILBEEZ_DASHBOARD_STATSBAR_MINI_TITLE_LONG');
        $this->description = mh_lng('MAILBEEZ_DASHBOARD_STATSBAR_MINI_DESC');
        //$this->removable = false; // can't be removed
        $this->enabled = false; // do not load on Dashboard!
        $this->removable = false; // can't be removed
        $this->hidden = true;

        $this->status_key = 'MAILBEEZ_DASHBOARD_STATSBAR_MINI_STATUS';
        $this->documentation_root = 'https://www.mailbeez.com/documentation/dashboardbeez/';
        $this->documentation_key = $this->module;

        $this->admin_action_plugins_path = MH_DIR_FS_CATALOG . MH_ROOT_PATH . 'dashboardbeez/'; // default-path to include admin action plugins from
        $this->admin_action_plugins = '';


        $this->sort_order = mh_cfg('MAILBEEZ_DASHBOARD_STATSBAR_MINI_SORT_ORDER');
        // set cache reference

        $this->check_update();

        //
        if (!$auto_init) {
            $this->set_widget_mode(false);

            $statsbar_parameter = array(
                'widget_module_id', 'selected_module', 'selected_campaign', 'selected_campaign_item', 'selected_startdate', 'selected_enddate', 'leaderboard_include'
            );

            // set parameters
            foreach ($statsbar_parameter as $pname) {

                $pvalue = $parameter[$pname];

                switch ($pname) {
                    case 'selected_module':
                    case 'selected_campaign':
                    case 'selected_campaign_item':
                    case 'selected_startdate':
                    case 'selected_enddate':
                        if (!is_null($pvalue)) {
                            $this->$pname = $pvalue;
                        }
                        break;
                    case 'leaderboard_include':
                        $this->set_leaderboard_include($pvalue);
                        break;
                    case 'widget_module_id':
                        $this->set_widget_module_id($pvalue);
                        break;
                }

            }

            $this->set_selected_module($this->selected_module);
            $this->set_selected_campaign($this->selected_campaign);
            $this->set_selected_campaign_item($this->selected_campaign_item);
            $this->set_date_frame($this->selected_startdate, $this->selected_enddate);

        }
        $this->_set_cache_id();
    }



    static function get_js_code()
    {
        ob_start();
        ?>


        <script language="javascript"
                src="<?php echo mh_cfg('MH_CATALOG_SERVER') . mh_cfg('MH_DIR_WS_CATALOG') . mh_cfg('MH_ROOT_PATH'); ?>common/js/easy-pie/jquery.easy-pie-chart.js"></script>

        <script type="text/javascript">

            var color_delivered = '#a0a0a0';
            var color_open = '#9ac2df';
            var color_click = '#f8933c';
            var color_order = '#abd37f';


            var initPieChartMini = function () {
                var chart_size = 35;
                var chart_lineWidth = 4;

                jQuery('.sb_percentage_mini-delivered').easyPieChart({
                    barColor: color_delivered,
                    size: chart_size,
                    trackColor: 'rgba(214, 176, 252, .2)',
                    scaleColor: false,
                    lineCap: 'round',
                    lineWidth: chart_lineWidth,
                    animate: 500
                });

                jQuery('.sb_percentage_mini-open').easyPieChart({
                    barColor: color_open,
                    size: chart_size,
                    trackColor: 'rgba(154, 194, 223, .2)',
                    scaleColor: false,
                    lineCap: 'round',
                    lineWidth: chart_lineWidth,
                    animate: 500
                });

                jQuery('.sb_percentage_mini-click').easyPieChart({
                    barColor: color_click,
                    size: chart_size,
                    trackColor: 'rgba(248, 147, 60, .2)',
                    scaleColor: false,
                    lineCap: 'round',
                    lineWidth: chart_lineWidth,
                    animate: 500
                });

                jQuery('.sb_percentage_mini-order').easyPieChart({
                    barColor: color_order,
                    size: chart_size,
                    trackColor: 'rgba(171, 211, 127, .2)',
                    scaleColor: false,
                    lineCap: 'round',
                    lineWidth: chart_lineWidth,
                    animate: 500
                });


            };

        </script>
        <?php
        $output = ob_get_contents();
        ob_end_clean();


        return $output;
    }


    function generateOutput($ajax = false, $refresh = false)
    {
        $data = $this->generateData($refresh);

        $smarty = new mh_Smarty;
        $smarty->setTemplateDir(MH_DIR_FS_CATALOG . MH_ROOT_PATH . 'common/admin_application_plugins/templates/');
        $smarty->setCompileId('statsbar');

        list($smarty_config_dir) = $smarty->getConfigDir();

// lngrefactor


        if (stream_resolve_include_path($smarty_config_dir . $_SESSION['language'] . '.conf')) {
            $smarty->assign('language', $_SESSION['language']);
        } else {
            $smarty->assign('language', 'english');
        }

        $smarty->assign(array(
                'widget_module_id' => $this->widget_module_id,
                'leaderboard_include' => $this->leaderboard_include,
                'cnt_sent' => $data['cnt_sent'],
                'cnt_delivered' => $data['cnt_delivered'],
                'cnt_opened' => $data['cnt_opened'],
                'cnt_clicked' => $data['cnt_clicked'],
                'cnt_orders' => $data['cnt_orders'],
                'cnt_mobile' => $data['cnt_mobile'],
                'pct_delivered' => $data['pct_delivered'],
                'pct_opened' => $data['pct_opened'],
                'pct_clicked' => $data['pct_clicked'],
                'pct_ordered' => $data['pct_ordered'],
                'pct_mobile' => $data['pct_mobile'],
                'revenue' => $data['revenue'],
                'revenue_email' => $data['revenue_email'],
                'coupon_val' => $data['coupon_val'],
                'beginning_of_time' => $data['beginning_of_time'],
                'hide_timeago' => $this->start_date_db || $this->end_date_db,
                'MH_CATALOG_URL' => MH_CATALOG_SERVER . MH_DIR_WS_CATALOG,
                'MH_ROOT_PATH' => MH_ROOT_PATH
            )
        );

        ob_start();
        ?>


        <style type="text/css">

            <?php if ($this->widget_mode) { ?>
            #statsbar:hover {
                cursor: pointer;
                opacity: 0.8;
            }

            <?php } ?>
        </style>

        <div id="statsbar" style="width: 100%; min-height: 50px;  margin-top: 0px;">
            <div style="position: relative">
                <div class="">
                    <?php
                    $content = $smarty->fetch('dashboard_statsbar_mini.tpl');
                    echo $content;
                    ?>
                </div>
            </div>
        </div>
        <script type="text/javascript">


            jQuery(document).ready(function () {
                initPieChartMini();
            });
        </script>


        <?php
        $output = ob_get_contents();
        ob_end_clean();


        return $output;
    }

    function keys()
    {
        return array();
    }


}
