<?php
/*
  MailBeez Automatic Trigger Email Campaigns
  http://www.mailbeez.com

  Copyright (c) 2010 - 2012 MailBeez

  inspired and in parts based on
  Copyright (c) 2003 osCommerce

  Released under the GNU General Public License

  v2.6
 */

///////////////////////////////////////////////////////////////////////////////
///                                                                          //
///                 MailBeez Core file - do not edit                         //
///                                                                          //
///////////////////////////////////////////////////////////////////////////////

if (!defined('MH_DIR_FS_CATALOG')) {
    if (substr(DIR_FS_CATALOG, -1) != '/') {
        define('MH_DIR_FS_CATALOG', DIR_FS_CATALOG . '/');
    } else {
        define('MH_DIR_FS_CATALOG', DIR_FS_CATALOG);
    }
}

if (!defined('MH_ROOT_PATH')) {
    // default location
    $_MH_ROOT_PATH = 'mailhive/';
    $_mh_search_paths = array('mailhive/', 'ext/mailhive/', 'includes/external/mailhive/');

    foreach ($_mh_search_paths as $_MH_ROOT_PATH_TRY) {
        if (file_exists(MH_DIR_FS_CATALOG . $_MH_ROOT_PATH_TRY . 'cloudbeez/cloudloader_core.php')) {
            $_MH_ROOT_PATH = $_MH_ROOT_PATH_TRY;
            break;
        }
    }

    define('MH_ROOT_PATH', $_MH_ROOT_PATH);
}

require_once(MH_DIR_FS_CATALOG . MH_ROOT_PATH . 'common/functions/compatibility.php');

if (mh_cfg('MAILBEEZ_ANALYTICS_OPEN_RATES_AUTO') == 'True') {
    require_once(MH_DIR_FS_CATALOG . MH_ROOT_PATH . 'common/classes/clicktracker.php');
    $mailbeez_clicktracker = new mb_clicktracker();
    $mailbeez_clicktracker->process();
}

if (mh_get('mid', null, 'hex_string')) {
    require_once(MH_DIR_FS_CATALOG . MH_ROOT_PATH . 'common/functions/compatibility.php');
    require_once(MH_DIR_FS_CATALOG . MH_ROOT_PATH . 'common/classes/clicktracker.php');
    $mailbeez_clicktracker = new mb_clicktracker();
    $mailbeez_clicktracker->record_click(mh_get('mid', null, 'hex_string'), $_SERVER['REQUEST_URI']);
}

if (mh_session('mailbeez_message_id') && ((mh_get('main_page') == FILENAME_CHECKOUT_SUCCESS) || preg_match('/' . FILENAME_CHECKOUT_SUCCESS . '/', $_SERVER['PHP_SELF']))) {
    require_once(MH_DIR_FS_CATALOG . MH_ROOT_PATH . 'common/functions/compatibility.php');
    require_once(MH_DIR_FS_CATALOG . MH_ROOT_PATH . 'common/classes/clicktracker.php');
    $mailbeez_clicktracker = new mb_clicktracker();
    $mailbeez_clicktracker->record_order();
}

if (mh_cfg('MAILBEEZ_CONFIG_SITEBEEZ_STATUS') == 'True') {
    // todo
    // products view tracker call
    /*
    require_once(MH_DIR_FS_CATALOG . MH_ROOT_PATH . 'common/functions/compatibility.php');
    require_once(MH_DIR_FS_CATALOG . MH_ROOT_PATH . 'common/classes/clicktracker.php');
    $mailbeez_clicktracker = new mb_clicktracker();
    $mailbeez_clicktracker->record_product_view($products_id, $visitor_token, $customers_id);
    */
}