<?php

/*
  MailBeez Automatic Trigger Email Campaigns
  http://www.mailbeez.com

  Copyright (c) 2010 - 2014 MailBeez

  inspired and in parts based on
  Copyright (c) 2003 osCommerce

  Released under the GNU General Public License
 */

// make path work from admin
require_once(MH_DIR_FS_CATALOG . MH_ROOT_PATH . 'common/classes/mailbeez.php');

// could be in language-file
// just easier to define it in the mailbee
mh_define('MAILBEEZ_BIRTHDAY_TEXT_TITLE', 'Birthday Greetings');
mh_define('MAILBEEZ_BIRTHDAY_TEXT_DESCRIPTION', 'Be nice and remember the Birthday of your customers - this MailBeez Module sends birthday greetings.');

class birthday extends mailbeez
{

    // class constructor
    function __construct()
    {
        // call constructor
        parent::__construct();

        // set some stuff:
        $this->code = 'birthday';
        $this->module = 'birthday';
        $this->version = '3.1'; // float value
        $this->required_mb_version = 3.0; // required mailbeez version
        $this->iteration = date('Y'); // year
        $this->title = mh_lng('MAILBEEZ_BIRTHDAY_TEXT_TITLE');
        $this->description = mh_lng('MAILBEEZ_BIRTHDAY_TEXT_DESCRIPTION');
        $this->description_image = 'birthday.png';
        $this->icon = '../../common/images/calendar_icon.png';
        $this->svg_icon = '<svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="size-6"><path stroke-linecap="round" stroke-linejoin="round" d="M12 8.25v-1.5m0 1.5c-1.355 0-2.697.056-4.024.166C6.845 8.51 6 9.473 6 10.608v2.513m6-4.871c1.355 0 2.697.056 4.024.166C17.155 8.51 18 9.473 18 10.608v2.513M15 8.25v-1.5m-6 1.5v-1.5m12 9.75-1.5.75a3.354 3.354 0 0 1-3 0 3.354 3.354 0 0 0-3 0 3.354 3.354 0 0 1-3 0 3.354 3.354 0 0 0-3 0 3.354 3.354 0 0 1-3 0L3 16.5m15-3.379a48.474 48.474 0 0 0-6-.371c-2.032 0-4.034.126-6 .371m12 0c.39.049.777.102 1.163.16 1.07.16 1.837 1.094 1.837 2.175v5.169c0 .621-.504 1.125-1.125 1.125H4.125A1.125 1.125 0 0 1 3 20.625v-5.17c0-1.08.768-2.014 1.837-2.174A47.78 47.78 0 0 1 6 13.12M12.265 3.11a.375.375 0 1 1-.53 0L12 2.845l.265.265Zm-3 0a.375.375 0 1 1-.53 0L9 2.845l.265.265Zm6 0a.375.375 0 1 1-.53 0L15 2.845l.265.265Z" /></svg>';
        $this->sort_order = mh_cfg('MAILBEEZ_BIRTHDAY_SORT_ORDER');
        // Metadata for Beez UI
        $this->group = self::GROUP_LIFECYCLE;
        $this->enabled = mh_cfg('MAILBEEZ_BIRTHDAY_STATUS') == 'True';
        $this->googleanalytics_enabled = ((mh_cfg('MAILBEEZ_BIRTHDAY_GA') == 'True') ? 'True' : 'False');
        $this->googleanalytics_rewrite_mode = ((mh_cfg('MAILBEEZ_BIRTHDAY_GA_MODE') == 'default') ? mh_cfg('MAILBEEZ_MAILHIVE_GA_REWRITE_MODE') : mh_cfg('MAILBEEZ_BIRTHDAY_GA_MODE'));
        $this->sender = mh_cfg('MAILBEEZ_BIRTHDAY_SENDER');
        $this->sender_name = mh_cfg('MAILBEEZ_BIRTHDAY_SENDER_NAME');
        $this->status_key = 'MAILBEEZ_BIRTHDAY_STATUS';

        $this->mailchimp_ready = true;

        $this->documentation_key = $this->module; // leave empty if no documentation available
        // $this->documentation_root = 'http:://yoursite.com/' // modify documentation root if necessary

        $this->htmlBodyTemplateResource = 'body_html.tpl'; // located in folder of this module
        $this->txtBodyTemplateResource = 'body_txt.tpl'; // located in folder of this module
        $this->subjectTemplateResource = 'subject.tpl'; // located in folder of this module

        $this->audience = array();
        $this->additionalFields = array('customers_id' => mh_cfg('MAILBEEZ_PREVIEW_CUSTOMERS_ID'), 'date_of_birth' => '31.01.'); // list of additional fields to show in listing with testvalues
        // list of additional fields to show in listing with testvalues used for Test-Mail



        $this->check_update();
        $this->check_cloud();
        $this->_blueprint();

    }

    function birthday()
    {
        self::__construct();
    }

// class methods
    function getAudience()
    {

        $query_raw = "select c.customers_firstname, c.customers_lastname, c.customers_id, c.customers_email_address, c.customers_dob, date_format(c.customers_dob, '%d.%m.') as date_of_birth
            from " . TABLE_CUSTOMERS . " c
            where c.customers_dob != '0000-00-00 00:00:00' and c.customers_dob != '1000-01-01 00:00:00' and CAST(c.customers_dob AS char) != '' and
                concat(year(now()), '', date_format(c.customers_dob,'%m%d')) <= date_format( DATE_ADD(now(), INTERVAL " . mh_cfg('MAILBEEZ_BIRTHDAY_BEFORE_DAYS') . " DAY),'%Y%m%d') and
                concat(year(now()), '', date_format(c.customers_dob,'%m%d')) > date_format(SUBDATE(now(), INTERVAL " . mh_cfg('MAILBEEZ_BIRTHDAY_PASSED_DAYS_SKIP') . " DAY), '%Y%m%d')";

        $query = mh_module_query($this, $query_raw);

        // for early check
        $mb_chk = new mailbeez_mailer($this);

        while ($item = mh_db_fetch_array($query)) {
            // mandatory fields:
            // - firstname
            // - lastname
            // - email_address
            // - customers-id -> block
            // other keys are replaced while sending: {$<key>}
            // early check to avoid processing when email was already sent
            $chk_result = $mb_chk->early_check($this->module, $this->iteration, $item['customers_id']);
            if ($chk_result != false) {
                // this iteration for this customer was already sent -> skip
                continue;
            }

            $this->audience[$item['customers_id']] = array('firstname' => $item['customers_firstname'],
                'lastname' => $item['customers_lastname'],
                'email_address' => $item['customers_email_address'],
                'customers_id' => $item['customers_id'],
                'date_of_birth' => $item['date_of_birth']
            );
        }
        return $this->audience;
    }

    // installation methods

    function keys()
    {
        return array('MAILBEEZ_BIRTHDAY_STATUS', 'MAILBEEZ_BIRTHDAY_BEFORE_DAYS', 'MAILBEEZ_BIRTHDAY_PASSED_DAYS_SKIP', 'MAILBEEZ_BIRTHDAY_SENDER', 'MAILBEEZ_BIRTHDAY_SENDER_NAME', 'MAILBEEZ_BIRTHDAY_SORT_ORDER', 'MAILBEEZ_BIRTHDAY_GA', 'MAILBEEZ_BIRTHDAY_GA_MODE');
    }

    function install()
    {
        mh_insert_config_value(array('configuration_title' => 'Send birthday reminder',
            'configuration_key' => 'MAILBEEZ_BIRTHDAY_STATUS',
            'configuration_value' => 'False',
            'configuration_description' => 'Do you want to send birthday emails?',
            'set_function' => 'mh_cfg_select_option(array(\'True\', \'False\'), '
        ));

        mh_insert_config_value(array('configuration_title' => 'Set days before',
            'configuration_key' => 'MAILBEEZ_BIRTHDAY_BEFORE_DAYS',
            'configuration_value' => '1',
            'configuration_description' => 'number of days before birthday sending the emails',
            'set_function' => ''
        ));

        mh_insert_config_value(array('configuration_title' => 'Set days to skip after',
            'configuration_key' => 'MAILBEEZ_BIRTHDAY_PASSED_DAYS_SKIP',
            'configuration_value' => '2',
            'configuration_description' => 'number of days after which do skip the birthday email (in case cron job failed)',
            'set_function' => ''
        ));

        mh_insert_config_value(array('configuration_title' => 'sender email',
            'configuration_key' => 'MAILBEEZ_BIRTHDAY_SENDER',
            'configuration_value' => mh_cfg('STORE_OWNER_EMAIL_ADDRESS'),
            'configuration_description' => 'sender email',
            'set_function' => ''
        ));

        mh_insert_config_value(array('configuration_title' => 'sender name',
            'configuration_key' => 'MAILBEEZ_BIRTHDAY_SENDER_NAME',
            'configuration_value' => mh_cfg('STORE_NAME'),
            'configuration_description' => 'sender email',
            'set_function' => ''
        ));


        mh_insert_config_value(array('configuration_title' => 'Sort order of display.',
            'configuration_key' => 'MAILBEEZ_BIRTHDAY_SORT_ORDER',
            'configuration_value' => '20',
            'configuration_description' => 'Sort order of display. Lowest is displayed first.',
            'set_function' => ''
        ));


        mh_insert_config_value(array('configuration_title' => 'Google Analytics Integration',
            'configuration_key' => 'MAILBEEZ_BIRTHDAY_GA',
            'configuration_value' => 'True',
            'configuration_description' => 'Do you want to enable URL rewrite to track this MailBeez Module in Google Analytics?',
            'set_function' => 'mh_cfg_select_option(array(\'True\', \'False\'), '
        ));

        mh_insert_config_value(array('configuration_title' => 'Google Analytics Integration URL rewrite mode',
            'configuration_key' => 'MAILBEEZ_BIRTHDAY_GA_MODE',
            'configuration_value' => 'default',
            'configuration_description' => 'Google Analytics URL Rewrite Mode',
            'set_function' => 'mh_cfg_select_option(array(\'default\', \'all\', \'shop\'), '
        ));

        $this->update(0);
    }

    function update($installed_version = null)
    {
        if (mh_cfg('MAILBEEZ_BIRTHDAY_BEFORE_DAYS') == 1) {
            mh_insert_config_value(array('configuration_title' => 'Set days before',
                'configuration_key' => 'MAILBEEZ_BIRTHDAY_BEFORE_DAYS',
                'configuration_value' => '0',
                'configuration_description' => 'number of days before birthday sending the emails',
                'set_function' => ''
            ), true);
        }

        parent::update($this->module);
    }


}

