<?php
/*
  MailBeez Automatic Trigger Email Campaigns
  http://www.mailbeez.com

  Copyright (c) 2010, 2011 MailBeez

  inspired and in parts based on
  Copyright (c) 2003 osCommerce

  Released under the GNU General Public License

  v2.6
 */

///////////////////////////////////////////////////////////////////////////////
///																		     //
///                 MailBeez Core file - do not edit                         //
///                                                                          //
///////////////////////////////////////////////////////////////////////////////


require_once(MH_DIR_FS_CATALOG . MH_ROOT_PATH . 'common/classes/mailbeez.php');

class service_handler_analytics extends mailbeez
{
    // class constructor
    function __construct()
    {
        // call constructor
        parent::__construct();

        // set some stuff:
        $this->code = 'service_handler_analytics';
        $this->module = 'service_handler_analytics';
        $this->version = '2.0'; // float value
        $this->required_mb_version = 2.6; // required mailbeez version
        $this->iteration = 1;
        $this->title = mh_lng('MAILBEEZ_ANALYTICS_HNDL_TEXT_TITLE');
        $this->description = mh_lng('MAILBEEZ_ANALYTICS_HNDL_TEXT_DESCRIPTION');
        $this->sort_order = 15000;
        $this->enabled = true;
        $this->documentation_key = $this->module; // leave empty if no documentation available
        $this->admin_action_plugins = 'process.php';
        $this->common_admin_action_plugins = '';
        $this->do_process = (mh_cfg('MAILBEEZ_ANALYTICS_DO_RUN') == 'True'); // a processable module
        $this->do_run = (mh_cfg('MAILBEEZ_ANALYTICS_DO_RUN') == 'True');
        $this->is_editable = false; // allow editor
        $this->is_configurable = false;
        $this->removable = false;
        $this->hidden = ((mh_cfg('MAILBEEZ_CONFIG_ADMIN_HIDE_HELPERS') == 'True' || mh_cfg('MAILBEEZ_ANALYTICS_OPEN_RATES_AUTO') == 'True') ? true : false);

        $this->allow_preview = false;
        $this->allow_timing = false;
        $this->allow_reporting = false;
        $this->allow_group_filter_check = false;


    }

    function service_handler_analytics()
    {
        self::__construct();
    }

// class methods
    function getAudience()
    {
        return false;
    }

    function check()
    {
        return true;
    }

    function remove()
    {
        return false;
    }

    function install()
    {
        return false;
    }

    function process($audience = '', $mode = '')
    {
        $this->external_tracking_process();
        echo "done";
        return -1;
    }

    function external_tracking_process()
    {
        echo '<h2>' . mh_lng('MAILBEEZ_ANALYTICS_HNDL_TEXT_TITLE') . '</h2>';

        $logs = $this->_process_tracking();

        echo "done";
    }

    function external_tracking_process_raw() {
        $logs = $this->_process_tracking();
        header('Content-type: application/json');
        echo json_encode($logs);
        exit();
    }

    function _process_tracking() {
        require_once(MH_DIR_FS_CATALOG . MH_ROOT_PATH . 'common/classes/clicktracker.php');
        $logs = array();
        $mailbeez_clicktracker = new mb_clicktracker();
        $logs['open'] = $mailbeez_clicktracker->import_open_log_file();
        $logs['click'] = $mailbeez_clicktracker->import_click_log_file();
        $logs['order'] = $mailbeez_clicktracker->import_order_log_file();
        $mailbeez_clicktracker->consolidate_coupon_data();
        return $logs;
    }

}
