<?php

// make path work from admin
require_once(MH_DIR_FS_CATALOG . MH_ROOT_PATH . 'common/classes/mailbeez.php');
require_once(MH_DIR_CONFIG . 'config_email_engine_n2g/classes/newsletter2go_v2.class.php');


class service_newsletter2go_api_v2 extends mailbeez
{
    // class constructor
    function __construct()
    {
        // call constructor
        parent::__construct();

        // set some stuff:
        $this->code = 'service_newsletter2go_api_v2';
        $this->module = 'service_newsletter2go_api_v2';
        $this->version = '1.6'; // float value
        $this->required_mb_version = 2.8; // required mailbeez version
        $this->iteration = 1;
        $this->title = mh_lng('MAILBEEZ_N2GO_API_V2_TITLE');
        $this->description = mh_lng('MAILBEEZ_N2GO_API_V2_DESCRIPTION');
        $this->sort_order = -1;
        $this->enabled = preg_match('/Newsletter2Go/', mh_cfg('MAILBEEZ_CONFIG_EMAIL_ENGINE'));
        $this->documentation_root = 'https://www.mailbeez.com/documentation/configbeez/';
        $this->documentation_key = 'config_email_engine'; // leave empty if no documentation available
//        $this->admin_action_plugins = 'process.php';

        $this->common_admin_action_plugins = '';
        $this->do_process = true; // a processable module
        $this->is_editable = false; // allow editor
        $this->is_configurable = false;
        $this->hidden = !preg_match('/Newsletter2Go/', mh_cfg('MAILBEEZ_CONFIG_EMAIL_ENGINE')) || (mh_cfg('MAILBEEZ_CONFIG_EMAIL_ENGINE_N2G_API_VERSION') == 'v1');
        $this->hidden = true; // always hide
        $this->do_run = false; // run only when called explicit
        $this->removable = false;
        $this->allow_preview = false;
        $this->allow_reporting = false;
        $this->allow_timing = false;
        $this->allow_group_filter_check = false;

    }


// class methods
    function getAudience()
    {
        return false;
    }

    function process($audience = '', $mode = '')
    {
//        $cnt = $this->external_syncBounces('False');
//        mh_exit();
        return -1;
    }

    function external_oauth()
    {
        error_reporting(E_ALL & ~E_WARNING & ~E_NOTICE & ~E_STRICT & ~E_DEPRECATED);
        ini_set('display_errors', 0);


        // set authkey, accesstoken,
        $valid = NL2GO\Api::setOauthData();

        if ($valid) {
            // set email engine
            mh_update_config_value(array(
                'configuration_key' => 'MAILBEEZ_CONFIG_EMAIL_ENGINE',
                'configuration_value' => 'Newsletter2Go',
            ));
            // set api version
            mh_update_config_value(array(
                'configuration_key' => 'MAILBEEZ_CONFIG_EMAIL_ENGINE_N2G_API_VERSION',
                'configuration_value' => 'v2',
            ));

            $result = array(
                "status" => '200',
                "code" => '200',
                "errorMessage" => ''
            );

        } else {
            $result = array(
                "status" => '501',
                "code" => '501',
                "errorMessage" => 'invalid call: Request: ' . print_r($_POST, true)
            );
        }

        NL2GO\Api::sendJson($result);

        mh_exit();
    }

    function processApiCall($apiCall, $params = null)
    {
        error_reporting(E_ALL & ~E_WARNING & ~E_NOTICE & ~E_STRICT & ~E_DEPRECATED);
        ini_set('display_errors', 0);

        // run synchronization tasks
        // work in background
        mailHive::clear_process_lock();
        // return print_r($_POST, true);


        require_once(MH_DIR_CONFIG . 'config_email_engine_n2g/classes/api_newsletter2go_v2.class.php');
        $api = new api_newsletter2go_v2();


        if ($api->checkApiKey($_POST['apiKey'])) {
//        if ($api->checkApiKey($_POST['auth_key'])) {
            $result = $api->$apiCall($params);
        } else {
            $result = array(
                "success" => '1',
                "status" => '401',
                "code" => '401',
                "errorMessage" => 'unauthorized'
            );
        }
        NL2GO\Api::sendJson($result);
        mh_exit();
    }


    function external_testConnection()
    {
        $this->processApiCall('testConnection');
        mh_exit();
    }

    function external_getShopName()
    {
        $this->processApiCall('getShopName');
        mh_exit();
    }

    function external_getShopPrefix()
    {
        $this->processApiCall('getShopPrefix');
        mh_exit();
    }

    function external_getPluginVersion()
    {
        $this->processApiCall('getPluginVersion');
        mh_exit();
    }
    function external_getLanguages()
    {
        $this->processApiCall('getLanguages');
        mh_exit();
    }

    function external_getCustomerGroups()
    {
        $this->processApiCall('getCustomerGroups');
        mh_exit();
    }

    function external_getCustomers()
    {
        $params = array();
        $params['hours'] = $_POST['hours'];
        $params['newsletterSubscribersOnly'] = $_POST['newsletterSubscribersOnly'];
        $this->processApiCall('getCustomers', $params);
        mh_exit();
    }

    function external_getProductInfo()
    {
        $params = array();
        $params['identifier'] = $_POST['identifier'];
        $params['language'] = $_POST['language'];
        $this->processApiCall('getProductInfo', $params);
        mh_exit();
    }

    function external_setBounce()
    {
        $params = array();
        $params['email'] = $_POST['email'];
        $this->processApiCall('setBounce', $params);
        mh_exit();
    }

    function external_setUnsubscribe()
    {
        $params = array();
        $params['email'] = $_POST['email'];
        $this->processApiCall('setUnsubscribe', $params);
        mh_exit();
    }

    function external_syncBounces($external_call = 'True')
    {
        return false;
    }


    function get_do_run()
    {
        return (preg_match('/Newsletter2Go/', mh_cfg('MAILBEEZ_CONFIG_EMAIL_ENGINE')));
    }

    function check()
    {
        return true;
    }
    /*

        function remove()
        {
            return false;
        }

        function install()
        {

        }

        */

}
