<?php
/*
  MailBeez Automatic Trigger Email Campaigns
  http://www.mailbeez.com

  Copyright (c) 2010 MailBeez
	
	inspired and in parts based on
  Copyright (c) 2003 osCommerce

  Released under the GNU General Public License
*/

// make path work from admin
require_once(MH_DIR_FS_CATALOG . MH_ROOT_PATH . 'common/classes/mailbeez.php');

if (mh_cfg('MAILBEEZ_SHOPRATING_STATUS') && !class_exists('Shopvoting')) {
    if (file_exists(MH_DIR_CONFIG . 'config_shopvoting/classes/Shopvoting.php')) {
        require_once(MH_DIR_CONFIG . 'config_shopvoting/classes/Shopvoting.php');
    } else {
        echo "Install Shopvoting Module - class Shopvoting.php not found";
        return false;
    }
}

mh_define('FILENAME_MAILBEEZ_WEB4DESIGN_DE_REVIEW_WRITE', 'shop-reviews-write.php');

class shoprating extends mailbeez
{
    // class constructor
    function __construct()
    {
        // call constructor
        parent::__construct();

        // set some stuff:
        $this->code = 'shoprating';
        $this->module = 'shoprating'; // same as folder name
        $this->version = '3.11'; // float value
        $this->required_mb_version = 2.9; // required mailbeez version
        $this->iteration = 1;
        $this->title = mh_lng('MAILBEEZ_SHOPRATING_TEXT_TITLE');
        $this->description = mh_lng('MAILBEEZ_SHOPRATING_TEXT_DESCRIPTION');
        $this->description_image = 'icon_64.png';
        $this->icon = 'icon.png';
        $this->sort_order = mh_cfg('MAILBEEZ_SHOPRATING_SORT_ORDER');
        // Metadata for Beez UI
        $this->group = self::GROUP_REVIEW_FEEDBACK;
        $this->enabled = ((mh_cfg('MAILBEEZ_SHOPRATING_STATUS') == 'True') ? true : false);

        $this->sender = mh_cfg('MAILBEEZ_SHOPRATING_SENDER');
        $this->sender_name = mh_cfg('MAILBEEZ_SHOPRATING_SENDER_NAME');
        $this->status_key = 'MAILBEEZ_SHOPRATING_STATUS';

        $this->hidden = !((mh_cfg('MAILBEEZ_SHOPVOTING_STATUS') == 'True') ? true : false);

        if (mh_cfg('MAILBEEZ_SHOPVOTING_STATUS') != 'True') {
            $this->enabled = false;
        }



        $this->documentation_key = 'shoprating'; // leave empty if no documentation available
        // $this->documentation_root = 'http:://yoursite.com/' // modify documentation root if necessary

        $this->htmlBodyTemplateResource = 'body_html.tpl'; // located in folder of this module
        $this->txtBodyTemplateResource = 'body_txt.tpl'; // located in folder of this module
        $this->subjectTemplateResource = 'subject.tpl'; // located in folder of this module

        $this->audience = array();
        $this->additionalFields = array('customers_id' => mh_cfg('MAILBEEZ_PREVIEW_CUSTOMERS_ID'), 'customers_email_address' => 'customer@mail.com', 'order_id' => mh_cfg('MAILBEEZ_PREVIEW_ORDERS_ID'), 'order_date' => '12.12.2000', 'status_date' => '31.12.2000', 'votelink' => mh_href_link(FILENAME_MAILBEEZ_WEB4DESIGN_DE_REVIEW_WRITE, '', 'NONSSL', false));
        // list of additional fields to show in listing with testvalues used for Test-Mail

        $this->check_cloud();
    }

    function shoprating()
    {
        self::__construct();
    }

// class methods

    function getAudience()
    {
        $status = mh_cfg('MAILBEEZ_SHOPRATING_ORDER_STATUS_ID');

        $voting = new Shopvoting();

        $language = $_SESSION['language'];

        if (!file_exists($voting->main_path . 'lang/' . $language . '/shopreview.php')) {
            $language = 'english';
        }

        require_once($voting->main_path . 'lang/' . $language . '/shopreview.php');

        // early check to avoid processing when email was already sent
        $mb_chk = new mailbeez_mailer($this);

        $date_skip = $this->dbdate((int)mh_cfg('MAILBEEZ_SHOPRATING_PASSED_DAYS_SKIP'));
        $date_passed = $this->dbdate((int)mh_cfg('MAILBEEZ_SHOPRATING_PASSED_DAYS'));

        $query_raw = "select c.customers_firstname, c.customers_lastname, o.orders_id, o.customers_name,
														o.customers_id, o.customers_email_address, o.date_purchased, s.date_added as status_date
											      from " . TABLE_ORDERS . " o 
											        left join " . TABLE_CUSTOMERS . " c
											          on (o.customers_id = c.customers_id)
											        left join " . TABLE_ORDERS_STATUS_HISTORY . " s
											          on (o.orders_id = s.orders_id)
											      where o.orders_status = s.orders_status_id 
											        and s.orders_status_id = '" . (int)$status . "' 
											        and s.date_added <= '" . $date_passed . "' 
											        and s.date_added > '" . $date_skip . "' 
											      order by o.orders_id DESC";

        $query = mh_db_query($query_raw);
        while ($item = mh_db_fetch_array($query)) {
            // mandatory fields:
            // - firstname
            // - lastname
            // - email_address
            // - customers-id -> block

            // other keys are replaced while sending: $<key>

            // early check to avoid processing when email was already sent
            $customer_data = array('firstname' => $item['customers_firstname'],
                'lastname' => $item['customers_lastname'],
                'email_address' => $item['customers_email_address'],
                'customers_id' => $item['customers_id'],
                'order_id' => $item['orders_id'],
                'order_date' => mh_date_short($item['date_purchased']),
                'status_date' => mh_date_short($item['status_date']),
                'votelink' => mh_href_link(FILENAME_MAILBEEZ_WEB4DESIGN_DE_REVIEW_WRITE, '', 'NONSSL', false)
            );

            $chk_result = $mb_chk->check($this->module, $this->iteration, $item['customers_id'], $item['orders_id'], $customer_data);
            if ($chk_result != false) {
                // this iteration was already sent -> skip
                continue;
            }


            $this->audience[$item['customers_id']] = $customer_data;

        }
        return $this->audience;
    }


    // installation methods

    function keys()
    {
        return array('MAILBEEZ_SHOPRATING_STATUS', 'MAILBEEZ_SHOPRATING_ORDER_STATUS_ID', 'MAILBEEZ_SHOPRATING_PASSED_DAYS', 'MAILBEEZ_SHOPRATING_PASSED_DAYS_SKIP', 'MAILBEEZ_SHOPRATING_SENDER', 'MAILBEEZ_SHOPRATING_SENDER_NAME', 'MAILBEEZ_SHOPRATING_SORT_ORDER');
    }

    function install()
    {
        mh_insert_config_value(array('configuration_title' => 'Sende automatische Shopbewertungs-Email',
            'configuration_key' => 'MAILBEEZ_SHOPRATING_STATUS',
            'configuration_value' => 'False',
            'configuration_description' => 'M&ouml;chtest du deine Kunden automatisch zur Bewertung deines Shops im Shopbewertungs-Modul auffordern?',
            'set_function' => 'mh_cfg_select_option(array(\'True\', \'False\'), '
        ));

        mh_insert_config_value(array('configuration_title' => 'Bestell-Status',
            'configuration_key' => 'MAILBEEZ_SHOPRATING_ORDER_STATUS_ID',
            'configuration_value' => '3',
            'configuration_description' => 'Kunden mit Bestellung mit diesem Status werden aufgefordert',
            'set_function' => 'mh_cfg_pull_down_order_statuses(',
            'use_function' => 'mh_get_order_status_name'
        ));


        mh_insert_config_value(array('configuration_title' => 'Wie lange nach der Bestellung auffordern?',
            'configuration_key' => 'MAILBEEZ_SHOPRATING_PASSED_DAYS',
            'configuration_value' => '5',
            'configuration_description' => 'Bitte angeben, nach wievielen Tagen (Datum der Status-&Auml;nderung) der Kunde die Aufforderung erhalten soll',
            'set_function' => ''
        ));

        mh_insert_config_value(array('configuration_title' => 'Nach wievielen Tagen die Bestellung nicht mehr ber&uuml;cksichtigen',
            'configuration_key' => 'MAILBEEZ_SHOPRATING_PASSED_DAYS_SKIP',
            'configuration_value' => '10',
            'configuration_description' => 'Anzahl der Tage nach Status-&Auml;nderung der Bestellung. Dient zur Begrenzung der Anzahl Bestellungen die gepr&uuml;ft werden.',
            'set_function' => ''
        ));

        mh_insert_config_value(array('configuration_title' => 'Absender email',
            'configuration_key' => 'MAILBEEZ_SHOPRATING_SENDER',
            'configuration_value' => mh_cfg('STORE_OWNER_EMAIL_ADDRESS'),
            'configuration_description' => 'Absender email',
            'set_function' => ''
        ));

        mh_insert_config_value(array('configuration_title' => 'Absender Name',
            'configuration_key' => 'MAILBEEZ_SHOPRATING_SENDER_NAME',
            'configuration_value' => mh_cfg('STORE_NAME'),
            'configuration_description' => 'Absender Name',
            'set_function' => ''
        ));


        mh_insert_config_value(array('configuration_title' => 'Sortier-Reihenfolge',
            'configuration_key' => 'MAILBEEZ_SHOPRATING_SORT_ORDER',
            'configuration_value' => '10',
            'configuration_description' => 'Sortier-Reihenfolge der Module',
            'set_function' => ''
        ));
    }
}