// appui/assets/js/alpine.js
import Alpine from 'alpinejs'
import sort from '@alpinejs/sort'
import collapse from '@alpinejs/collapse'

import TimeAgo from '@marcreichel/alpine-timeago';
import { de, enUS } from 'date-fns/locale'

Alpine.plugin(collapse)
Alpine.plugin(sort)
// locale from PHP
let localeCode = window.APP_LOCALE || 'en'
let locale = enUS

switch (localeCode) {
    case 'de':
        locale = de
        break
    case 'en':
        locale = enUS
        break
    default:
        locale = enUS
        break
}

Alpine.plugin(TimeAgo.configure({
    locale: locale,
}))

window.Alpine = Alpine
Alpine.start()