<?php
// components/Assistant/State.php
namespace Components\Assistant;

class State
{
    private static function key(?string $key): string
    {
        return ($key !== null && $key !== '') ? $key : 'assistant';
    }

    public static function get(?string $key = null): array
    {
        $k = self::key($key);
        return \mh_session($k, ['answers' => [], 'current' => null, 'stack' => [], 'item_index' => []]);
    }

    public static function put(array $state, ?string $key = null): void
    {
        $k = self::key($key);
        $_SESSION[$k] = $state;
    }

    public static function clear(?string $key = null): void
    {
        $k = self::key($key);
        unset($_SESSION[$k]);
    }
}
