<?php
// components/Assistant/views/review_view.php
use Components\Assistant\{Flow, State, FlowUtils};

[$flowId, $yaml] = FlowUtils::resolveFlowAndYaml();
$stateKey = FlowUtils::stateKeyFor($flowId);
$state = State::get($stateKey);
$answers = $state['answers'] ?? [];
$flow = new Flow($yaml);
$map = $flow->mapItemToStep();

function edit_step_for_item(string $itemId, array $map): ?string { return $map[$itemId] ?? null; }
?>
<div class="space-y-4">
  <p class="text-gray-600 dark:text-gray-300">Please confirm your details. You can edit any section.</p>

  <div class="space-y-3">
    <?php foreach ($answers as $k => $v): $stepId = edit_step_for_item($k, $map); ?>
      <div class="rounded-md border border-gray-200 dark:border-white/10 p-3">
        <div class="flex items-center justify-between gap-4">
          <div>
            <div class="text-xs uppercase tracking-wide text-gray-400"><?= \Components\Base::h($k) ?></div>
            <div class="text-sm font-medium">
              <?php if (is_array($v)): ?>
                <?= \Components\Base::h(implode(', ', $v)) ?>
              <?php else: ?>
                <?= \Components\Base::h((string)$v) ?>
              <?php endif; ?>
            </div>
          </div>
          <?php if ($stepId): ?>
          <a href="#" hx-get="<?= \Components\Router::url('assistant_step', ['id' => $stepId, 'partial' => 1, 'flow' => $flowId, 'module' => \Components\Assistant\FlowUtils::req('module')]); ?>" hx-target="#assistant-step" hx-swap="innerHTML" class="text-brand-600 hover:underline">Edit</a>
          <?php endif; ?>
        </div>
      </div>
    <?php endforeach; ?>
  </div>

  <div class="flex justify-end">
    <button class="inline-flex items-center gap-2 rounded-md bg-brand px-4 py-2 text-white hover:bg-brand-700" hx-post="<?= \Components\Router::url('assistant_finish', ['partial' => 1, 'flow' => $flowId, 'module' => \Components\Assistant\FlowUtils::req('module')]); ?>" hx-target="#assistant-step" hx-swap="innerHTML">Finish</button>
  </div>
</div>
