<?php
namespace Components\Data\Contracts;

/**
 * Provider for available Data Sources used by the Datasources page.
 *
 * Expected shape for each datasource entry:
 * - key: string (stable identifier)
 * - title: string (can include combined languages for now)
 * - body_html: string (small HTML snippet for the card body)
 * - icon_svg?: string (inline SVG markup)
 */
interface DatasourceProvider
{
    /**
     * Return the list of available data sources.
     * @return array<int, array<string, mixed>>
     */
    public function datasources(): array;
}
