<?php
namespace Components\Data\Contracts;

/**
 * Contract for providing current plan/subscription information
 * Return shape (associative array):
 * [
 *   'tier_id'        => string,                 // e.g. 'free'|'startup'|'business'|'enterprise'
 *   'tier_label'     => string,                 // human readable label
 *   'customer_count' => int,                    // current customers
 *   'tier_max'       => int,                    // max customers for current tier
 *   'valid_until_ts' => int|null,               // unix timestamp when plan is valid until (or null)
 * ]
 */
interface PlanProvider
{
    /**
     * Get plan info for current context (user/shop).
     * @return array
     */
    public function current(): array;
}
