<?php
namespace Components\Data\Live;

use Components\Data\Contracts\AnalyticsProvider;

class LiveAnalyticsProvider implements AnalyticsProvider
{
    public function getDashboardSummary($refresh = false): array
    {
        // Defaults
        $result = [
            'emailsSent' => 0,
            'monthsAgo' => 0,
            'beginningIso' => '',
            'bouncedPercent' => 0,
            'bouncedCount' => 0,
            'openedPercent' => 0,
            'openedCount' => 0,
            'clickPercent' => 0,
            'clickCount' => 0,
            'orderPercent' => 0,
            'orderCount' => 0,
            'revenue' => '0',
            'voucherSum' => '0',
            'bot' => null,
            'cache_timestamp_out' => null
        ];



        if (file_exists(MH_DIR_FS_CATALOG . MH_ROOT_PATH . 'dashboardbeez/dashboard_statsbar.php')) {
            include_once(MH_DIR_FS_CATALOG . MH_ROOT_PATH . 'dashboardbeez/dashboard_statsbar.php');
        }

        try {
            if (class_exists('\\dashboard_statsbar')) {
                $sb = new \dashboard_statsbar();
                $data = $sb->generateData($refresh);
                $cache_timestamp_out = date('Y-m-d G:i:s', $sb->get_timestamp());

                $emailsSent   = (int)($data['cnt_sent'] ?? 0);
                $openedPercent = (int)round((float)($data['pct_opened'] ?? 0));
                $openedCount   = (int)($data['cnt_opened'] ?? 0);
                $clickPercent  = (int)round((float)($data['pct_clicked'] ?? 0));
                $clickCount    = (int)($data['cnt_clicked'] ?? 0);
                $orderPercent  = (int)round((float)($data['pct_ordered'] ?? 0));
                $orderCount    = (int)($data['cnt_orders'] ?? 0);

                $deliveredPct  = (float)($data['pct_delivered'] ?? 0);
                $cntDelivered  = (int)($data['cnt_delivered'] ?? 0);
                $bouncedPercent = max(0, min(100, (int)round(100 - $deliveredPct)));
                $bouncedCount   = max(0, (int)$emailsSent - $cntDelivered);

                $revenue     = (string)($data['revenue'] ?? '0');
                $voucherSum  = (string)($data['coupon_val'] ?? '0');

                $bot = $data['beginning_of_time'] ?? null;
                $monthsAgo = 0;
                $beginningIso = '';



                if ($bot) {
                    try {
                        $start = new \DateTime($bot);
                        $now   = new \DateTime();
                        $diff  = $start->diff($now);
                        $monthsAgo = (int)($diff->y * 12 + $diff->m);
                        $beginningIso = $start->format(\DateTime::ATOM);
                    } catch (\Throwable $e2) {
                        $monthsAgo = 0;
                        $beginningIso = '';
                    }
                }

                $result = [
                    'emailsSent' => $emailsSent,
                    'monthsAgo' => $monthsAgo,
                    'beginningIso' => $beginningIso,
                    'bouncedPercent' => $bouncedPercent,
                    'bouncedCount' => $bouncedCount,
                    'openedPercent' => $openedPercent,
                    'openedCount' => $openedCount,
                    'clickPercent' => $clickPercent,
                    'clickCount' => $clickCount,
                    'orderPercent' => $orderPercent,
                    'orderCount' => $orderCount,
                    'revenue' => $revenue,
                    'voucherSum' => $voucherSum,
                    'bot' => $bot,
                    'cache_timestamp_out' => $cache_timestamp_out,
                ];
            }
        } catch (\Throwable $e) {

        }
        return $result;
    }
}
