<?php
namespace Components\Data\Live;

use Components\Data\Contracts\PlanProvider;

/**
 * Placeholder live provider.
 * Integrate with the real application (DB/API) and map to the PlanProvider contract.
 */
class LivePlanProvider implements PlanProvider
{
    public function current(): array
    {
        // TODO: Replace with real integration.
        // For now return a conservative default so UI renders predictably.
        $defaultCustomers = 900;
        $tiers = [
            ['id' => 'free',       'label' => 'MailBeez Free',               'max' => 500],
            ['id' => 'startup',    'label' => 'Startup • 2k customers',      'max' => 2000],
            ['id' => 'business',   'label' => 'Business • 10k customers',    'max' => 10000],
            ['id' => 'enterprise', 'label' => 'Enterprise • 100k customers', 'max' => 100000],
        ];
        $tier = $tiers[1]; // startup
        return [
            'tier_id'        => $tier['id'],
            'tier_label'     => $tier['label'],
            'customer_count' => $defaultCustomers,
            'tier_max'       => $tier['max'],
            'valid_until_ts' => time() + 12 * 86400,
        ];
    }
}
