<?php
namespace Components\Data\Mock;

use Components\Common\Request;
use Components\Data\Contracts\PlanProvider;

class MockPlanProvider implements PlanProvider
{
    public function current(): array
    {
        // Keep compatibility with existing demo params
        $customerCount = (int) Request::get('customers', Request::get('customer_count', 900, 'int'), 'int');

        $tiers = [
            ['id' => 'free',       'label' => 'MailBeez Free',               'max' => 500],
            ['id' => 'startup',    'label' => 'Startup • 2k customers',      'max' => 2000],
            ['id' => 'business',   'label' => 'Business • 10k customers',    'max' => 10000],
            ['id' => 'enterprise', 'label' => 'Enterprise • 100k customers', 'max' => 100000],
        ];

        // Determine tier by count (first with max >= count)
        $currentTier = $tiers[count($tiers) - 1];
        foreach ($tiers as $t) {
            if ($customerCount <= $t['max']) { $currentTier = $t; break; }
        }
        $tierMax   = (int) ($currentTier['max'] ?? 1000);
        $tierId    = (string) ($currentTier['id'] ?? 'free');
        $tierLabel = (string) ($currentTier['label'] ?? 'MailBeez Free');

        // Valid-until handling, default in 12 days
        $validStr = trim((string) Request::get('valid_until', '', 'string'));
        $validTs  = $validStr !== '' ? @strtotime($validStr) : (time() + 12 * 86400);
        if ($validTs === false) { $validTs = null; }

        return [
            'tier_id'        => $tierId,
            'tier_label'     => $tierLabel,
            'customer_count' => $customerCount,
            'tier_max'       => $tierMax,
            'valid_until_ts' => $validTs,
        ];
    }
}
