<?php
namespace Components\Data\Mock;

use Components\Data\Contracts\TemplateCouponProvider;

class MockTemplateCouponProvider implements TemplateCouponProvider
{
    public function templates($include_empty = true): array
    {
        return [
            [
                'id' => 1,
                'code' => 'welcome_10',
                'name' => 'Welcome 10% Off',
                'label' => 'Welcome 10% Off (welcome_10)',
                'typeLabel' => '10% Discount',
                'type' => 'P',
                'amount' => 10,
            ],
            [
                'id' => 2,
                'code' => 'birthday_surprise',
                'name' => 'Birthday Surprise',
                'label' => 'Birthday Surprise (birthday_surprise)',
                'typeLabel' => '20% Discount',
                'type' => 'P',
                'amount' => 20,
            ],
            [
                'id' => 3,
                'code' => 'winback_15',
                'name' => 'Win‑Back 15% Off',
                'label' => 'Win‑Back 15% Off (winback_15)',
                'typeLabel' => '15% Discount',
                'type' => 'P',
                'amount' => 15,
            ],
            [
                'id' => 4,
                'code' => 'free_ship_weekend',
                'name' => 'Free Shipping Weekend',
                'label' => 'Free Shipping Weekend (free_ship_weekend)',
                'typeLabel' => 'Free Shipping',
                'type' => 'S',
                'amount' => 0,
            ],
            [
                'id' => 5,
                'code' => '5_euro_off',
                'name' => 'Save 5 Euro',
                'label' => 'Save 5 Euro (5_euro_off)',
                'typeLabel' => '5Euro Discount',
                'type' => 'F',
                'amount' => 0,
            ],
            [
                'id' => 6,
                'code' => 'vip_exclusive',
                'name' => 'VIP Exclusive',
                'label' => 'VIP Exclusive (vip_exclusive)',
                'typeLabel' => '25% Discount',
                'type' => 'P',
                'amount' => 25,
            ],
        ];
    }
}
