<?php
// components/Form/Presentation/DelayDaysPresenter.php

namespace Components\Form\Presentation;

class DelayDaysPresenter implements Presenter
{
    public static function render($value, array $def): string
    {
        $v = '';
        if ($value !== '' && is_numeric($value)) {
            $n = (int)$value;
            $v = $n . ' ' . ($n === 1 ? \mh_lng('UI_DAY','day') : \mh_lng('UI_DAYS','days'));
        }
        if ($v === '') { $v = \mh_lng('UI_EM_DASH','—'); }
        return \Components\Base::h($v);
    }
}
