<?php
// components/Form/Presentation/OrderStatusMultiplePresenter.php

namespace Components\Form\Presentation;

class OrderStatusMultiplePresenter implements Presenter
{
    public static function render($value, array $def): string
    {
        $labels = [];
        if (is_array($value)) {
            $opts = \Components\Form\OrderStatusMultiple::getOptions();
            foreach ($value as $v) {
                $labels[] = $opts[(string)$v] ?? (string)$v;
            }
        } else {
            $s = trim((string)$value);
            if ($s !== '') {
                $ids = array_filter(array_map('trim', explode(',', $s)), 'strlen');
                $opts = \Components\Form\OrderStatusMultiple::getOptions();
                foreach ($ids as $id) { $labels[] = $opts[(string)$id] ?? (string)$id; }
            }
        }
        $text = implode(', ', $labels);
        if ($text === '') { $text = \mh_lng('UI_EM_DASH','—'); }
        return \Components\Base::h($text);
    }
}
