<?php
// components/Form/Presentation/Presenter.php
// Canonical interface for value presenters (PSR-4 autoloadable)

namespace Components\Form\Presentation;

interface Presenter
{
    /**
     * Render a configuration value for display based on its field definition
     * Implementations must return a safe HTML string (escaped where necessary).
     *
     * @param mixed $value
     * @param array $def
     */
    public static function render($value, array $def): string;
}
