<?php
// components/Form/Select.php
namespace Components\Form;

class Select extends BaseField {
    /**
     * @param array $options key=>label pairs
     */
    public static function render(string $name, string $label, array $options = [], $value = '', array $opts = []): string {
        $errors = $opts['errors'] ?? [];
        $help = $opts['help'] ?? '';
        $extra = $opts['input_attrs'] ?? '';
        $hasError = !empty($errors);

        $nameEsc = self::h($name);
        $labelEsc = self::h($label);

        // Build id for label association
        $idBase = preg_replace('/[^a-zA-Z0-9_-]+/', '-', $name);
        $idBase = trim($idBase ?? '', '-');
        if ($idBase === '') { $idBase = 'select'; }
        $id = self::h($idBase);

        $includeEmpty = $opts['include_empty'] ?? true;
        $emptyLabel = $opts['empty_label'] ?? '-- Select --';
        $emptyValue = array_key_exists('empty_value', $opts) ? (string)$opts['empty_value'] : '';

        $optionsHtml = '';
        if ($includeEmpty) {
            $sel = ((string)$emptyValue === (string)$value) ? ' selected' : '';
            $optionsHtml .= '<option value="' . self::h((string)$emptyValue) . '"' . $sel . '>' . self::h((string)$emptyLabel) . '</option>';
        }
        foreach ($options as $val => $text) {
            $sel = ((string)$val === (string)$value) ? ' selected' : '';
            $optionsHtml .= '<option value="' . self::h((string)$val) . '"' . $sel . '>' . self::h((string)$text) . '</option>';
        }

        $helpHtml = self::helpHtml($help);
        $errorHtml = self::errorsHtml($errors);
        $badge = $opts['label_badge_html'] ?? '';

        // Select base class; note appearance-none and extra right padding for chevron
        $base = 'col-start-1 row-start-1 w-full appearance-none rounded-md bg-white py-1.5 pr-8 pl-3 text-base text-gray-900 outline-1 -outline-offset-1 outline-gray-300 focus:outline-2 focus:-outline-offset-2 focus:outline-brand sm:text-sm/6 dark:bg-white/5 dark:text-white dark:outline-white/10 dark:*:bg-gray-800 dark:focus-within:outline-brand';
        $errorCls = $hasError ? ' outline-red-300 focus:outline-red-600 dark:outline-red-500/40 dark:focus:outline-red-500' : '';
        $selectClass = $base . $errorCls;

        return <<<HTML
<div>
<label for="{$id}" class="block text-sm/6 font-medium text-gray-900 dark:text-white">{$labelEsc}{$badge}</label>
<div class="mt-2 grid grid-cols-1">

  <select id="{$id}" name="{$nameEsc}" class="{$selectClass}" {$extra}>
    {$optionsHtml}
  </select>
  <svg viewBox="0 0 16 16" fill="currentColor" data-slot="icon" aria-hidden="true" class="pointer-events-none col-start-1 row-start-1 mr-2 size-5 self-center justify-self-end text-gray-500 sm:size-4 dark:text-gray-400">
    <path d="M4.22 6.22a.75.75 0 0 1 1.06 0L8 8.94l2.72-2.72a.75.75 0 1 1 1.06 1.06l-3.25 3.25a.75.75 0 0 1-1.06 0L4.22 7.28a.75.75 0 0 1 0-1.06Z" clip-rule="evenodd" fill-rule="evenodd" />
  </svg>
</div>
{$helpHtml}
{$errorHtml}
</div>
HTML;
    }
}
