<?php
namespace Components\Ui;

/**
 * EmailPreviewMockups
 *
 * Static helpers to render device mockups for the Email Previewer.
 * All inline HTML is captured via output buffering (ob_start) and returned as a string.
 */
class EmailPreviewMockups
{
    public static function desktop(string $iframeHtml): string
    {
        ob_start(); ?>
        <div class="relative mx-auto border-secondary bg-canvas border-[8px] rounded-t-xl w-[1040px] h-[681px]">
            <div class="rounded-lg overflow-hidden bg-canvas  h-full"><?php echo $iframeHtml; ?></div>
        </div>
        <div class="relative mx-auto bg-secondary  rounded-b-xl rounded-t-sm h-[17px] max-w-[1200px]">
            <div class="absolute left-1/2 top-0 -translate-x-1/2 rounded-b-xl w-[56px] h-[5px] md:w-[96px] md:h-[8px] bg-canvas "></div>
        </div>
        <?php return ob_get_clean();
    }

    public static function tablet(string $iframeHtml): string
    {
        ob_start(); ?>
        <div class="relative mx-auto border-secondary  border-[14px] rounded-[2.5rem] h-[1080px] w-[796px]">
            <div class="rounded-[1.5rem] overflow-hidden w-[768px] h-[1052px] bg-canvas  mx-auto">
                <div class="bg-gray-200 h-24"></div>

                <?php echo $iframeHtml; ?>
            </div>
        </div>
        <?php return ob_get_clean();
    }

    public static function mobile(string $iframeHtml): string
    {
        ob_start(); ?>
        <div class="relative mx-auto border-secondary bg-canvas  border-[14px] rounded-[2.5rem] h-[806px] w-[403px]">
            <div class="rounded-[1.5rem] overflow-hidden w-[375px] h-[778px] bg-canvas  mx-auto">
                <div class="bg-gray-200 h-24"></div>
                <?php echo $iframeHtml; ?>
            </div>
        </div>
        <?php return ob_get_clean();
    }
}
