<?php
// components/index.php
// Convenience loader to enable autoloading and shared helpers

// Enable verbose PHP error output for development
// Note: Safe to include multiple times; settings will simply be re-applied.
@ini_set('display_errors', '1');
@ini_set('display_startup_errors', '1');
error_reporting(E_ALL);

// Define project root constant if not already defined
if (!defined('BEEZUI_ROOT')) {
    die('BEEZUI_ROOT is not defined');
    // This file resides in <root>/components
    define('BEEZUI_ROOT', dirname(__DIR__));
}


require_once BEEZUI_ROOT . '/components/Autoload.php';
// Composer autoload (for Symfony/Yaml and other vendor libs)
$vendorAutoload = BEEZUI_ROOT . '/vendor/autoload.php';
if (is_file($vendorAutoload)) {
    require_once $vendorAutoload;
}
require_once BEEZUI_ROOT . '/components/Router.php';
require_once BEEZUI_ROOT . '/components/routes.php';
require_once BEEZUI_ROOT . '/components/router_helpers.php';

// Load default language constants (english)
$languageFile = BEEZUI_ROOT . '/languages/english.php';
if (is_file($languageFile)) {
//    require_once $languageFile;
}

// Optionally set base URL for absolute URLs
// \Components\Router::setBaseUrl(((isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') ? 'https' : 'http') . '://' . ($_SERVER['HTTP_HOST'] ?? 'localhost'));

if (!function_exists('dd')) {
    function dd($var) {
            echo '<pre>';
            var_dump($var);
            echo '</pre>';
            exit;
    }
}

if (!function_exists('mh_cfg')) {

    function mh_cfg($constantName, $fallback_value = null)
    {
        if (is_string($constantName) && defined($constantName)) {
            return constant($constantName);
        }
        return $fallback_value;
    }
}
/**
 * Fetch a language constant by name with optional fallback.
 * @param string $constantName
 * @param mixed $fallback_value
 * @return mixed
 */
if (!function_exists('mh_lng')) {

    function mh_lng($constantName, $fallback_value = null)
    {
        if (is_string($constantName) && defined($constantName)) {
            return constant($constantName);
        }
        return $fallback_value;
    }
}

/**
 * Define a constant if not already defined.
 * @param string $const
 * @param mixed $value
 * @return void
 */

if (!function_exists('mh_define')) {
    function mh_define($const, $value)
    {
        if (is_string($const) && $const !== '' && !defined($const)) {
            define($const, $value);
        }
    }
}

/**
 * Get a value from $_GET with optional validation/type handling.
 * Examples: mh_get('page', 1, 'int'), mh_get('ids', [], 'array:int')
 * @param string $name
 * @param mixed $fallback
 * @param string $type
 * @return mixed
 */

if (!function_exists('mh_get')) {

    function mh_get($name, $fallback = null, $type = 'string')
    {
        return \Components\Common\Request::get((string)$name, $fallback, (string)$type);
    }
}

/**
 * Clean and validate an input value according to $type.
 * Thin wrapper delegating to Request::cleanInput().
 * @param mixed $value
 * @param mixed $fallback
 * @param string $type
 * @return mixed
 */

if (!function_exists('mh_clean_input')) {

    function mh_clean_input($value, $fallback = null, $type = 'string')
    {
        return \Components\Common\Request::cleanInput($value, $fallback, (string)$type);
    }
}

/**
 * Read from $_SESSION with optional nested path using '->' or '.' separators.
 * @param string $name
 * @param mixed $fallback
 * @return mixed
 */
if (!function_exists('mh_session')) {

    function mh_session($name, $fallback = null)
    {
        return \Components\Common\Request::session((string)$name, $fallback);
    }
}

/**
 * Get a value from $_POST. If $type is provided, apply mh_clean_input.
 * Supports nested access via '->' or '.' in $name.
 * @param string $name
 * @param mixed $fallback
 * @param string|null $type
 * @return mixed
 */
if (!function_exists('mh_post')) {

    function mh_post($name, $fallback = null, $type = null)
    {
        return \Components\Common\Request::post((string)$name, $fallback, $type === null ? null : (string)$type);
    }
}

/**
 * Get a value from $_REQUEST. If $type is provided, apply mh_clean_input.
 * @param string $name
 * @param mixed $fallback
 * @param string|null $type
 * @return mixed
 */

if (!function_exists('mh_request')) {

    function mh_request($name, $fallback = null, $type = null)
    {
        return \Components\Common\Request::request((string)$name, $fallback, $type === null ? null : (string)$type);
    }
}


/**
 * Get a value from $_SERVER safely.
 * @param string $name
 * @param mixed $fallback
 * @return mixed
 */
if (!function_exists('mh_server')) {

    function mh_server($name, $fallback = null)
    {
        return \Components\Common\Request::server((string)$name, $fallback);
    }
}

// ----------------- Data access helpers via DataRegistry -----------------
if (!function_exists('mb_plan_info')) {
    /**
     * Fetch plan info via DataRegistry, independent of mock/live mode.
     * @return array
     */
    function mb_plan_info(): array
    {
        return \Components\Data\DataRegistry::plan()->current();
    }
}

if (!function_exists('mb_modules_provider')) {
    /**
     * Get the modules provider (mock/live based on BEEZ_UI_DEV)
     * @return \Components\Data\Contracts\ModuleProvider
     */
    function mb_modules_provider(): \Components\Data\Contracts\ModuleProvider
    {
        return \Components\Data\DataRegistry::modules();
    }
}
