<?php
// components/routes.php
use Components\Router;

// Define common URL sync parameters (always included)
Router::setUrlSyncCommon([Router::tabParam()]);

// Register app routes in one place
Router::add('dashboard', 'pages/dashboard.php');
Router::add('trigger', 'pages/trigger.php', ['urlSyncParams' => ['group', 'layout']]);
Router::add('trigger_sort', 'pages/trigger_sort.php');
Router::add('newsletter', 'pages/newsletter.php');
Router::add('email_preview', 'pages/email_preview.php', ['urlSyncParams' => ['url', 'device']]);
Router::add('datasources', 'pages/datasources.php');
Router::add('module_config', 'pages/module_configuration.php');
Router::add('config_submenu', 'pages/submenu/configuration.php');
Router::add('configuration', 'pages/configuration.php', ['urlSyncParams' => ['module']]);
Router::add('template_coupons', 'pages/template_coupons.php');
Router::add('config_modal_docs', 'pages/components/config_modal_docs.php');
Router::add('mode', 'pages/components/mode.php');
Router::add('plan_info', 'pages/components/plan_info.php');
Router::add('dashboard_summary', 'pages/components/dashboard_summary.php');
Router::add('buttongroup_demo', 'pages/components/buttongroup.php');
Router::add('toggle_module_status', 'pages/components/toggle_module_status.php');
Router::add('save_module_config', 'pages/components/save_module_config.php');
Router::add('save_ui_open_bulk', 'pages/components/save_ui_open_bulk.php');
Router::add('trigger_module', 'pages/components/trigger_module_route.php');
Router::add('switch_to_legacy', 'pages/components/switch_to_legacy.php');

// Wizard and its steps
Router::add('wizard', 'pages/wizard.php');
Router::add('wizard_goals', 'pages/wizard/goals.php');
Router::add('wizard_step_goal', 'pages/wizard/step_goal.php');
Router::add('wizard_step_newsletter', 'pages/wizard/step_newsletter.php');
Router::add('wizard_step_automation', 'pages/wizard/step_automation.php');
Router::add('wizard_step_remarketing', 'pages/wizard/step_remarketing.php');

// Assistant view
Router::add('assistant', 'components/Assistant/views/index.php', ['urlSyncParams' => ['module', 'flow']]);
// Assistant internal endpoints (partial views)
Router::add('assistant_step', 'components/Assistant/views/step.php', ['urlSyncParams' => ['module', 'flow']]);
Router::add('assistant_answer', 'components/Assistant/views/answer.php', ['urlSyncParams' => ['module', 'flow']]);
Router::add('assistant_back', 'components/Assistant/views/back.php', ['urlSyncParams' => ['module', 'flow']]);
Router::add('assistant_finish', 'components/Assistant/views/finish.php', ['urlSyncParams' => ['module', 'flow']]);
// Playground: model-based flow collections demo
Router::add('flow_collections_model', 'pages/playground/flow_collections_model.php');
Router::add('newsletter_campaigns_list', 'pages/components/newsletter_campaigns_list.php');
Router::add('newsletter_campaign_modal', 'pages/components/newsletter_campaign_modal.php');
Router::add('coupons_list', 'pages/components/coupons_list.php');
Router::add('coupon_modal', 'pages/components/coupon_modal.php');
Router::add('newsletter_items_list', 'pages/components/newsletter_items_list.php');
Router::add('newsletter_item_modal', 'pages/components/newsletter_item_modal.php');
Router::add('newsletter_item_delete', 'pages/components/newsletter_item_delete.php');
Router::add('newsletter_item_flow', 'pages/components/newsletter_item_flow.php');
Router::add('newsletter_item_row', 'pages/components/newsletter_item_row.php');
Router::add('newsletter_item_create_followup', 'pages/components/newsletter_item_create_followup.php');
Router::add('newsletter_item_deepcopy', 'pages/components/newsletter_item_deepcopy.php');

Router::add('audience', 'pages/audience.php');
Router::add('audience_lists', 'pages/components/audience_lists.php');
Router::add('audience_list_modal', 'pages/components/audience_list_modal.php');
Router::add('audience_list_delete', 'pages/components/audience_list_delete.php');
Router::add('audience_list_flow', 'pages/components/audience_list_flow.php');
Router::add('audience_list_count', 'pages/components/audience_list_count.php');
Router::add('audience_refresh_counts', 'pages/components/audience_refresh_counts.php');
