<?php
// pages/audience.php
use Components\Base;

require_once BEEZUI_ROOT . '/components/index.php';
require_once BEEZUI_ROOT . '/pages/layout.php';

$pageKey = 'audience';

ob_start();
?>
<div>
  <h3 class="text-lg font-semibold mb-2">Audience</h3>
</div>

<div class="mt-6">
  <div id="audience-lists"
       hx-get="<?= \Components\Router::url('audience_lists', ['partial' => 1]) ?>"
       hx-trigger="load"
       hx-swap="outerHTML">
    <div class="text-sm text-muted">Loading lists…</div>
  </div>
</div>

<div class="mt-6 flex justify-end">
  <?php
  // Add a button to refresh all cached result counts for all audiences
  echo \Components\Button::render('Refresh', [
      'variant' => 'ghost',
      'size' => 'xs',
      'icon' => Base::SVG_ROTATE_CW,
      'attrs' => [
          'data-no-global-loader' => 1,
          'hx-post' => \Components\Router::url('audience_refresh_counts', ['partial' => 1]),
          // We only want to emit an event; no DOM swap needed
          'hx-swap' => 'none',
          'hx-target' => 'body',
      ],
  ]);
  ?>
  </div>

<?php
$content = ob_get_clean();

echo layout($pageKey, $content);
