<?php
// pages/components/audience_list_delete.php
// Confirmation + deletion of an Audience (Newsletter) List entry
use Components\Router;
use Components\Models\Audience;
use Components\Support\Htmx;

$id = (int) mh_get('id', 0, 'int');
$method = (string) \mh_server('REQUEST_METHOD', 'GET');

$deleted = false;
$error = '';
$itemName = '';

if ($id > 0 && class_exists(Audience::class)) {
    try {
        $model = Audience::find($id);
        if ($model) {
            $arr = $model->toArray();
            $itemName = (string)($arr['newsletter_list_name'] ?? ('#' . $id));
        }
    } catch (\Throwable $e) { /* ignore */ }
}

if ($method === 'POST' && $id > 0) {
    try {
        $model = Audience::find($id);
        if ($model) {
            $model->delete();
            $deleted = true;
        } else {
            $error = 'List not found.';
        }
    } catch (\Throwable $e) {
        $error = 'Failed to delete list.';
    }
}

ob_start();
?>
<div class="space-y-4">
  <?php if ($deleted && $error === ''): ?>
    <div class="text-sm text-green-700 bg-green-50 rounded p-3">List deleted.</div>
  <?php else: ?>
    <div class="text-sm text-gray-800">Are you sure you want to delete this list?</div>
    <div class="rounded border border-red-200 bg-red-50 p-3 text-sm text-red-800">
      <div class="font-medium">This action cannot be undone.</div>
      <div class="text-xs mt-1">List: <?php echo \Components\Base::h($itemName); ?> (ID #<?php echo (int)$id; ?>)</div>
    </div>
    <?php if ($error !== ''): ?>
      <div class="text-sm text-red-700 bg-red-50 rounded p-2"><?php echo \Components\Base::h($error); ?></div>
    <?php endif; ?>
    <form
        hx-post="<?php echo Router::url('audience_list_delete', ['partial' => 1, 'id' => $id]); ?>"
        hx-target="#config-modal-body" hx-swap="innerHTML"
        class="flex justify-end gap-2">
      <button type="button" class="inline-flex items-center rounded-md border border-gray-200 bg-white px-3 py-1.5 text-xs font-medium text-gray-700 hover:bg-gray-50"
              onclick="try{document.getElementById('config-modal').close()}catch(e){}">Cancel</button>
      <button type="submit" class="inline-flex items-center rounded-md bg-red-600 px-3 py-1.5 text-xs font-medium text-white hover:bg-red-700">Delete</button>
    </form>
  <?php endif; ?>
</div>
<?php
// On successful delete: emit HX-Trigger and close modal (event-based refresh)
if ($deleted && $error === '') {
    try {
        Htmx::trigger('audience_lists:deleted', ['id' => (string)$id]);
        Htmx::flushTriggers();
    } catch (\Throwable $e) { /* ignore */ }
    echo '<script>(function(){try{var m=document.getElementById(' . '"config-modal"' . ');if(m&&typeof m.close===' . '"function"' . '){m.close();}}catch(e){}})();</script>';
}

$__html = ob_get_clean();
echo $__html;
