<?php
// pages/components/audience_list_flow.php
// Renders the flow visualization for a single Audience (newsletter list), intended for lazy loading via htmx

use Components\Models\Audience;
use Components\CampaignFlow\FlowViz;

$id = (int) mh_get('id', 0, 'int');

// Always buffer inline HTML
ob_start();

try {
    $model = $id > 0 ? Audience::find($id) : null;
    if (!$model) {
        ?>
        <div class="p-4 text-sm text-secondary">List not found.</div>
        <?php
        echo ob_get_clean();
        return;
    }

    // Build flow items via model method
    $flowItems = [];
    try { $flowItems = is_array($model->flow()) ? $model->flow() : []; } catch (\Throwable $e) { $flowItems = []; }

    if (empty($flowItems)) {
        ?>
        <div class="p-4 text-xs text-secondary">No flow available.</div>
        <?php
    } else {
        echo FlowViz::render($flowItems, [
            'orientation' => 'horizontal',
            'size' => 'sm',
            'editable' => false,
            'class' => 'py-2'
        ]);
    }
} catch (\Throwable $e) {
    ?>
    <div class="p-4 text-xs text-secondary">Failed to render flow.</div>
    <?php
}

echo ob_get_clean();
