<?php
// pages/components/buttongroup.php
require_once BEEZUI_ROOT . '/components/index.php';
require_once BEEZUI_ROOT . '/pages/layout.php';


ob_start();
?>
<div class="space-y-6">
  <h2 class="text-xl font-semibold">Button Group Demo</h2>
  <p class="text-gray-700 dark:text-gray-300">A segmented button group based on the provided Tailwind snippet.</p>

  <div>
    <?php
    echo \Components\ButtonGroup::render([
        ['label' => 'Years',  'active' => true],
        ['label' => 'Months', 'active' => false],
        ['label' => 'Days',   'active' => false],
    ], [
        'size' => 'sm',
        'ariaLabel' => 'Select time span',
    ]);
    ?>
  </div>

  <div class="pt-4 border-t border-gray-200 dark:border-white/10">
    <pre class="text-xs text-gray-600 dark:text-gray-400 whitespace-pre-wrap"><?php echo htmlspecialchars('echo \\Components\\ButtonGroup::render([
    ["label" => "Years",  "active" => true],
    ["label" => "Months", "active" => false],
    ["label" => "Days",   "active" => false],
], [
    "size" => "sm",
    "ariaLabel" => "Select time span",
]);', ENT_QUOTES, 'UTF-8'); ?></pre>
  </div>
</div>
<?php
$content = ob_get_clean();

echo layout($content);
