<?php
// pages/components/dashboard_summary.php
// Summary KPI widget extracted from dashboard for HTMX on-demand and auto-refresh loading
// All inline HTML is captured with output buffering

// Load data via AnalyticsProvider (wraps legacy dashboard_statsbar or returns demo values)
$emailsSent = 0;
$monthsAgo = 0;
$beginningIso = '';

// KPI buckets
$bouncedPercent = 0;
$bouncedCount = 0;
$openedPercent = 0;
$openedCount = 0;
$clickPercent = 0;
$clickCount = 0;
$orderPercent = 0;
$orderCount = 0;
$revenue = '0';
$voucherSum = '0';
$bot = null;

$summary = \Components\Data\DataRegistry::analytics()->getDashboardSummary(mh_get('dashboard_action', '') == 'refresh');;
$emailsSent     = (int)($summary['emailsSent'] ?? 0);
$monthsAgo      = (int)($summary['monthsAgo'] ?? 0);
$beginningIso   = (string)($summary['beginningIso'] ?? '');
$bouncedPercent = (int)($summary['bouncedPercent'] ?? 0);
$bouncedCount   = (int)($summary['bouncedCount'] ?? 0);
$openedPercent  = (int)($summary['openedPercent'] ?? 0);
$openedCount    = (int)($summary['openedCount'] ?? 0);
$clickPercent   = (int)($summary['clickPercent'] ?? 0);
$clickCount     = (int)($summary['clickCount'] ?? 0);
$orderPercent   = (int)($summary['orderPercent'] ?? 0);
$orderCount     = (int)($summary['orderCount'] ?? 0);
$revenue        = (string)($summary['revenue'] ?? '0');
$voucherSum     = (string)($summary['voucherSum'] ?? '0');
$bot            = $summary['bot'] ?? null;
$cache_timestamp_out  = $summary['cache_timestamp_out'] ?? null;

$radialRadius = 44;
$radialSize = 60;
$radialStroke = 10;
$rowHeight = 'h-20';

$classesLabel = 'text-secondary text-xs';
$classesRadialValue = 'absolute text-zinc-600 font-medium text-sm';

// Self URL for HTMX refresh
$selfUrl = \Components\Router::url('dashboard_summary', ['partial' => 1, 'dashboard_action' => 'refresh']);
ob_start();
?>
<div class="relative mt-8 rounded-xl -shadow-sm ring-1 ring-divider p-8 pb-10 bg-elevated" id="dashboard-summary"
     hx-get="<?= $selfUrl ?>"
     hx-trigger="every 60s"
     hx-swap="outerHTML"
     data-no-global-loader="1">
    <?php
    // Local loading overlay shown while the widget updates
    echo \Components\Base::loaderOverlay('loading-dashboard-summary', 'z-10');
    ?>
    <script>
        (function(){
            try {
                if(window.MBLoader){
                    MBLoader.bindHtmxOverlay('dashboard-summary','loading-dashboard-summary', 150);
                }
            } catch (e) { /* no-op */ }
        })();
    </script>
    <div class="absolute top-0 right-0 flex items-start justify-between mb-2">
        <div class="sr-only">Summary</div>
        <button type="button"
                class="ml-auto inline-flex items-center gap-1 rounded-bl-md  rounded-tr-xl px-2 py-1 text-xs font-normal text-secondary hover:text-primary hover:bg-muted"
                title="Refresh"
                hx-get="<?= $selfUrl ?>"
                hx-target="#dashboard-summary"
                hx-swap="outerHTML">
                <span x-data="{ date: new Date('<?php echo $cache_timestamp_out; ?>')  }" x-timeago.seconds="date"> ... </span>
            <span class="font-normal! ">

            <?= \Components\Base::SVG_REFRESH; ?>
            </span>
        </button>
    </div>

    <div class="flex justify-center-safe items-start gap-6 ">
        <!-- Emails sent summary -->
        <div class="min-w-36">
            <div class="text-3xl tracking-tight font-medium  flex items-center text-primary leading-none <?= $rowHeight; ?>">
                <?= htmlspecialchars((string)$emailsSent) ?>
            </div>
            <div class="<?= $classesLabel ?>">Emails gesendet</div>
            <div class="<?= $classesLabel ?> ">
                <?= mh_lng('MAILBEEZ_STATSBAR_LABEL_BEGIN_OF_TIME', 'since'); ?>
                <span x-data="{ date: new Date('<?php echo date('Y-m-d\TH:i:s', strtotime($bot)); ?>')  }" x-timeago="date"> ... </span>
<!--
                seit <time datetime="<?= htmlspecialchars((string)$beginningIso) ?>" lang="de" class="underline">vor <?= htmlspecialchars((string)$monthsAgo) ?> Monaten</time>
-->

            </div>
        </div>

        <div class="text-2xl text-zinc-300 flex items-center <?= $rowHeight; ?>">
            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                <path d="m9 18 6-6-6-6"/>
            </svg>
        </div>

        <!-- Bounced -->
        <div class="flex flex-col items-center">
            <div class="<?= $rowHeight; ?> flex items-center">
                <?php
                echo \Components\RadialProgress::render($bouncedPercent, [
                    'radius' => $radialRadius,
                    'size' => $radialSize,
                    'strokeWidth' => $radialStroke,
                    'colorClass' => 'text-event-bounced',
                    'trackColor' => 'text-event-bounced/20',
                    'labelClass' => $classesRadialValue,
                ]);
                ?>
            </div>
            <div class="<?= $classesLabel ?>">bounced:</div>
            <div class="<?= $classesLabel ?>"><?= htmlspecialchars((string)$bouncedCount) ?></div>
        </div>

        <div class="text-2xl text-zinc-300 flex items-center <?= $rowHeight; ?>">
            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                <path d="m9 18 6-6-6-6"/>
            </svg>
        </div>

        <!-- Opened -->
        <div class="flex flex-col items-center">
            <div class="<?= $rowHeight; ?> flex items-center">
                <?php
                echo \Components\RadialProgress::render($openedPercent, [
                    'radius' => $radialRadius,
                    'size' => $radialSize,
                    'strokeWidth' => $radialStroke,
                    'colorClass' => 'text-event-opened',
                    'trackColor' => 'text-event-opened/20',
                    'labelClass' => $classesRadialValue,
                ]);
                ?>
            </div>
            <div class="<?= $classesLabel ?>">geöffnet:</div>
            <div class="<?= $classesLabel ?>"><?= htmlspecialchars((string)$openedCount) ?></div>
        </div>

        <div class="text-2xl text-zinc-300 flex items-center <?= $rowHeight; ?>">
            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                <path d="m9 18 6-6-6-6"/>
            </svg>
        </div>

        <!-- Clicked -->
        <div class="flex flex-col items-center">
            <div class="<?= $rowHeight; ?> flex items-center">
                <?php
                echo \Components\RadialProgress::render($clickPercent, [
                    'radius' => $radialRadius,
                    'size' => $radialSize,
                    'strokeWidth' => $radialStroke,
                    'colorClass' => 'text-event-clicked',
                    'trackColor' => 'text-event-clicked/20',
                    'labelClass' => $classesRadialValue,
                ]);
                ?>
            </div>
            <div class="<?= $classesLabel ?>">geklickt:</div>
            <div class="<?= $classesLabel ?>"><?= htmlspecialchars((string)$clickCount) ?></div>
        </div>

        <div class="text-2xl text-zinc-300 flex items-center <?= $rowHeight; ?>">
            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                <path d="m9 18 6-6-6-6"/>
            </svg>
        </div>

        <!-- Ordered -->
        <div class="flex flex-col items-center">
            <div class="<?= $rowHeight; ?> flex items-center">
                <?php
                echo \Components\RadialProgress::render($orderPercent, [
                    'radius' => $radialRadius,
                    'size' => $radialSize,
                    'strokeWidth' => $radialStroke,
                    'colorClass' => 'text-event-ordered',
                    'trackColor' => 'text-event-ordered/20',
                    'labelClass' => $classesRadialValue,
                ]);
                ?>
            </div>
            <div class="<?= $classesLabel ?>">bestellt:</div>
            <div class="<?= $classesLabel ?>"><?= htmlspecialchars((string)$orderCount) ?></div>
        </div>

        <div class="text-2xl text-zinc-300 flex items-center <?= $rowHeight; ?>">
            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                <path d="m9 18 6-6-6-6"/>
            </svg>
        </div>

        <!-- Revenue -->
        <div>
            <div class="ml-auto text-right">
                <div class="text-3xl tracking-tight  font-medium  flex items-center justify-end text-primary  leading-none  <?= $rowHeight; ?>">
                    <?= htmlspecialchars($revenue) ?>
                </div>
                <div class="<?= $classesLabel ?>">Umsatz (subtotal)</div>
                <div class="<?= $classesLabel ?>">Summe Gutscheine: <?= htmlspecialchars($voucherSum) ?></div>
            </div>
        </div>

    </div>
</div>
<?php
// Emit buffered HTML so this component can be loaded standalone
echo ob_get_clean();
