<?php


// Helper: get current status from session, then constant, then default
function mb_get_status(): string {
    $s = (string) mh_session('MAILBEEZ_STATUS', '');
    if ($s !== '') {
        return $s === 'simulation' ? 'simulation' : 'production';
    }
    if (defined('MAILBEEZ_STATUS')) {
        return MAILBEEZ_STATUS === 'simulation' ? 'simulation' : 'production';
    }
    return 'production';
}

// Handle HTMX POST to update status in session
if (mh_server('REQUEST_METHOD', 'GET') === 'POST') {
    $new = strtolower(trim((string) mh_post('status', '', 'string')));
    if ($new !== 'production' && $new !== 'simulation') {
        $new = 'production';
    }
    $_SESSION['MAILBEEZ_STATUS'] = $new;
    // After updating, continue to render updated component HTML (HTMX will swap it)
}

$status = mb_get_status();
$isProd = ($status === 'production');
$bgMain = $isProd ? 'bg-green-600 dark:bg-green-500 hover:bg-green-700 dark:hover:bg-green-400' : 'bg-orange-500 dark:bg-orange-500 hover:bg-orange-600 dark:hover:bg-orange-400';
$outline = $isProd ? 'focus-visible:outline-green-400 dark:focus-visible:outline-green-400' : 'focus-visible:outline-orange-400 dark:focus-visible:outline-orange-400';
$label = $isProd ? 'Production' : 'Simulation';
$toggleTo = $isProd ? 'simulation' : 'production';
?>



<div id="mode-component">
  <el-select name="selected" value="<?php echo htmlspecialchars($status, ENT_QUOTES, 'UTF-8'); ?>">
    <div class="inline-flex divide-x divide-white/20 rounded-md outline-hidden">
      <div class="inline-flex items-center gap-x-1.5 rounded-l-md <?php echo $bgMain; ?> px-3 py-2 text-white">
        <svg viewBox="0 0 20 20" fill="currentColor" aria-hidden="true" class="-ml-0.5 size-5">
          <path d="M16.704 4.153a.75.75 0 0 1 .143 1.052l-8 10.5a.75.75 0 0 1-1.127.075l-4.5-4.5a.75.75 0 0 1 1.06-1.06l3.894 3.893 7.48-9.817a.75.75 0 0 1 1.05-.143Z" clip-rule="evenodd" fill-rule="evenodd" />
        </svg>
        <el-selectedcontent class="text-sm font-semibold"><?php echo htmlspecialchars($label, ENT_QUOTES, 'UTF-8'); ?></el-selectedcontent>
      </div>
      <button type="button"
              aria-label="Toggle system mode"
              class="inline-flex items-center rounded-l-none rounded-r-md <?php echo $bgMain; ?> p-2 <?php echo $outline; ?>"


      >
        <svg viewBox="0 0 20 20" fill="currentColor" aria-hidden="true" class="size-5 text-white">
          <path d="M5.22 8.22a.75.75 0 0 1 1.06 0L10 11.94l3.72-3.72a.75.75 0 1 1 1.06 1.06l-4.25 4.25a.75.75 0 0 1-1.06 0L5.22 9.28a.75.75 0 0 1 0-1.06Z" clip-rule="evenodd" fill-rule="evenodd" />
        </svg>
      </button>
    </div>

    <el-options anchor="bottom end" popover class="w-72 origin-top-right divide-y divide-gray-200 overflow-hidden rounded-md bg-white shadow-lg outline-1 outline-black/5 [--anchor-gap:--spacing(2)] data-leave:transition data-leave:transition-discrete data-leave:duration-100 data-leave:ease-in data-closed:data-leave:opacity-0 dark:divide-white/10 dark:bg-gray-800 dark:shadow-none dark:-outline-offset-1 dark:outline-white/10">
      <el-option value="production"
                 class="group/option block cursor-default p-4 text-sm text-gray-900 select-none focus:bg-green-600 focus:text-white focus:outline-hidden dark:text-white dark:focus:bg-green-500"
                 hx-post="<?= \Components\Router::url('mode', ['partial' => 1]); ?>"
                 hx-vals='{"status":"production"}'
                 hx-target="#mode-component"
                 hx-trigger="click"
                 hx-swap="outerHTML"
      >
        <div class="flex flex-col">
          <div class="flex justify-between">
            <p class="font-normal group-aria-selected/option:font-semibold in-[el-selectedcontent]:font-semibold">Production</p>
            <span class="text-green-600 group-not-aria-selected/option:hidden group-focus/option:text-white in-[el-selectedcontent]:hidden dark:text-green-400">
              <svg viewBox="0 0 20 20" fill="currentColor" aria-hidden="true" class="size-5">
                <path d="M16.704 4.153a.75.75 0 0 1 .143 1.052l-8 10.5a.75.75 0 0 1-1.127.075l-4.5-4.5a.75.75 0 0 1 1.06-1.06l3.894 3.893 7.48-9.817a.75.75 0 0 1 1.05-.143Z" clip-rule="evenodd" fill-rule="evenodd" />
              </svg>
            </span>
          </div>
          <p class="mt-2 text-gray-500 group-focus/option:text-green-200 in-[el-selectedcontent]:hidden dark:text-gray-400 dark:group-focus/option:text-green-100">Live sending enabled.</p>
        </div>
      </el-option>

      <el-option value="simulation"
                 class="group/option block cursor-default p-4 text-sm text-gray-900 select-none focus:bg-orange-500 focus:text-white focus:outline-hidden dark:text-white dark:focus:bg-orange-500"
                 hx-post="<?= \Components\Router::url('mode', ['partial' => 1]); ?>"
                 hx-vals='{"status":"simulation"}'
                 hx-target="#mode-component"
                 hx-trigger="click"
                 hx-swap="outerHTML">
        <div class="flex flex-col">
          <div class="flex justify-between">
            <p class="font-normal group-aria-selected/option:font-semibold in-[el-selectedcontent]:font-semibold">Simulation</p>
            <span class="text-orange-500 group-not-aria-selected/option:hidden group-focus/option:text-white in-[el-selectedcontent]:hidden dark:text-orange-400">
              <svg viewBox="0 0 20 20" fill="currentColor" aria-hidden="true" class="size-5">
                <path d="M16.704 4.153a.75.75 0 0 1 .143 1.052l-8 10.5a.75.75 0 0 1-1.127.075l-4.5-4.5a.75.75 0 0 1 1.06-1.06l3.894 3.893 7.48-9.817a.75.75 0 0 1 1.05-.143Z" clip-rule="evenodd" fill-rule="evenodd" />
              </svg>
            </span>
          </div>
          <p class="mt-2 text-gray-500 group-focus/option:text-orange-200 in-[el-selectedcontent]:hidden dark:text-gray-400 dark:group-focus/option:text-orange-100">No live sending. Safe test mode.</p>
        </div>
      </el-option>
    </el-options>
  </el-select>
</div>
