<?php
// pages/components/newsletter_item_delete.php
// Confirmation + deletion of a Newsletter Item entry
use Components\Router;
use Components\Support\Htmx;
use Components\Models\NewsletterItem;

$id = (int) mh_get('id', 0, 'int');
$method = (string) \mh_server('REQUEST_METHOD', 'GET');

$deleted = false;
$error = '';
$itemName = '';

if ($id > 0 && class_exists(NewsletterItem::class)) {
    try {
        $model = NewsletterItem::find($id);
        if ($model) {
            $arr = $model->toArray();
            $itemName = (string)($arr['newsletter_item_name'] ?? ('#' . $id));
        }
    } catch (\Throwable $e) { /* ignore */ }
}

if ($method === 'POST' && $id > 0) {
    try {
        $model = NewsletterItem::find($id);
        if ($model) {
            $model->delete();
            $deleted = true;
            // Emit resource-specific delete trigger for Pattern A listeners
            try { Htmx::trigger('newsletter_item:deleted', ['id' => (string)$id]); } catch (\Throwable $e) { /* ignore */ }
            try { Htmx::flushTriggers(); } catch (\Throwable $e) { /* ignore */ }
        } else {
            $error = 'Item not found.';
        }
    } catch (\Throwable $e) {
        $error = 'Failed to delete item.';
    }
}

ob_start();
?>
<div class="space-y-4">
  <?php if ($deleted && $error === ''): ?>
    <div class="text-sm text-green-700 bg-green-50 rounded p-3">Item deleted.</div>
  <?php else: ?>
    <div class="text-sm text-gray-800">Are you sure you want to delete this item?</div>
    <div class="rounded border border-red-200 bg-red-50 p-3 text-sm text-red-800">
      <div class="font-medium">This action cannot be undone.</div>
      <div class="text-xs mt-1">Item: <?php echo \Components\Base::h($itemName); ?> (ID #<?php echo (int)$id; ?>)</div>
    </div>
    <?php if ($error !== ''): ?>
      <div class="text-sm text-red-700 bg-red-50 rounded p-2"><?php echo \Components\Base::h($error); ?></div>
    <?php endif; ?>
    <form
        hx-post="<?php echo Router::url('newsletter_item_delete', ['partial' => 1, 'id' => $id]); ?>"
        hx-target="#config-modal-body" hx-swap="innerHTML"
        class="flex justify-end gap-2">
      <button type="button" class="inline-flex items-center rounded-md border border-gray-200 bg-white px-3 py-1.5 text-xs font-medium text-gray-700 hover:bg-gray-50"
              onclick="try{document.getElementById('config-modal').close()}catch(e){}">Cancel</button>
      <button type="submit" class="inline-flex items-center rounded-md bg-red-600 px-3 py-1.5 text-xs font-medium text-white hover:bg-red-700">Delete</button>
    </form>
  <?php endif; ?>
</div>
<?php
// On successful delete: refresh list via OOB and close modal
if ($deleted && $error === '') {
    try {
        $_GET = array_merge($_GET, ['oob' => 1]);
        $path = Router::path('newsletter_items_list');
        if (is_string($path) && $path !== '') {
            include BEEZUI_ROOT . '/' . ltrim($path, '/');
        }
    } catch (\Throwable $e) { /* ignore */ }
    echo '<script>(function(){try{var m=document.getElementById(' . '"config-modal"' . ');if(m&&typeof m.close===' . '"function"' . '){m.close();}}catch(e){}})();</script>';
}

$__html = ob_get_clean();
echo $__html;
