<?php
// pages/components/newsletter_item_row.php
// Returns a single NewsletterItem row fragment so #item-* can self-refresh (Pattern A)

use Components\Models\NewsletterItem;
use Components\Resources\ItemList;

$id = (int) mh_get('id', 0, 'int');

ob_start();

try {
    $it = $id > 0 ? NewsletterItem::find($id) : null;
    if (!$it) {
        echo '<div class="p-2 text-xs text-secondary">Item not found.</div>';
        echo ob_get_clean();
        return;
    }

    $name = (string)($it->newsletter_item_name ?? ('Item ' . $id));
    $status = (string)($it->status ?? '');
    $items = [[
        'id' => $id,
        'name' => $name,
        'status' => $status,
        'icon' => $it->icon ?? [ 'svg' => \Components\Base::SVG_MAIL, 'color' => 'bg-indigo-500 text-white', 'variant' => 'solid', 'shape' => 'square' ],
        '__model' => $it,
    ]];
    // Expand content will be lazy-loaded via ItemList's expand_lazy_url option

    // Render a list with a single item; hx-select on the caller ensures only #item-* is swapped
    echo ItemList::render(NewsletterItem::itemListOptions([
        'title' => '',
        'items' => $items,
    ]));
} catch (\Throwable $e) {
    echo '<div class="p-2 text-xs text-secondary">Failed to render item row.</div>';
}

echo ob_get_clean();
