<?php
// pages/components/notification_common.php
// Common notification bar component
// All inline HTML is captured with output buffering
// Usage:
//   // optionally set before include:
//   // $message = '...'; $linkLabel = '...'; $href = '...';
//   include BEEZUI_ROOT . '/pages/components/notification_common.php';

$linkLabel = mh_lng('MH_BUTTON_BACK') . ' MailBeez V4';

//echo mh_session('language_code', 'en');

if (mh_session('language_code') == 'de') {
    $message = 'MailBeez V5 Vorschau-Version mit nur wenigen Funktionen';
} else {
    $message = 'MailBeez V5 Preview Version with limited features';
}


// Defaults (can be overridden by defining these vars before including this file)
$message   = isset($message) ? (string)$message : 'A new software update is available. See what’s new in version 2.0.4.';
$linkLabel = isset($linkLabel) ? (string)$linkLabel : 'Details';
$href      = isset($href) ? (string)$href : \Components\Router::url('switch_to_legacy', ['partial' => 1]);

ob_start();
?>
    <div class="rounded-md bg-brand-50 p-4 outline outline-brand-500 dark:bg-brand-500/10 dark:outline dark:outline-brand-500/20 my-4">
        <div class="flex">
            <div class="shrink-0">
                <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="size-5 text-brand-500">
                    <path stroke-linecap="round" stroke-linejoin="round" d="m11.25 11.25.041-.02a.75.75 0 0 1 1.063.852l-.708 2.836a.75.75 0 0 0 1.063.853l.041-.021M21 12a9 9 0 1 1-18 0 9 9 0 0 1 18 0Zm-9-3.75h.008v.008H12V8.25Z" />
                </svg>

            </div>
            <div class="ml-3 flex-1 md:flex md:justify-between">
                <p class="text-sm text-brand-700 dark:text-brand-300"><?= htmlspecialchars($message, ENT_QUOTES, 'UTF-8'); ?></p>
                <p class="mt-3 text-sm md:mt-0 md:ml-6">


                    <a href="<?= htmlspecialchars($href, ENT_QUOTES, 'UTF-8'); ?>" class="font-medium whitespace-nowrap text-brand-700 hover:text-brand-600 dark:text-blue-300 dark:hover:text-brand-200">
                        <?= $linkLabel ?>
                        <span aria-hidden="true"> &rarr;</span>
                    </a>
                </p>
            </div>
        </div>
    </div>
<?php
// Echo captured output so includes act as components
echo ob_get_clean();
