<?php
// pages/configuration.php
require_once BEEZUI_ROOT . '/components/index.php';
require_once BEEZUI_ROOT . '/pages/layout.php';


$submenuPath = 'pages/submenu/configuration.php';

// Determine initial module from URL to auto-load its configuration on first render
$initialModule = mh_get('module', 'overview', 'key');

$pageKey = 'configuration';

if ($initialModule !== '' && $initialModule !== 'overview') {
    // Use an HTMX auto-request to load the module configuration into #app-main on page load
    $content = '<div hx-get="' . route('module_config', ['module' => $initialModule, 'mode' => 'edit']) . '" hx-target="#app-main-' . $pageKey . '" hx-swap="innerHTML" hx-trigger="load"></div>';
} else {
    ob_start(); ?>
    <div hx-target="#app-main-<?= $pageKey ?>" hx-swap="innerHTML">
        <?php include BEEZUI_ROOT . '/pages/components/configuration_overview.php'; ?>
    </div>
    <?php
    $content = ob_get_clean();

}

echo layout($pageKey, $content, $submenuPath);