<?php
// pages/layout.php
// Defines the page layout: main content with optional secondary column (submenu)
// Accepts raw HTML content or a file path to include. Same for $submenu.

if (!defined('BEEZUI_ROOT')) {
    // This file resides in <root>/pages
    define('BEEZUI_ROOT', dirname(__DIR__));
}



function layout($containerId = 'main', $content = 'no content', $submenu = null, $secondaryWidth = '72')
{
    // Resolve content HTML (string or include file)
    $contentHtml = '';
    if (is_string($content) && $content !== '' && is_file($content)) {
        ob_start();
        include $content;
        $contentHtml = ob_get_clean();
    } else {
        $contentHtml = (string)$content;
    }

    // Resolve submenu HTML (string or include file)
    $submenuHtml = '';
    if ($submenu) {
        if (is_string($submenu) && $submenu !== '') {
            // If it's a file path (absolute or relative to project root), try to include
            $submenuPath = $submenu;
            // Allow paths relative to project root or to this pages directory
            if (!is_file($submenuPath)) {
                $rootRelative = BEEZUI_ROOT . DIRECTORY_SEPARATOR . ltrim($submenu, '/');
                if (is_file($rootRelative)) {
                    $submenuPath = $rootRelative;
                } else {
                    $pagesRelative = BEEZUI_ROOT . DIRECTORY_SEPARATOR . 'pages' . DIRECTORY_SEPARATOR . ltrim($submenu, '/');
                    if (is_file($pagesRelative)) {
                        $submenuPath = $pagesRelative;
                    }
                }
            }
            if (is_file($submenuPath)) {
                ob_start();
                include $submenuPath;
                $submenuHtml = ob_get_clean();
            } else {
                // Treat as raw HTML
                $submenuHtml = (string)$submenu;
            }
        }
    }

    $hasSubmenu = trim($submenuHtml) !== '';
    $asideWidthClass = 'w-' . $secondaryWidth;
    $mainInnerPadClass = $hasSubmenu ? ('ml-' . $secondaryWidth) : '';
    $asideVisibilityClass = $hasSubmenu ? 'block' : 'hidden';

    ob_start();
    ?>
<!--        help tailwind to generate the correct classes -->
    <div class="w-96 ml-96 left-96 hidden"></div>
    <div class="w-72 ml-72 left-72 hidden"></div>
    <div class="w-64 ml-64 left-64 hidden"></div>
    <div class="w-60 ml-60 left-60 hidden"></div>
    <container id="app-container-<?php echo $containerId; ?>" class="z-0">
        <main class="ml-<?= BEEZUI_NAV_WIDTH ?> group-data-[collapsed=true]/collapse:ml-20 transition-all duration-300 ease-in-out">
            <div id="main-inner" class="<?php echo $mainInnerPadClass ?> relative overflow-scroll">

                <div class="px-4 py-10 sm:px-6 lg:px-8 lg:py-6  min-w-xl">
            <!-- common notification -->
            <?php include BEEZUI_ROOT . '/pages/components/notification_common.php'; ?>
            <!-- common notification -->
                    <div id="app-main-<?php echo $containerId; ?>" class="min-h-48">
                        <?php echo $contentHtml ?>
                    </div>
                </div>
            </div>
        </main>
        <?php if ($hasSubmenu) { ?>
            <aside id="secondary-column"
                   class="fixed inset-y-0 left-<?= BEEZUI_NAV_WIDTH ?> group-data-[collapsed=true]/collapse:left-20 <?php echo $asideWidthClass ?> overflow-y-auto  px-4 py-6 sm:px-6 lg:px-8 <?php echo $asideVisibilityClass ?> transition-all duration-300 ease-in-out dark:border-white/10">
                <div id="secondary-column-body">
                    <?php echo $submenuHtml ?>
                </div>
            </aside>
        <?php } ?>

    </container>
    <?php
    return ob_get_clean();
}
