<?php
// pages/wizard/goals.php
// Returns an array of wizard goals to be rendered by step_goal.php
// Each goal: key, title, desc, icon (inline SVG), target (relative hx-get path)

return [
    [
        'key' => 'remarketing',
        'title' => 'Activate a remarketing module',
        'desc' => 'Pick a ready‑made automation (like Abandoned Cart) and turn it on.',
        'icon' => '<svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.5" class="size-6"><path d="M3 12a9 9 0 1 0 9-9" stroke-linecap="round" stroke-linejoin="round"/><path d="M3 4v8h8" stroke-linecap="round" stroke-linejoin="round"/></svg>',
        'target' => 'pages/wizard/step_remarketing.php',
    ],
    [
        'key' => 'newsletter',
        'title' => 'Send a newsletter',
        'desc' => 'Reach everyone or a specific segment with a one‑time email.',
        'icon' => '<svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.5" class="size-6"><path d="M21 12a9 9 0 1 1-18 0 9 9 0 0 1 18 0Z"/><path d="M8 12h8M8 9h8M8 15h5" stroke-linecap="round"/></svg>',
        'target' => 'pages/wizard/step_newsletter.php',
    ],
    [
        'key' => 'automation',
        'title' => 'Create an automation from a segment',
        'desc' => 'Choose a customer segment and set a simple trigger to run automatically.',
        'icon' => '<svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.5" class="size-6"><path d="M4 7h16M4 12h16M4 17h10" stroke-linecap="round"/></svg>',
        'target' => 'pages/wizard/step_automation.php',
    ],
];
