<?php
// pages/wizard/step_automation.php
?>
<div class="space-y-6">
  <div class="flex items-center justify-between">
    <h2 class="text-xl font-semibold">Create an automation from a segment</h2>
    <button class="text-sm text-brand-600 hover:underline"
            hx-get="<?= \Components\Router::url('wizard_step_goal', ['partial' => 1]); ?>"
            hx-target="#wizard-body"
            hx-swap="innerHTML">Back</button>
  </div>
  <p class="text-gray-600 dark:text-gray-300">Pick who should receive it and when it should run. We’ll prepare the basics for you.</p>

  <form id="automation-builder" class="space-y-4" onsubmit="return false;">
    <div>
      <label for="auto-segment" class="block text-sm text-gray-700 dark:text-gray-300 mb-1">Choose a segment</label>
      <select id="auto-segment" name="segment" class="w-full rounded border border-gray-300 dark:border-white/10 bg-white dark:bg-gray-800 px-3 py-2 text-sm">
        <option value="inactive_90">Inactive: no order in 90 days</option>
        <option value="vip">VIP customers</option>
        <option value="new">New customers</option>
      </select>
    </div>

    <div>
      <label for="auto-trigger" class="block text-sm text-gray-700 dark:text-gray-300 mb-1">Choose a trigger</label>
      <select id="auto-trigger" name="trigger" class="w-full rounded border border-gray-300 dark:border-white/10 bg-white dark:bg-gray-800 px-3 py-2 text-sm">
        <option value="on_segment_entry">When someone enters the segment</option>
        <option value="after_last_order_30">30 days after last order</option>
        <option value="birthday">On customer birthday</option>
      </select>
    </div>

    <div class="pt-2 flex items-center gap-3">
      <button class="inline-flex items-center px-3 py-2 text-sm font-medium text-white bg-brand rounded hover:bg-brand-700"
              hx-get="<?= \Components\Router::url('trigger', ['partial' => 1]); ?>"
              hx-target="#app-container"
              hx-swap="innerHTML"
              hx-push-url="<?= \Components\Router::url('trigger'); ?>">
        Create Automation
      </button>
      <span class="text-xs text-gray-500">We’ll take you to the Trigger to fine‑tune and activate.</span>
    </div>
  </form>
</div>
