<?php
// pages/wizard/step_goal.php
require_once BEEZUI_ROOT . '/components/index.php';

use Components\ModuleLoader;
$goals = include __DIR__ . '/goals.php';

// Define a selection of typical configuration tasks by module keys
// You can change the order or keys here to adjust which tasks are shown
$typicalTaskKeys = [
    'email_engine',
    'analytics',
    'reports',
    'template_designer',
];

// Build task items with title and routes; skip unknown keys gracefully
$typicalTasks = [];
foreach ($typicalTaskKeys as $key) {
    if (!ModuleLoader::exists($key)) { continue; }
    $typicalTasks[] = [
        'key'    => $key,
        'title'  => ModuleLoader::title($key) ?? ucwords(str_replace('_', ' ', $key)),
        'hxGet'  => route('configuration', ['module' => $key]),
        'hxPush' => route('configuration', ['module' => $key]),
    ];
}
?>
<div class="space-y-8">
  <div class="space-y-4">
    <h2 class="text-xl font-semibold">What would you like to achieve?</h2>
    <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
      <?php foreach ($goals as $g): ?>
        <?php
        $bodyHtml = '<div class="flex items-start gap-3">'
                  . '<div class="mt-1 text-brand-600 dark:text-brand-400">' . $g['icon'] . '</div>'
                  . '<div><p class="text-sm text-gray-600 dark:text-gray-300">' . \Components\Base::h($g['desc']) . '</p></div>'
                  . '</div>';
        $cardHtml = \Components\Card::render($g['title'], $bodyHtml, null, 'hover:border-brand-300 hover:shadow-sm cursor-pointer');
        // Map goal keys to wizard routes
        $routeMap = [
            'remarketing' => 'wizard_step_remarketing',
            'newsletter'  => 'wizard_step_newsletter',
            'automation'  => 'wizard_step_automation',
        ];
        $routeName = $routeMap[$g['key']] ?? 'wizard_step_goal';
        $hxGet = \Components\Router::url($routeName, ['partial' => 1]);
        ?>
        <a href="#"
           hx-get="<?= \Components\Base::h($hxGet); ?>"
           hx-target="#wizard-body"
           hx-swap="innerHTML"
           class="block">
          <?php echo $cardHtml; ?>
        </a>
      <?php endforeach; ?>
    </div>
  </div>

  <?php if (!empty($typicalTasks)) : ?>
  <div class="space-y-3">
    <h3 class="text-lg font-semibold">Typical tasks</h3>
    <div class="grid grid-cols-2 sm:grid-cols-3 md:grid-cols-4 gap-3">
      <?php foreach ($typicalTasks as $t): ?>
        <a href="#"
           class="inline-flex items-center justify-center gap-2 rounded-md border border-gray-200 bg-white px-3 py-2 text-sm font-medium text-gray-700 shadow-sm hover:border-brand-300 hover:text-brand-700 dark:border-white/10 dark:bg-white/5 dark:text-gray-200 dark:hover:border-white/20 dark:hover:text-white"
           hx-get="<?php echo \Components\Base::h($t['hxGet']); ?>"
           hx-target="#app-container"
           hx-swap="innerHTML"
           hx-push-url="<?php echo \Components\Base::h($t['hxPush']); ?>">
          <i data-lucide="settings" class="size-4 text-gray-400"></i>
          <span><?php echo \Components\Base::h($t['title']); ?></span>
        </a>
      <?php endforeach; ?>
    </div>
  </div>
  <?php endif; ?>
</div>
